/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * ExpressionDataset.java
 *
 * Created on October 18, 2007, 2:20 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.data;

import static org.broad.igv.IGVConstants.*;

import org.broad.igv.feature.Genome;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;

/**
 *
 * @author jrobinso
 */
public class GCTDataset implements Dataset {

    private String name;
    private TrackType type =  TrackType.GENE_EXPRESSION;
    private String genomeId;
    private Genome genome;
    private String[] columnHeadings;
    private boolean normalized = false;
    private boolean logValues = false;
    /** Map colum heading -> index for effecient reverse lookup */
    private Map<String, Integer> headingIndexMap = new HashMap();
    /** Map of probe -> array of feature rowValues (i.e. a data row).  The array should
     *  be hte same size and same order as the column headings.  */
    
    Map<String, int[]> startLocationMap = new HashMap();
    Map<String, int[]> endLocationMap = new HashMap();

    /** Map of chromosome -> array of data values */
    Map<String, Map<String, float[]>> dataMap = new HashMap();

    /** Map of chromosome -> array of feature names */
    Map<String, String[]> featureNameMap = new HashMap();
    
    TrackProperties trackProperties = new TrackProperties();

    /** Creates a new instance of ExpressionDataset */
    public GCTDataset(String genomeId) {
        this.genomeId = genomeId;
        //GenomeManager.getInstance().findGenomeAndLoad(genomeId);
        this.genome = GenomeManager.getInstance().getGenome(genomeId);
        if (this.genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
    }
    
        
    // Todo -- implement
    public float getDataMin() {
        return -3f;
    }
    
    public float getDataMax() {
        return 3f;
    }


    public void setColumnHeadings(String[] columnHeadings) {
        this.columnHeadings = columnHeadings;
        for (int i = 0; i < columnHeadings.length; i++) {
            headingIndexMap.put(columnHeadings[i], i);
        }
    }

    public String[] getDataHeadings() {
        return columnHeadings;
    }

    public String getName() {
        return name;
    }

    public void setType(TrackType type) {
        this.type = type;
    }
   
    
    public TrackType getType() {
        return type;
    }
    
    public boolean isEmpty() {
        return startLocationMap.isEmpty();
    }

    public String getGenome() {
        return genomeId;
    }

    public String[] getChromosomes() {
        return startLocationMap.keySet().toArray(new String[0]);
    }

    
    public void setFeatureNames(String chr, String [] names) {
        this.featureNameMap.put(chr, names);
    }
    
    public String [] getFeatureNames(String chr) {
        return featureNameMap.get(chr);
    }
 
    public void setStartLocations(String chr, int[] startLocations) {
        this.startLocationMap.put(chr, startLocations);
    }

    public int[] getStartLocations(String chr) {
        return startLocationMap.get(chr);
    }

    public void setEndLocations(String chr, int[] endLocations) {
        this.endLocationMap.put(chr, endLocations);
    }

    public int[] getEndLocations(String chr) {

        if (chr.equals(CHR_ALL)) {
            return null;
        }

        return endLocationMap.get(chr);
    }

    // Not relevant to feature datasets
    public int getWindowSpan() {
        return -1;
    }

    public boolean isLogNormalized() {
        return normalized;
    }

    public void setData(String heading, String chr, float[] data) {
        Map<String, float[]> tmp = dataMap.get(heading);
        if (tmp == null) {
            tmp = new HashMap();
            dataMap.put(heading, tmp);
        }
        tmp.put(chr, data);
    }

    public float[] getData(String heading, String chr) {
        Map<String, float[]> tmp = dataMap.get(heading);
        if (tmp != null) {
            return tmp.get(chr);
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLogValues() {
        return logValues;
    }

    public void setLogValues(boolean logValues) {
        this.logValues = logValues;
    }

    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    public TrackProperties getTrackProperties() {
        return trackProperties;
    }
}
