/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * ExpressionProbe.java
 *
 * Created on October 31, 2007, 8:21 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.broad.igv.data;

import org.broad.igv.feature.Feature;

/**
 *
 * @author jrobinso
 */
public class ExpressionProbe implements Comparable {
    
   
    private String featureName;
    private String probe;
    private String chr = "";
    private int start = 0;
    private int end = 0;
    
    public ExpressionProbe(String probe) {
        this.probe = probe;
        this.featureName = probe;
    }

    public ExpressionProbe(String probe, String feature) {
        this.probe = probe;
        this.featureName = feature;
    }
    
    public ExpressionProbe(Feature feature) {
       this(feature.getName());
       this.chr = feature.getChromosome();
       this.start = feature.getStart();
       this.end = feature.getEnd();
    }
    
    public String getFeature() {
        return featureName;
    }
    
    public String getName() {
        return probe;
    }
    
    public void setProbe(String probe) {
        this.probe = probe;
    }
    
    public String getChr() {
        return chr;
    }
    
    public void setChr(String chr) {
        this.chr = chr;
    }
    
    public int getStart() {
        return start;
    }
    
    public void setStart(int start) {
        this.start = start;
    }
    
    public int getEnd() {
        return end;
    }
    
    public void setEnd(int end) {
        this.end = end;
    }
    
    public String toString() {
        return probe + " "  + chr + ":" + start + "-" + end;
                
    }

    public int compareTo(Object anotherProbe) {
        if(anotherProbe instanceof ExpressionProbe) {
            return getStart() - ((ExpressionProbe) anotherProbe).getStart();
        }
        else return 0;
    }

    
}
