/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.data;

import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;

/**
 *
 * @author jrobinso
 */
public interface Dataset {

    public void setName(String name);
    
    public String getName();

    public TrackType getType();

    public String getGenome();
    
    public float getDataMin();
        
    public float getDataMax();

    public String[] getChromosomes();

    public String[] getDataHeadings();

    public int[] getStartLocations(String chr);

    public int [] getEndLocations(String chr);
    
    public String [] getFeatureNames(String chr);
    
    public int getWindowSpan();
    
    public boolean isLogNormalized();

    public float[] getData(String heading, String chr);
    
    public TrackProperties getTrackProperties();


}
