/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.data;

public class DataTile2D {

    private static DataTile2D nullDataTile;

    /** Start locations */
    private int[] startLocations;

    /** End locations -- can be null */
    private int[] endLocations;

    /**
     * Array of data value arrays.  Each array contains data corresponding
     * to a specific track.  So values[5] contains the data for track number 5.
     */
    private float[][] values;

    DataTile2D(int[] startLocations, int[] endLocations, float[][] values) {
        this.startLocations = startLocations;
        this.endLocations = endLocations;
        this.values = values;
    }

    public boolean isEmpty() {
        return startLocations == null || startLocations.length == 0;
    }

    public int[] getStartLocations() {
        return startLocations;
    }

    public int[] getEndLocations() {
        return endLocations;
    }

    public float[][] getValues() {
        return values;
    }

    public static DataTile2D getNullDataTile() {
        if (nullDataTile == null) {
            nullDataTile = new DataTile2D(
                    new int[]{},
                    new int[]{},
                    new float[][]{});
        }
        return nullDataTile;
    }
}
