/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.data;

/**
 * Class is public to permit unit testing
 */
public class DataTile {

    private int[] startLocations;
    private int[] endLocations;
    private float[] values;
    private String[] featureNames;

    public DataTile(int[] startLocations, int[] endLocations, float[] values, String[] features) {
        this.startLocations = startLocations;
        this.endLocations = endLocations;
        this.values = values;
        this.featureNames = features;
    }

    public boolean isEmpty() {
        return startLocations == null || startLocations.length == 0;
    }

    public int[] getStartLocations() {
        return startLocations;
    }

    public int[] getEndLocations() {
        return endLocations;
    }

    public float[] getValues() {
        return values;
    }

    /**
     * @return the featureNames
     */
    public String[] getFeatureNames() {
        return featureNames;
    }
}
