/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.data;

import java.util.Collection;
import org.broad.igv.track.*;
import java.util.List;
import org.broad.igv.feature.LocusScore;

/**
 *
 * @author jrobinso
 */
public interface DataSource {

    double getDataMax(String chr);
    
    double getDataMin(String chr);
    
    List<LocusScore> getSummaryScoresForRange(
            String chr,
            int startLocation, 
            int endLocation, 
            int zoom);

    TrackType getTrackType();

    void setWindowFunction(WindowFunction statType);
    
    boolean isLogNormalized();

    void refreshData(long timestamp);
    
    public WindowFunction getWindowFunction();
    
    public Collection<WindowFunction> getAvailableWindowFunctions();
    

}
