/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.data;

//~--- non-JDK imports --------------------------------------------------------
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

//~--- JDK imports ------------------------------------------------------------

import java.util.List;

/**
 *
 * @author jrobinso
 */
public class CompositeScore implements LocusScore {

    List<LocusScore> scores;
    float score;
    private int start;
    private int end;

    /**
     * Constructs ...
     *    mean("Mean"),
     * median("Median"),
     * min("Minimum"),
     * max("Maximum"),
     * percentile10("10th Percentile"),
     * percentile90("90th Percentile"),
     * percentile98("98th Percentile"),
     * stddev("Standard Deviation"),
     * count("Count"),
     * density("Density");
     *
     *
     * @param scores
     * @param windowFunction
     */
    public CompositeScore(List<LocusScore> scores, WindowFunction windowFunction) {
        this.scores = scores;
        start = Integer.MAX_VALUE;
        end = -Integer.MAX_VALUE;
        for (LocusScore score : scores) {
            start = Math.min(start, score.getStart());
            end = Math.max(end, score.getEnd());
        }

        float[] data = new float[scores.size()];
        for (int i = 0; i < scores.size(); i++) {
            data[i] = scores.get(i).getScore();
        }
        score = ProcessingUtils.computeStat(data, windowFunction);
    }

    /**
     * Constructs ...
     *
     *
     * @param sc
     */
    public CompositeScore(CompositeScore sc) {
        this.scores = sc.scores;
        this.start = sc.start;
        this.end = sc.end;
        this.score = sc.score;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public CompositeScore copy() {
        return new CompositeScore(this);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getScore() {

        // Todo - implementation
        return score;
    }

    /**
     * Method description
     *
     *
     * @param confidence
     */
    public void setConfidence(float confidence) {

        // ignore
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getConfidence() {
        return 1.0f;
    }

    /**
     * Method description
     *
     *
     * @param windowFunction
     *
     * @return
     */
    public String getValueString(double position, WindowFunction windowFunction) {
        if (scores == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Composite value = " + score + " (" + windowFunction + ")<br>");
        buf.append("-------------------------------<br>");
        buf.append("Components: <br>");
        for (LocusScore s : scores) {
            buf.append(s.getValueString(position, windowFunction));
            buf.append("<br>");

        }
        return buf.toString();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getStart() {
        return start;
    }

    /**
     * Method description
     *
     *
     * @param start
     */
    public void setStart(int start) {
        this.start = start;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getEnd() {
        return end;
    }

    /**
     * Method description
     *
     *
     * @param end
     */
    public void setEnd(int end) {
        this.end = end;
    }

    public int getExtendedStart() {
        return getStart();
    }

    public int getExtendedEnd() {
        return getEnd();
    }
}
