/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

/**
 * An alternative to the preference API.  Introduced to work around limits on
 * string length in the default Linux implementation. 
 * of Preferences
 *
 * @author jrobinso
 */
public class IGVPreferences {

    private static Logger log = Logger.getLogger(IGVPreferences.class);
    static File rootDir = new File(IGVConstants.DEFAULT_IGV_DIRECTORY);
    static File prefFile = new File(rootDir, "prefs.properties");
    static Hashtable<String, String> cache = null;


    public static void put(String key, String value) {
        if (cache == null) {
            loadPreferences();
        }
        cache.put(key, value);
        storePreferences();
    }


    public static String get(String key, String defaultValue) {
        String val = get(key);
        return val == null ? defaultValue : val;
    }


    public static String get(String key) {
        if (cache == null) {
            loadPreferences();
        }
        return cache.get(key);
    }


    private static void loadPreferences() {
        cache = new Hashtable();
        if (prefFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(prefFile));
                String nextLine = null;
                while ((nextLine = reader.readLine()) != null) {
                    int idx = nextLine.indexOf('=');
                    if (idx > 0) {
                        String key = nextLine.substring(0, idx);
                        String value = nextLine.substring(idx + 1);
                        cache.put(key, value);
                    }
                }
            } catch (IOException e) {
                log.error("Error loading preferences", e);
            } finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                } catch (IOException ex) {
                    log.error("Error closing preferences file", ex);
                }
            }
        }
    }

    private static void storePreferences() {

        if (cache != null && !cache.isEmpty()) {
            PrintWriter pw = null;
            try {
                if (!rootDir.exists()) {
                    rootDir.mkdir();
                }

                pw = new PrintWriter(new BufferedWriter(new FileWriter(prefFile)));
                for (Map.Entry<String, String> entry : cache.entrySet()) {
                    pw.print(entry.getKey());
                    pw.print("=");
                    pw.println(entry.getValue());
                }
            } catch (IOException e) {
                log.error("Error loading preferences", e);
            } finally {
                if (pw != null) {
                    pw.close();
                }
            }

        }
    }
}
