/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv;

//~--- JDK imports ------------------------------------------------------------
import java.awt.Color;
import java.awt.Dimension;

import java.io.File;

import java.util.Properties;
import java.util.regex.Pattern;

import javax.swing.filechooser.FileSystemView;
import org.broad.igv.track.TrackType;

/**
 *
 * @author jrobinso
 */
public class IGVConstants {

    /**
     * CONSTANTS
     */
    final public static String CHR_ALL = "All";
    /** Field description */
    final public static int groupGap = 10;
    /** Field description */
    final public static String APPLICATION_NAME = "IGV";
    /** Field description */
    final public static String APPLICATION_LONG_NAME = "Integrative Genomics Viewer";
    /** Field description */
    final public static boolean IS_WINDOWS =
            System.getProperty("os.name").toLowerCase().startsWith("windows");
    /** Field description */
    final public static boolean IS_MAC =
            System.getProperty("os.name").toLowerCase().startsWith("mac");
    /** Field description */
    final public static boolean IS_LINUX =
            System.getProperty("os.name").toLowerCase().startsWith("linux");
    /** Field description */
    final public static Dimension preferredSize = new Dimension(1000, 750);

    // To support mutation track overlay.  Generalize later.  Cancer specific option.
    public static TrackType overlayTrackType = TrackType.MUTATION;
    // Default user folder
    /** Field description */
    private static String DEFAULT_USER_DIRECTORY;

    public static synchronized String getDefaultUserDirectory() {
        if (DEFAULT_USER_DIRECTORY == null) {

            if (IGVConstants.IS_WINDOWS) {
                DEFAULT_USER_DIRECTORY =
                        FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
            } else {
                DEFAULT_USER_DIRECTORY =
                        FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
            }
        }
        return DEFAULT_USER_DIRECTORY;
    }

    // Default user folder
    /** Field description */
    final public static String DEFAULT_IGV_DIRECTORY;
    

    static {

        StringBuffer path = new StringBuffer();
        Properties properties = System.getProperties();
        path.append(properties.getProperty("user.home"));
        path.append(properties.getProperty("file.separator"));

        if (IGVConstants.IS_MAC) {
            path.append(".igv");
        } else {
            path.append("igv");
        }
        DEFAULT_IGV_DIRECTORY = path.toString().trim();
    }
    /** Field description */
    final public static File IGV_TEMP_DIRECTORY;
    

    static {

        StringBuffer path = new StringBuffer();
        path.append(System.getProperty("java.io.tmpdir"));
        IGV_TEMP_DIRECTORY = new File(path.toString());
        if (!IGV_TEMP_DIRECTORY.exists()) {
            IGV_TEMP_DIRECTORY.mkdir();
        }
    }
    /** Field description */
    final public static File GENOME_CACHE_DIRECTORY;
    

    static {

        StringBuffer path = new StringBuffer();
        Properties properties = System.getProperties();

        if(new File(DEFAULT_IGV_DIRECTORY).exists())
        {
            path.append(DEFAULT_IGV_DIRECTORY);
            path.append(properties.getProperty("file.separator"));
        }
        
        path.append(IGVConstants.GENOME_CACHE_FOLDER_NAME);
        GENOME_CACHE_DIRECTORY = new File(path.toString());

    }
    /** Field description */
    final public static String SESSION_FILE_EXTENSION = ".xml";
    /** Field description */
    final public static String OVERWRITE_SESSION_MESSAGE =
            "<html>Opening a session will unload all current data. " + "<br>Are you sure you wish to continue?";
    /** Field description */
    final public static String NEW_SESSION_MESSAGE =
            "<html>Creating a new session will unload all current data. " + "<br>Are you sure you wish to continue?";
    /**
     * GENOME ARCHIVE CONSTANTS
     */
    final public static String GENOME_FILE_EXTENSION = ".genome";
    final public static String SERVER_GENOME_LIST_HEADER = "<Server-Side Genome List>";
    final public static String FASTA_FILE_SET_EXTENSION = ".zip";
    final public static String FASTA_GZIP_FILE_EXTENSION = ".gz";
    final public static String GENOME_ARCHIVE_PROPERTY_FILE_NAME = "property.txt";
    final public static String GENOME_ARCHIVE_ID_KEY = "id";
    final public static String GENOME_ARCHIVE_NAME_KEY = "name";
    final public static String GENOME_ARCHIVE_VERSION_KEY = "version";
    final public static String GENOME_GENETRACK_NAME = "geneTrackName";
    final public static String GENOME_ARCHIVE_CYTOBAND_FILE_KEY = "cytobandFile";
    final public static String GENOME_ARCHIVE_GENE_FILE_KEY = "geneFile";
    final public static String GENOME_ARCHIVE_SEQUENCE_FILE_LOCATION_KEY = "sequenceLocation";
    final public static String GENOME_SEQUENCE_FOLDER = "sequence";
    final public static String GENOME_CACHE_FOLDER_NAME = "genomes";
    final public static String DEFAULT_SERVER_GENOME_ARCHIVE_LIST =
            "http://www.broadinstitute.org/igv/resources/genomes/genomes.txt";
    final public static String CANNOT_ACCESS_SERVER_GENOME_LIST =
            "The Genome server is currently inaccessible.";
    final public static String INVALID_SERVER_GENOME_LIST_HEADER =
            "Genomes cannot be retrieved from the server. " + "The server-side genome list is invalid!";

    // Session Folder
    /** Field description */
    final public static String SESSION_FOLDER = "/igv_sessions";
    /** Field description */
    final public static int NUMBER_OF_RECENT_SESSIONS_TO_LIST = 3;
    /** Field description */
    final public static String DEFAULT_SESSION_FILE = "igv_session" + SESSION_FILE_EXTENSION;

    // URLs
    /** Field description */
    final static public String SERVER_BASE_URL = "http://www.broadinstitute.org/";
    /** Field description */
    final public static String IGV_LOG_SERVER_URL = SERVER_BASE_URL + "igv/LogServlet";

    // Colors
    // float[] hsb = Color.RGBtoHSB(255, 255, 210, null);
    /** Field description */
    final static public Color LIGHT_YELLOW = new Color(255, 244, 201);
    /** Field description */
    final public static Color VERY_LIGHT_GRAY = new Color(238, 239, 240);
    /** Field description */
    public static Color NO_DATA_COLOR = new Color(200, 200, 200, 150);

    // GENOME
    /** Field description */
    final static public String IMPORT_GENOME_LIST_MENU_ITEM = "Import Genome...";
    /** Field description */
    final static public String LOAD_GENOME_LIST_MENU_ITEM = "Load Genome...";
    /** Field description */
    final static public String REMOVE_GENOME_LIST_MENU_ITEM = "Remove Imported Genomes...";
    /** Field description */
    final static public String GENOME_LIST_SEPARATOR = "--SEPARATOR--";
    final static public Pattern commaPattern = Pattern.compile(",");
    final static public Pattern tabPattern = Pattern.compile("\t");
    final static public Pattern colonPattern = Pattern.compile(":");
    final static public Pattern dashPattern = Pattern.compile("-");
    final static public Pattern equalPattern = Pattern.compile("=");
}
