/*
 * The MIT License
 *
 * Copyright (c) 2009 The Broad Institute
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package edu.mit.broad.picard.util;

public class ArrayUtil {

    /**
     * Reverse the elements of the given array in place
     */
    public static <T> void reverseArray(T[] array) {
        for (int left=0, right=array.length-1; left<right; left++, right--) {
            // exchange the first and last
            T temp = array[left]; array[left]  = array[right]; array[right] = temp;
        }
    }

    /**
     * clone the above method as necessary for non-object types
     */
    public static void reverseArray(byte[] array) {
        for (int left=0, right=array.length-1; left<right; left++, right--) {
            // exchange the first and last
            byte temp = array[left]; array[left]  = array[right]; array[right] = temp;
        }
    }
}
