/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * ColorBlocks.java
 *
 * Created on November 17, 2007, 2:56 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package demos;

/**
 *
 * @author jrobinso
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import javax.swing.JFrame;
import javax.swing.JPanel;

public class ColorBlocks extends JPanel{
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        
        Dimension d = getSize();
        g2.translate(d.width / 2, d.height / 2);
        Color[] colors = {
            Color.white, Color.lightGray, Color.gray, Color.darkGray,
            Color.black, Color.red, Color.pink, Color.orange,
            Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue
        };
        float size = 25;
        float x = -size * colors.length / 2;
        float y = -size * 3 / 2;
        // Show all the predefined colors.
        for (int i = 0; i < colors.length; i++) {
            Rectangle2D r = new Rectangle2D.Float(
                    x + size * (float)i, y, size, size);
            g2.setPaint(colors[i]);
            g2.fill(r);
        }
        //a linear gradient.
        y += size;
        Color c1 = Color.yellow;
        Color c2 = Color.blue;
        for (int i = 0; i < colors.length; i++) {
            float ratio = (float)i / (float)colors.length;
            int red = (int)(c2.getRed() * ratio + c1.getRed() * (1 - ratio));
            int green = (int)(c2.getGreen() * ratio +
                    c1.getGreen() * (1 - ratio));
            int blue = (int)(c2.getBlue() * ratio +
                    c1.getBlue() * (1 - ratio));
            Color c = new Color(red, green, blue);
            Rectangle2D r = new Rectangle2D.Float(
                    x + size * (float)i, y, size, size);
            g2.setPaint(c);
            g2.fill(r);
        }
        // Show an alpha gradient.
        y += size;
        c1 = Color.red;
        for (int i = 0; i < colors.length; i++) {
            int alpha = (int)(255 * (float)i / (float)colors.length);
            Color c = new Color(c1.getRed(), c1.getGreen(),
                    c1.getBlue(), alpha);
            Rectangle2D r = new Rectangle2D.Float(
                    x + size * (float)i, y, size, size);
            g2.setPaint(c);
            g2.fill(r);
        }
        // Draw a frame around the whole thing.
        y -= size * 2;
        Rectangle2D frame = new Rectangle2D.Float(x, y, size * colors.length, size * 3);
        g2.setPaint(Color.black);
        g2.draw(frame);
    }
    
    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.getContentPane().add(new ColorBlocks());
        f.setSize(350, 250);
        f.setVisible(true);
    }
}
