/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

public class CoordMath {
    public static long getLength(long start, long end) {
        return end - start + 1L;
    }

    public static long getStart(long end, long length) {
        return end - length + 1L;
    }

    public static long getEnd(long start, long length) {
        return start + length - 1L;
    }

    public static long getStartFromOffset(long offset, long length) {
        return offset + 1L;
    }

    public static long getEndFromOffset(long offset, long length) {
        return length - offset;
    }

    public static long getLengthFromOffsets(long startOffset, long endOffset, long length) {
        return CoordMath.getLength(CoordMath.getStartFromOffset(startOffset, length), CoordMath.getEndFromOffset(endOffset, length));
    }

    public static String getSubsequence(String sequence, int begin, int end) {
        return sequence.substring(begin - 1, end);
    }

    public static boolean overlaps(long start, long end, long start2, long end2) {
        return start2 >= start && start2 <= end || end2 >= start && end2 <= end || CoordMath.encloses(start2, end2, start, end);
    }

    public static boolean encloses(long outerStart, long outerEnd, long innerStart, long innerEnd) {
        return innerStart >= outerStart && innerEnd <= outerEnd;
    }

    public static long getOverlap(long start, long end, long start2, long end2) {
        return CoordMath.getLength(Math.max(start, start2), Math.min(end, end2));
    }
}

