/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import net.sf.samtools.util.BlockGunzipper;
import net.sf.samtools.util.IOUtil;

public class BlockCompressedInputStream
extends InputStream {
    private InputStream mStream = null;
    private RandomAccessFile mFile = null;
    private byte[] mFileBuffer = null;
    private byte[] mCurrentBlock = null;
    private int mCurrentOffset = 0;
    private long mBlockAddress = 0L;
    private int mLastBlockLength = 0;
    private final BlockGunzipper blockGunzipper = new BlockGunzipper();

    public BlockCompressedInputStream(InputStream stream) {
        this.mStream = IOUtil.toBufferedStream(stream);
        this.mFile = null;
    }

    public BlockCompressedInputStream(File file) throws IOException {
        this.mFile = new RandomAccessFile(file, "r");
        this.mStream = null;
    }

    public int available() throws IOException {
        if (this.mCurrentBlock == null || this.mCurrentOffset == this.mCurrentBlock.length) {
            this.readBlock();
        }
        if (this.mCurrentBlock == null) {
            return 0;
        }
        return this.mCurrentBlock.length - this.mCurrentOffset;
    }

    public void close() throws IOException {
        if (this.mFile != null) {
            this.mFile.close();
            this.mFile = null;
        } else if (this.mStream != null) {
            this.mStream.close();
            this.mStream = null;
        }
        this.mFileBuffer = null;
        this.mCurrentBlock = null;
    }

    public int read() throws IOException {
        return this.available() > 0 ? this.mCurrentBlock[this.mCurrentOffset++] : -1;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int originalLength = length;
        while (length > 0) {
            int available = this.available();
            if (available == 0) {
                if (originalLength != length) break;
                return -1;
            }
            int copyLength = Math.min(length, available);
            System.arraycopy(this.mCurrentBlock, this.mCurrentOffset, buffer, offset, copyLength);
            this.mCurrentOffset += copyLength;
            offset += copyLength;
            length -= copyLength;
        }
        return originalLength - length;
    }

    public void seek(long pos) throws IOException {
        int available;
        if (this.mFile == null) {
            throw new IOException("Cannot seek on stream based file");
        }
        long compressedOffset = pos >> 16;
        int uncompressedOffset = (int)(pos & 0xFFFFL);
        if (this.mBlockAddress == compressedOffset && this.mCurrentBlock != null) {
            available = this.mCurrentBlock.length;
        } else {
            this.mFile.seek(compressedOffset);
            this.mBlockAddress = compressedOffset;
            this.mLastBlockLength = 0;
            this.readBlock();
            available = this.available();
        }
        if (uncompressedOffset > available || uncompressedOffset == available && !this.eof()) {
            throw new IOException("Invalid file pointer: " + pos);
        }
        this.mCurrentOffset = uncompressedOffset;
    }

    private boolean eof() throws IOException {
        return this.mFile.length() == this.mFile.getFilePointer();
    }

    public long getFilePointer() {
        return this.mBlockAddress << 16 | (long)this.mCurrentOffset;
    }

    public static boolean isValidFile(InputStream stream) throws IOException {
        if (!stream.markSupported()) {
            throw new RuntimeException("Cannot test non-buffered stream");
        }
        stream.mark(18);
        byte[] buffer = new byte[18];
        int count = BlockCompressedInputStream.readBytes(stream, buffer, 0, 18);
        stream.reset();
        return count == 18 && BlockCompressedInputStream.isValidBlockHeader(buffer);
    }

    private static boolean isValidBlockHeader(byte[] buffer) {
        return buffer[0] == 31 && (buffer[1] & 0xFF) == 139 && (buffer[3] & 4) != 0 && buffer[10] == 6 && buffer[12] == 66 && buffer[13] == 67;
    }

    private void readBlock() throws IOException {
        int count;
        if (this.mFileBuffer == null) {
            this.mFileBuffer = new byte[65536];
        }
        if ((count = this.readBytes(this.mFileBuffer, 0, 18)) == 0) {
            return;
        }
        if (count != 18) {
            throw new IOException("Premature end of file");
        }
        int blockLength = this.unpackInt16(this.mFileBuffer, 16) + 1;
        if (blockLength < 18 || blockLength > this.mFileBuffer.length) {
            throw new IOException("Unexpected compressed block length: " + blockLength);
        }
        int remaining = blockLength - 18;
        count = this.readBytes(this.mFileBuffer, 18, remaining);
        if (count != remaining) {
            throw new IOException("Premature end of file");
        }
        this.inflateBlock(this.mFileBuffer, blockLength);
        this.mCurrentOffset = 0;
        this.mBlockAddress += (long)this.mLastBlockLength;
        this.mLastBlockLength = blockLength;
    }

    private void inflateBlock(byte[] compressedBlock, int compressedLength) throws IOException {
        int uncompressedLength = this.unpackInt32(compressedBlock, compressedLength - 4);
        byte[] buffer = this.mCurrentBlock;
        this.mCurrentBlock = null;
        if (buffer == null || buffer.length != uncompressedLength) {
            buffer = new byte[uncompressedLength];
        }
        this.blockGunzipper.unzipBlock(buffer, compressedBlock, compressedLength);
        this.mCurrentBlock = buffer;
    }

    private int readBytes(byte[] buffer, int offset, int length) throws IOException {
        if (this.mFile != null) {
            return BlockCompressedInputStream.readBytes(this.mFile, buffer, offset, length);
        }
        if (this.mStream != null) {
            return BlockCompressedInputStream.readBytes(this.mStream, buffer, offset, length);
        }
        return 0;
    }

    private static int readBytes(RandomAccessFile file, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        int count;
        for (bytesRead = 0; bytesRead < length && (count = file.read(buffer, offset + bytesRead, length - bytesRead)) > 0; bytesRead += count) {
        }
        return bytesRead;
    }

    private static int readBytes(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        int count;
        for (bytesRead = 0; bytesRead < length && (count = stream.read(buffer, offset + bytesRead, length - bytesRead)) > 0; bytesRead += count) {
        }
        return bytesRead;
    }

    private int unpackInt16(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8;
    }

    private int unpackInt32(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }
}

