/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.List;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SAMUtils {
    private static final byte COMPRESSED_EQUAL_LOW = 0;
    private static final byte COMPRESSED_A_LOW = 1;
    private static final byte COMPRESSED_C_LOW = 2;
    private static final byte COMPRESSED_G_LOW = 4;
    private static final byte COMPRESSED_T_LOW = 8;
    private static final byte COMPRESSED_N_LOW = 15;
    private static final byte COMPRESSED_EQUAL_HIGH = 0;
    private static final byte COMPRESSED_A_HIGH = 16;
    private static final byte COMPRESSED_C_HIGH = 32;
    private static final byte COMPRESSED_G_HIGH = 64;
    private static final byte COMPRESSED_T_HIGH = -128;
    private static final byte COMPRESSED_N_HIGH = -16;

    SAMUtils() {
    }

    static byte[] bytesToCompressedBases(byte[] readBases) {
        int i;
        byte[] compressedBases = new byte[(readBases.length + 1) / 2];
        for (i = 1; i < readBases.length; i += 2) {
            compressedBases[i / 2] = (byte)(SAMUtils.charToCompressedBaseHigh(readBases[i - 1]) | SAMUtils.charToCompressedBaseLow(readBases[i]));
        }
        if (i == readBases.length) {
            compressedBases[i / 2] = SAMUtils.charToCompressedBaseHigh((char)readBases[i - 1]);
        }
        return compressedBases;
    }

    static byte[] compressedBasesToBytes(int length, byte[] compressedBases, int compressedOffset) {
        int i;
        byte[] ret = new byte[length];
        for (i = 1; i < length; i += 2) {
            int compressedIndex = i / 2 + compressedOffset;
            ret[i - 1] = SAMUtils.compressedBaseToByteHigh(compressedBases[compressedIndex]);
            ret[i] = SAMUtils.compressedBaseToByteLow(compressedBases[compressedIndex]);
        }
        if (i == length) {
            ret[i - 1] = SAMUtils.compressedBaseToByteHigh(compressedBases[i / 2 + compressedOffset]);
        }
        return ret;
    }

    private static byte charToCompressedBaseLow(int base) {
        switch (base) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 71: 
            case 103: {
                return 4;
            }
            case 84: 
            case 116: {
                return 8;
            }
            case 46: 
            case 78: 
            case 110: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte charToCompressedBaseHigh(int base) {
        switch (base) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 16;
            }
            case 67: 
            case 99: {
                return 32;
            }
            case 71: 
            case 103: {
                return 64;
            }
            case 84: 
            case 116: {
                return -128;
            }
            case 46: 
            case 78: 
            case 110: {
                return -16;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte compressedBaseToByteLow(int base) {
        switch (base & 0xF) {
            case 0: {
                return 61;
            }
            case 1: {
                return 65;
            }
            case 2: {
                return 67;
            }
            case 4: {
                return 71;
            }
            case 8: {
                return 84;
            }
            case 15: {
                return 78;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte compressedBaseToByteHigh(int base) {
        switch ((byte)(base & 0xF0)) {
            case 0: {
                return 61;
            }
            case 16: {
                return 65;
            }
            case 32: {
                return 67;
            }
            case 64: {
                return 71;
            }
            case -128: {
                return 84;
            }
            case -16: {
                return 78;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    static String bytesToHexString(byte[] data) {
        char[] chars = new char[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            chars[2 * i] = SAMUtils.toHexDigit(b >> 4 & 0xF);
            chars[2 * i + 1] = SAMUtils.toHexDigit(b & 0xF);
        }
        return new String(chars);
    }

    static byte[] hexStringToBytes(String s) throws NumberFormatException {
        if (s.length() % 2 != 0) {
            throw new NumberFormatException("Hex representation of byte string does not have even number of hex chars: " + s);
        }
        byte[] ret = new byte[s.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(SAMUtils.fromHexDigit(s.charAt(i * 2)) << 4 | SAMUtils.fromHexDigit(s.charAt(i * 2 + 1)));
        }
        return ret;
    }

    static void normalizeBases(byte[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = StringUtil.toUpperCase(bases[i]);
            if (bases[i] != 46) continue;
            bases[i] = 78;
        }
    }

    static String phredToFastq(byte[] data) {
        if (data == null) {
            return null;
        }
        return SAMUtils.phredToFastq(data, 0, data.length);
    }

    static String phredToFastq(byte[] buffer, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = SAMUtils.phredToFastq(buffer[offset + i] & 0xFF);
        }
        return new String(chars);
    }

    static char phredToFastq(int phredScore) {
        if (phredScore < 0 || phredScore > 63) {
            throw new IllegalArgumentException("Cannot encode phred score: " + phredScore);
        }
        return (char)(33 + phredScore);
    }

    static byte[] fastqToPhred(String fastq) {
        if (fastq == null) {
            return null;
        }
        int length = fastq.length();
        byte[] scores = new byte[length];
        for (int i = 0; i < length; ++i) {
            scores[i] = (byte)SAMUtils.fastqToPhred(fastq.charAt(i));
        }
        return scores;
    }

    static int fastqToPhred(char ch) {
        if (ch < '!' || ch > '~') {
            throw new IllegalArgumentException("Invalid fastq character: " + ch);
        }
        return ch - 33;
    }

    private static char toHexDigit(int value) {
        return (char)(value < 10 ? 48 + value : 65 + value - 10);
    }

    private static int fromHexDigit(char c) throws NumberFormatException {
        int ret = Character.digit(c, 16);
        if (ret == -1) {
            throw new NumberFormatException("Not a valid hex digit: " + c);
        }
        return ret;
    }

    static int reg2bin(int beg, int end) {
        if (beg >> 14 == --end >> 14) {
            return 4681 + (beg >> 14);
        }
        if (beg >> 17 == end >> 17) {
            return 585 + (beg >> 17);
        }
        if (beg >> 20 == end >> 20) {
            return 73 + (beg >> 20);
        }
        if (beg >> 23 == end >> 23) {
            return 9 + (beg >> 23);
        }
        if (beg >> 26 == end >> 26) {
            return 1 + (beg >> 26);
        }
        return 0;
    }

    static void processValidationErrors(List<SAMValidationError> validationErrors, long samRecordIndex, SAMFileReader.ValidationStringency validationStringency) {
        if (validationErrors != null) {
            for (SAMValidationError validationError : validationErrors) {
                validationError.setRecordNumber(samRecordIndex);
            }
            if (validationStringency == SAMFileReader.ValidationStringency.STRICT) {
                throw new RuntimeException("SAM validation error: " + validationErrors.get(0));
            }
            if (validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
                for (SAMValidationError error : validationErrors) {
                    System.err.println("Ignoring SAM validation error: " + error);
                }
            }
        }
    }
}

