/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.util.Iterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class SAMTools {
    private String mCommand = null;
    private File mInputFile = null;

    public static void main(String[] args) throws Exception {
        int status = new SAMTools().run(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    private SAMTools() {
    }

    private void usage() {
        System.out.println();
        System.out.println("SAMTools version 0.1.0");
        System.out.println("Tools for manipulating SAM/BAM files");
        System.out.println();
        System.out.println("Usage: SAMTools <command> <options...>");
        System.out.println();
        System.out.println("Commands:");
        System.out.println("  help");
        System.out.println("  view        <file>");
        System.out.println();
    }

    private boolean parseArguments(String[] args) {
        if (args.length == 0) {
            this.usage();
            return true;
        }
        String command = args[0];
        boolean argpos = true;
        int argcount = args.length - 1;
        if (command.equals("help")) {
            this.usage();
            return true;
        }
        if (command.equals("view")) {
            if (argcount != 1) {
                this.usage();
                return false;
            }
            this.mInputFile = new File(args[1]);
            if (!this.mInputFile.exists()) {
                System.out.println("Input file not found: " + this.mInputFile);
                return false;
            }
        } else {
            System.out.println("Unrecognized command: " + command);
            System.out.println();
            this.usage();
            return false;
        }
        this.mCommand = command;
        return true;
    }

    private int run(String[] args) throws Exception {
        if (!this.parseArguments(args)) {
            return 1;
        }
        if (this.mCommand == null) {
            return 0;
        }
        if (this.mCommand.equals("view")) {
            return this.runView();
        }
        return 1;
    }

    private int runView() {
        SAMFileReader reader = new SAMFileReader(this.mInputFile);
        Iterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            SAMRecord record = (SAMRecord)iterator.next();
            System.out.println(record.format());
        }
        iterator.close();
        return 0;
    }
}

