/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.samtools.AbstractSAMHeaderRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMProgramRecord
extends AbstractSAMHeaderRecord {
    public static final String PROGRAM_GROUP_ID_TAG = "ID";
    private static final String PROGRAM_VERSION_TAG = "VN";
    private static final String COMMAND_LINE_TAG = "CL";
    private final String mProgramGroupId;
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("ID", "VN", "CL"));

    public SAMProgramRecord(String programGroupId) {
        this.mProgramGroupId = programGroupId;
    }

    public String getProgramGroupId() {
        return this.mProgramGroupId;
    }

    public String getProgramVersion() {
        return (String)this.getAttribute(PROGRAM_VERSION_TAG);
    }

    public void setProgramVersion(String version) {
        this.setAttribute(PROGRAM_VERSION_TAG, version);
    }

    public String getCommandLine() {
        return (String)this.getAttribute(COMMAND_LINE_TAG);
    }

    public void setCommandLine(String commandLine) {
        this.setAttribute(COMMAND_LINE_TAG, commandLine);
    }

    public boolean equivalent(SAMProgramRecord that) {
        return this.attributesEqual(that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMProgramRecord that = (SAMProgramRecord)o;
        if (!this.attributesEqual(that)) {
            return false;
        }
        return !(this.mProgramGroupId != null ? !this.mProgramGroupId.equals(that.mProgramGroupId) : that.mProgramGroupId != null);
    }

    public int hashCode() {
        int result = this.mProgramGroupId != null ? this.mProgramGroupId.hashCode() : 0;
        result = 31 * result + this.attributesHashCode();
        return result;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }
}

