/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.util;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathUtil {
    private static final double LOG10_2 = Math.log10(2.0);

    public static double[][] roots(double[] coefs) {
        Matrix m = new Matrix(coefs.length - 1, coefs.length - 1);
        m.set(0, 0, -coefs[coefs.length - 2]);
        for (int i = 1; i < coefs.length - 1; ++i) {
            m.set(i, i - 1, 1.0);
            m.set(0, i, -coefs[coefs.length - i - 2]);
        }
        m.timesEquals(1.0 / coefs[coefs.length - 1]);
        EigenvalueDecomposition ed = m.eig();
        double[] real = ed.getRealEigenvalues();
        double[] imaginary = ed.getImagEigenvalues();
        double[][] roots = new double[real.length][2];
        for (int i = 0; i < real.length; ++i) {
            roots[i][0] = real[i];
            roots[i][1] = imaginary[i];
        }
        return roots;
    }

    public static double log2(double val) {
        return Math.log10(val) / LOG10_2;
    }

    public static double max(Collection<? extends Number> list) {
        double max = Double.NEGATIVE_INFINITY;
        if (list != null && !list.isEmpty()) {
            for (Number number : list) {
                double dn = number.doubleValue();
                if (!(dn > max)) continue;
                max = dn;
            }
        }
        return max;
    }
}

