/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.util;

import edu.mit.broad.prodinfo.util.CLUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class EmpiricDistribution {
    private double max;
    private double min;
    private double[][] intervals;
    private int[] intervalDataNumber;
    public static final String USAGE = "Usage: EmpiricDistribution TASK=<task_num> <task_args>\n\tTasks:\n\t\t1. Get empirical distribution -col <column to use 0 for the first one> [-in <Input file standard input is default> -out <output file, standard output by default> -separator <tab (\t) is default>]\t\t\t -binNum <Number of bins, default is 200> -maxValue <Maximum value to consider> -minValue <Minimum value to consider>\n\t2. Combine distributions -indir <directory> -suffix <suffix of distribution files to combine> -out <output file name defalut is standard out>\n\t3. Get quantile -probability -in <Input distribution standard input is default>\n";

    public EmpiricDistribution(int numberOfBins, double min, double max) {
        this.min = min;
        this.max = max;
        double binSize = (max - min) / (double)numberOfBins;
        this.intervals = new double[numberOfBins][2];
        this.intervalDataNumber = new int[numberOfBins];
        System.err.println("binsize " + binSize);
        for (int i = 0; i < numberOfBins; ++i) {
            this.intervals[i][0] = min + (double)i * binSize;
            this.intervals[i][1] = min + (double)(i + 1) * binSize;
            this.intervalDataNumber[i] = 0;
        }
    }

    public EmpiricDistribution(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        LinkedHashMap<Double, Integer> observations = new LinkedHashMap<Double, Integer>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            String[] lineInfo = line.split("\t");
            observations.put(Double.parseDouble(lineInfo[0]), Integer.parseInt(lineInfo[1]));
        }
        this.intervals = new double[observations.size()][2];
        this.intervalDataNumber = new int[observations.size()];
        Iterator midPointIt = observations.keySet().iterator();
        int i = 0;
        double midPoint = 0.0;
        while (midPointIt.hasNext()) {
            midPoint = (Double)midPointIt.next();
            this.intervalDataNumber[i] = (Integer)observations.get(midPoint);
            this.intervals[i][0] = midPoint;
            if (i > 0) {
                double dist = midPoint - this.intervals[i - 1][0];
                this.intervals[i - 1][1] = this.intervals[i - 1][0] + dist / 2.0;
                this.intervals[i - 1][0] = this.intervals[i - 1][1] - dist;
            }
            ++i;
        }
        this.intervals[this.intervals.length - 1][0] = this.intervals[this.intervals.length - 2][1];
        this.intervals[this.intervals.length - 1][1] = midPoint - this.intervals[this.intervals.length - 1][0] + midPoint;
    }

    public EmpiricDistribution(File source) throws IOException {
        this(new FileInputStream(source));
    }

    public void add(double observation) {
        if (observation > this.max) {
            System.err.println("Observation is to large");
            return;
        }
        if (observation < this.min) {
            System.err.println("Observation is to small");
            return;
        }
        for (int i = 0; i < this.intervals.length; ++i) {
            if (!(this.intervals[i][0] <= observation) || !(this.intervals[i][1] > observation)) continue;
            int n = i;
            this.intervalDataNumber[n] = this.intervalDataNumber[n] + 1;
            break;
        }
    }

    public double leftIntersect(EmpiricDistribution other) {
        if (this.intervalDataNumber.length != other.getIntervalDataNumber().length) {
            throw new IllegalArgumentException("Distributions must have the same number of bins");
        }
        if (this.intervals[0][0] != other.intervals[0][0] || this.intervals[this.intervals.length - 1][1] != other.intervals[this.intervals.length - 1][1]) {
            throw new IllegalArgumentException("Distributions must have the same bins");
        }
        double diff = this.getDensity(0) - other.getDensity(0);
        double intersect = (this.intervals[0][1] + this.intervals[0][0]) / 2.0;
        for (int i = 1; i < this.intervalDataNumber.length; ++i) {
            double intervalDiff = this.getDensity(i) - other.getDensity(i);
            if (diff == 0.0) {
                diff = intervalDiff;
                continue;
            }
            if (!(diff * intervalDiff < 0.0)) continue;
            intersect = (this.intervals[i][1] + this.intervals[i][0]) / 2.0;
            break;
        }
        return intersect;
    }

    public int getBin(double value) {
        return (int)Math.floor((value - this.intervals[0][0]) * (double)this.intervalDataNumber.length / (this.intervals[this.intervals.length - 1][1] - this.intervals[0][0]));
    }

    public double getBinMidPoint(int bin) {
        return (this.intervals[bin][0] + this.intervals[bin][1]) / 2.0;
    }

    public double rightIntersect(EmpiricDistribution other) {
        if (this.intervalDataNumber.length != other.getIntervalDataNumber().length) {
            throw new IllegalArgumentException("Distributions must have the same number of bins");
        }
        if (this.intervals[0][0] != other.intervals[0][0] || this.intervals[this.intervals.length - 1][1] != other.intervals[this.intervals.length - 1][1]) {
            throw new IllegalArgumentException("Distributions must have the same bins");
        }
        double diff = this.getDensity(this.intervals.length - 1) - other.getDensity(this.intervals.length - 1);
        double intersect = (this.intervals[this.intervals.length - 1][1] + this.intervals[this.intervals.length - 1][0]) / 2.0;
        for (int i = this.intervals.length - 2; i >= 0; --i) {
            double intervalDiff = this.getDensity(i) - other.getDensity(i);
            if (diff == 0.0) {
                diff = intervalDiff;
                continue;
            }
            if (!(diff * intervalDiff < 0.0)) continue;
            intersect = (this.intervals[i][1] + this.intervals[i][0]) / 2.0;
            break;
        }
        return intersect;
    }

    public double getFirstIntersectLeftFromMedian(EmpiricDistribution other) {
        if (this.intervalDataNumber.length != other.getIntervalDataNumber().length) {
            throw new IllegalArgumentException("Distributions must have the same number of bins");
        }
        if (this.intervals[0][0] != other.intervals[0][0] || this.intervals[this.intervals.length - 1][1] != other.intervals[this.intervals.length - 1][1]) {
            throw new IllegalArgumentException("Distributions must have the same bins");
        }
        int medianBin = this.getMedianBin();
        double diff = this.getDensity(medianBin) - other.getDensity(medianBin);
        double intersect = (this.intervals[0][1] + this.intervals[0][0]) / 2.0;
        for (int i = medianBin; i >= 0; --i) {
            double intervalDiff = this.getDensity(i) - other.getDensity(i);
            if (!(diff * intervalDiff < 0.0)) continue;
            intersect = (this.intervals[i][1] + this.intervals[i][0]) / 2.0;
            break;
        }
        return intersect;
    }

    public double getFirstIntersectRightFromMedian(EmpiricDistribution other) {
        if (this.intervalDataNumber.length != other.getIntervalDataNumber().length) {
            throw new IllegalArgumentException("Distributions must have the same number of bins");
        }
        if (this.intervals[0][0] != other.intervals[0][0] || this.intervals[this.intervals.length - 1][1] != other.intervals[this.intervals.length - 1][1]) {
            throw new IllegalArgumentException("Distributions must have the same bins");
        }
        int medianBin = this.getMedianBin();
        double diff = this.getDensity(medianBin) - other.getDensity(medianBin);
        double intersect = (this.intervals[this.intervals.length - 1][1] + this.intervals[this.intervals.length - 1][0]) / 2.0;
        for (int i = medianBin; i < this.intervals.length; ++i) {
            double intervalDiff = this.getDensity(i) - other.getDensity(i);
            if (!(diff * intervalDiff < 0.0)) continue;
            intersect = (this.intervals[i][1] + this.intervals[i][0]) / 2.0;
            break;
        }
        return intersect;
    }

    public int getTotalObservations() {
        int total = 0;
        for (int i = 0; i < this.intervalDataNumber.length; ++i) {
            total += this.intervalDataNumber[i];
        }
        return total;
    }

    public double getDensity(int bin) {
        int total = this.getTotalObservations();
        return (double)this.intervalDataNumber[bin] / ((double)total * (this.intervals[bin][1] - this.intervals[bin][0]));
    }

    public double getPercentOfValuesBetween(double leftBound, double rightBound) {
        int total = this.getTotalObservations();
        int totalInRange = 0;
        for (int i = 0; i < this.intervalDataNumber.length; ++i) {
            if (!(this.intervals[i][0] > leftBound) || !(this.intervals[i][1] < rightBound)) continue;
            totalInRange += this.intervalDataNumber[i];
        }
        return (double)totalInRange / (double)total;
    }

    public double getPercentOfValuesLargerThan(double value) {
        int total = this.getTotalObservations();
        int totalInRange = 0;
        for (int i = 0; i < this.intervalDataNumber.length; ++i) {
            if (!(this.intervals[i][0] > value)) continue;
            totalInRange += this.intervalDataNumber[i];
        }
        return (double)totalInRange / (double)total;
    }

    public double getMean() {
        double mean = 0.0;
        double total = this.getTotalObservations();
        for (int i = 0; i < this.intervalDataNumber.length; ++i) {
            mean += (this.intervals[i][1] + this.intervals[i][0]) / 2.0 * (double)this.intervalDataNumber[i] / total;
        }
        return mean;
    }

    private int getMedianBin() {
        int bin = 0;
        long total = this.getTotalObservations();
        for (long totalSoFar = 0L; totalSoFar < total / 2L; totalSoFar += (long)this.intervalDataNumber[bin++]) {
        }
        return bin;
    }

    public double getQuantile(double probability) {
        double pctSoFar;
        int bin;
        int total = this.getTotalObservations();
        int totalSoFar = 0;
        for (bin = 0; bin < this.intervalDataNumber.length && !(probability < (pctSoFar = (double)(totalSoFar += this.intervalDataNumber[bin]) / (double)total)); ++bin) {
        }
        return (this.intervals[bin][1] + this.intervals[bin][0]) / 2.0;
    }

    public double getCummulativeProbability(double value) {
        int total = this.getTotalObservations();
        int totalInRange = 0;
        for (int i = 0; i < this.intervalDataNumber.length; ++i) {
            if (!(this.intervals[i][1] < value)) continue;
            totalInRange += this.intervalDataNumber[i];
        }
        return (double)totalInRange / (double)total;
    }

    public void write(BufferedWriter bw) throws IOException {
        DecimalFormat format = new DecimalFormat("###0.###");
        int total = this.getTotalObservations();
        int totalSoFar = 0;
        System.err.println("total " + total);
        for (int i = 0; i < this.intervalDataNumber.length; ++i) {
            totalSoFar += this.intervalDataNumber[i];
            double midPoint = (this.intervals[i][0] + this.intervals[i][1]) / 2.0;
            bw.write(format.format(midPoint));
            bw.write("\t");
            bw.write(String.valueOf(this.intervalDataNumber[i]));
            bw.write("\t");
            bw.write(format.format((double)this.intervalDataNumber[i] / ((double)total * (this.intervals[i][1] - this.intervals[i][0]))));
            bw.write("\t");
            bw.write(String.valueOf(totalSoFar));
            bw.write("\t");
            bw.write(format.format((double)totalSoFar / (double)total));
            bw.newLine();
        }
    }

    public void addDistribution(EmpiricDistribution other) {
        int[] otherData = other.getIntervalDataNumber();
        if (otherData.length != this.intervalDataNumber.length) {
            throw new IllegalArgumentException("Distributions need to have the same number of bins this has " + this.intervalDataNumber.length + " other has " + otherData.length);
        }
        for (int i = 0; i < otherData.length; ++i) {
            int n = i;
            this.intervalDataNumber[n] = this.intervalDataNumber[n] + otherData[i];
        }
    }

    protected int[] getIntervalDataNumber() {
        return this.intervalDataNumber;
    }

    public static void main(String[] args) throws Exception {
        CLUtil.ArgumentMap argMap = CLUtil.getParameters(args, USAGE);
        if ("1".equals(argMap.getTask())) {
            BufferedReader br = argMap.getInputReader();
            BufferedWriter bw = argMap.getOutputWriter();
            String separator = argMap.containsKey("separator") ? argMap.get("separator") : "\t";
            int col = argMap.getInteger("col");
            int binNum = argMap.containsKey("binNum") ? argMap.getInteger("binNum") : 200;
            float maxVal = argMap.getFloat("maxValue");
            float minVal = argMap.getFloat("minValue");
            EmpiricDistribution dist = new EmpiricDistribution(binNum, minVal, maxVal);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                String[] lineInfo = line.split(separator);
                double val = Double.parseDouble(lineInfo[col]);
                dist.add(val);
            }
            br.close();
            dist.write(bw);
            bw.close();
        } else if ("2".equals(argMap.getTask())) {
            String suffix;
            File dir = new File(argMap.getInputDir());
            String[] distributions = dir.list(new FilenameFilter(suffix = argMap.getMandatory("suffix")){
                final /* synthetic */ String val$suffix;
                {
                    this.val$suffix = string;
                }

                public boolean accept(File arg0, String arg1) {
                    return arg1.endsWith(this.val$suffix);
                }
            });
            if (distributions.length == 0) {
                return;
            }
            EmpiricDistribution combinedDist = new EmpiricDistribution(new File(dir + "/" + distributions[0]));
            for (int i = 1; i < distributions.length; ++i) {
                combinedDist.addDistribution(new EmpiricDistribution(new File(dir + "/" + distributions[i])));
            }
            BufferedWriter bw = argMap.getOutputWriter();
            combinedDist.write(bw);
            bw.close();
        } else if ("3".equals(argMap.getTask())) {
            double probability = argMap.getDouble("probability");
            InputStream is = argMap.getInputStream();
            EmpiricDistribution distribution = new EmpiricDistribution(is);
            is.close();
            System.out.println(distribution.getQuantile(probability));
        }
    }
}

