/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLUtil {
    public static ArgumentMap getParameters(String[] args, String usage) {
        ArgumentMap argMap = new ArgumentMap(args.length, usage);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String key = args[i].substring(1);
                String val = "";
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    val = args[i + 1];
                    ++i;
                }
                if (argMap.containsKey(key)) {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(argMap.get(key));
                    values.add(val);
                }
                argMap.put(key, val);
                continue;
            }
            String[] arg = args[i].split("=");
            if (arg.length != 2) {
                throw new IllegalArgumentException(usage);
            }
            argMap.put(arg[0], arg[1]);
        }
        return argMap;
    }

    public static void writeLeftJustifiedField(BufferedWriter bw, String value, int fieldSize) throws IOException {
        if (value.length() > fieldSize) {
            bw.write(value.substring(0, fieldSize));
        } else {
            bw.write(value);
            for (int i = 0; i < fieldSize - value.length(); ++i) {
                bw.write(" ");
            }
        }
    }

    public static void writeRightJustifiedField(BufferedWriter bw, String value, int fieldSize) throws IOException {
        if (value.length() > fieldSize) {
            bw.write(value.substring(0, fieldSize));
        } else {
            for (int i = 0; i < fieldSize - value.length(); ++i) {
                bw.write(" ");
            }
            bw.write(value);
        }
    }

    public static String replaceFileExtension(String fileName, String newExtension) {
        String[] fileNameComponents = fileName.split("\\.");
        StringBuilder newFileName = new StringBuilder(fileNameComponents[0]);
        for (int i = 1; i < fileNameComponents.length - 1; ++i) {
            newFileName.append(".").append(fileNameComponents[i]);
        }
        newFileName.append(".").append(newExtension);
        return newFileName.toString();
    }

    public static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    public static <T> List<T> listFromArray(T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArgumentMap
    extends HashMap<String, List<String>> {
        private static final long serialVersionUID = 2312363L;
        private String usage;
        private String task;
        private String input;
        private String output;
        private String inputDir;
        private String outputDir;

        public ArgumentMap(int size, String usage) {
            super(size);
            this.usage = usage;
        }

        public String get(String key) {
            List result = (List)super.get(key);
            return result == null || result.size() == 0 ? "" : (String)result.get(0);
        }

        @Override
        public void put(String key, String value) {
            if (key.toLowerCase().equals("task")) {
                this.task = value;
            } else if (key.toLowerCase().equals("in")) {
                this.input = value;
            } else if (key.toLowerCase().equals("out")) {
                this.output = value;
            } else if (key.toLowerCase().equals("outdir")) {
                this.outputDir = value;
            } else if (key.toLowerCase().equals("indir")) {
                this.inputDir = value;
            } else {
                ArrayList<String> values = (ArrayList<String>)super.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                    super.put(key, values);
                }
                values.add(value);
            }
        }

        public String getTask() {
            if (this.task == null) {
                throw new IllegalArgumentException("Missing task\n" + this.usage);
            }
            return this.task;
        }

        public String getInput() {
            if (this.input == null) {
                throw new IllegalArgumentException("Must provide \"in\"" + this.usage);
            }
            return this.input;
        }

        public BufferedReader getInputReader() throws IOException {
            BufferedReader br = null;
            br = this.input != null ? new BufferedReader(new FileReader(this.input)) : new BufferedReader(new InputStreamReader(System.in));
            return br;
        }

        public InputStream getInputStream() throws IOException {
            InputStream is = null;
            is = this.input != null ? new FileInputStream(this.input) : System.in;
            return is;
        }

        public String getOutput() {
            if (this.output == null) {
                throw new IllegalArgumentException("Must provide an \"out\"\n" + this.usage);
            }
            return this.output;
        }

        public BufferedWriter getOutputWriter() throws IOException {
            BufferedWriter bw = null;
            bw = this.output != null ? new BufferedWriter(new FileWriter(this.output)) : new BufferedWriter(new OutputStreamWriter(System.out));
            return bw;
        }

        public OutputStream getOutputStream() throws IOException {
            OutputStream os = null;
            os = this.output != null ? new FileOutputStream(this.output) : System.out;
            return os;
        }

        public boolean isOutputSet() {
            return this.output != null;
        }

        public String getOutputDir() {
            if (this.outputDir == null) {
                this.outputDir = "./";
            }
            return this.outputDir;
        }

        public String getInputDir() {
            if (this.inputDir == null) {
                throw new IllegalArgumentException("Must provide an \"indir\"\n" + this.usage);
            }
            return this.inputDir;
        }

        public List<String> getAll(String key) {
            return super.get(key) == null ? new ArrayList() : (List)super.get(key);
        }

        public int getInteger(String key) throws NumberFormatException {
            String val = this.getMandatory(key);
            return Integer.parseInt(val);
        }

        public List<Integer> getIntegers(String key) throws NumberFormatException {
            List<String> stringVals = this.getAllMandatory(key);
            ArrayList<Integer> paramList = new ArrayList<Integer>(stringVals.size());
            for (String val : stringVals) {
                paramList.add(Integer.parseInt(val));
            }
            return paramList;
        }

        public String getMandatory(String key) throws IllegalArgumentException {
            List parameter = (List)super.get(key);
            if (parameter == null || parameter.size() == 0) {
                throw new IllegalArgumentException("Argument " + key + " is mandatory\n" + this.usage);
            }
            return (String)parameter.get(0);
        }

        public List<String> getAllMandatory(String key) throws IllegalArgumentException {
            List vals = (List)super.get(key);
            if (vals == null || vals.size() == 0) {
                throw new IllegalArgumentException("Argument " + key + " is mandatory, at least one should be provided\n" + this.usage);
            }
            return vals;
        }

        public float getFloat(String key) throws NumberFormatException {
            String val = this.getMandatory(key);
            return Float.parseFloat(val);
        }

        public List<Float> getFloats(String key) throws NumberFormatException {
            List<String> stringVals = this.getAllMandatory(key);
            ArrayList<Float> paramList = new ArrayList<Float>(stringVals.size());
            for (String val : stringVals) {
                paramList.add(Float.valueOf(Float.parseFloat(val)));
            }
            return paramList;
        }

        public boolean isPresent(String key) {
            return super.get(key) != null && ((List)super.get(key)).size() > 0;
        }

        public boolean isFlagTrue(String key) {
            return this.containsKey(key) && "TRUE".equalsIgnoreCase(this.get(key));
        }

        public double getDouble(String key) {
            String val = this.getMandatory(key);
            return Double.parseDouble(val);
        }

        public List<Double> getDoubles(String key) throws NumberFormatException {
            List<String> stringVals = this.getAllMandatory(key);
            ArrayList<Double> paramList = new ArrayList<Double>(stringVals.size());
            for (String val : stringVals) {
                paramList.add(Double.parseDouble(val));
            }
            return paramList;
        }
    }
}

