/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.sequence;

import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.TwoSubjectAnnotation;
import edu.mit.broad.prodinfo.sequence.Sequence;
import edu.mit.broad.prodinfo.sequence.WindowSlider;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceRegion
extends Sequence
implements GenomicAnnotation {
    BasicGenomicAnnotation annotation;
    private String containingSequenceId;
    public static final int INF = 1000000000;

    public SequenceRegion(String containingSequenceId) {
        super(null);
        this.containingSequenceId = containingSequenceId;
        this.annotation = new BasicGenomicAnnotation(containingSequenceId);
        this.annotation.setSequence(this);
        this.annotation.setEnd(1000000000);
    }

    public SequenceRegion(String containingSequenceId, GenomicAnnotation annotation) {
        super(annotation.getName());
        this.containingSequenceId = containingSequenceId;
        this.annotation = new BasicGenomicAnnotation(annotation);
    }

    public int getRegionEnd() {
        return this.annotation.getEnd() == 1000000000 && super.getSequenceBases() != null && this.getSequenceBases().length() > 0 ? this.getSequenceBases().length() + this.annotation.getStart() - 1 : this.annotation.getEnd();
    }

    public void setRegionEnd(int regionEnd) {
        this.annotation.setEnd(regionEnd);
    }

    public int getRegionStart() {
        return this.annotation.getStart();
    }

    public void setRegionStart(int regionStart) {
        this.annotation.setStart(regionStart);
    }

    @Override
    public WindowSlider getSlider(int windowSize, int overlap) {
        return WindowSlider.getSlider(this, windowSize, overlap);
    }

    @Override
    public int getLength() {
        if (this.getEnd() == 1000000000 && this.getSequenceBases() == null && this.getSequenceBases().length() == 0) {
            return 1000000000;
        }
        if (this.getEnd() < 1000000000) {
            return this.getEnd() - this.getStart();
        }
        return super.getLength();
    }

    @Override
    public String getOrientation() {
        return this.inReversedOrientation() ? "-" : "+";
    }

    @Override
    public void setReversedOrientation(boolean reversed) {
        this.annotation.setOrientation(!reversed);
    }

    public String getContainingSequenceId() {
        return this.containingSequenceId;
    }

    @Override
    public String getId() {
        return super.getId() == null ? this.containingSequenceId + "_" + this.getStart() + "-" + this.getEnd() : super.getId();
    }

    @Override
    public int getStart() {
        return this.annotation.getStart();
    }

    @Override
    public int getEnd() {
        return this.annotation.getEnd();
    }

    @Override
    public double getScore() {
        return this.annotation.getScore();
    }

    @Override
    public void setScore(double score) {
        this.annotation.setScore(score);
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.annotation.setName(id);
    }

    @Override
    public void setName(String name) {
        this.setId(name);
    }

    @Override
    public boolean inReversedOrientation() {
        return this.annotation.inReversedOrientation();
    }

    @Override
    public long getMiddle() {
        return this.annotation.getMiddle();
    }

    @Override
    public void setStart(int start) {
        this.setRegionStart(start);
    }

    @Override
    public void setEnd(int end) {
        this.setRegionEnd(end);
    }

    @Override
    public Sequence getSequence() {
        return this;
    }

    @Override
    public void setSequence(Sequence seq) {
        super.setSequenceBases(seq.getSequenceBases());
    }

    @Override
    public String getChromosome() {
        return this.annotation.getChromosome();
    }

    @Override
    public void setChromosome(String chr) {
        this.annotation.setChromosome(chr);
    }

    @Override
    public boolean overlaps(GenomicAnnotation other, int buffer) {
        return this.annotation.overlaps(other, buffer);
    }

    @Override
    public boolean overlaps(GenomicAnnotation other) {
        return this.annotation.overlaps(other);
    }

    @Override
    public List<GenomicAnnotation> minus(GenomicAnnotation other) {
        return this.annotation.minus(other);
    }

    @Override
    public List<GenomicAnnotation> minus(List<? extends GenomicAnnotation> others) {
        return this.annotation.minus(others);
    }

    @Override
    public void takeIntersection(GenomicAnnotation other) {
        this.annotation.takeIntersection(other);
    }

    @Override
    public void takeUnion(GenomicAnnotation other) {
        this.annotation.takeUnion(other);
    }

    @Override
    public void stitchTo(GenomicAnnotation other) {
        this.annotation.stitchTo(other);
    }

    @Override
    public boolean isFlankedBy(TwoSubjectAnnotation twoSubjectAnnotation, int buffer) {
        return this.annotation.isFlankedBy(twoSubjectAnnotation, buffer);
    }

    @Override
    public int getFivePrimeBases() {
        return this.annotation.getFivePrimeBases();
    }

    @Override
    public int getThreePrimeBases() {
        return this.annotation.getThreePrimeBases();
    }

    public String toString() {
        return this.getContainingSequenceId() + ":" + this.getRegionStart() + "-" + this.getRegionEnd();
    }

    @Override
    public String getLocationString() {
        return this.annotation.getLocationString();
    }

    @Override
    public String getChromosomeString() {
        return this.annotation.getChromosomeString();
    }

    @Override
    public SequenceRegion extractRegionBasedOnGC(float targetGC, int size, int buffer) {
        SequenceRegion theRegion = super.extractRegionBasedOnGC(targetGC, size, buffer);
        if (theRegion != null) {
            theRegion.setRegionStart(this.getRegionStart() + theRegion.getRegionStart());
            theRegion.setRegionEnd(this.getRegionStart() + theRegion.getRegionEnd());
            theRegion.setChromosome(this.annotation.getChromosome());
        }
        return theRegion;
    }

    @Override
    public boolean contains(GenomicAnnotation other) {
        return this.annotation.contains(other);
    }

    @Override
    public int getDistanceTo(GenomicAnnotation other) {
        return this.annotation.getDistanceTo(other);
    }

    @Override
    public void setOrientation(String orientation) {
        this.annotation.setOrientation(orientation);
    }

    @Override
    public int compareTo(GenomicAnnotation arg0) {
        return this.annotation.compareTo(arg0);
    }

    @Override
    public List<GenomicAnnotation> disect(GenomicAnnotation a) {
        return this.annotation.disect(a);
    }

    @Override
    public List<GenomicAnnotation> disect(List<? extends GenomicAnnotation> disectors) {
        return this.annotation.disect(disectors);
    }

    @Override
    public SequenceRegion getRegion(int start, int end) {
        SequenceRegion region = super.getRegion(start, end);
        if (this.annotation.getChromosome() != null) {
            region.setChromosome(this.annotation.getChromosome());
        }
        return region;
    }

    @Override
    public int getOrientedEnd() {
        return this.annotation.getOrientedEnd();
    }

    @Override
    public int getOrientedStart() {
        return this.annotation.getOrientedStart();
    }

    @Override
    public void addBlock(String name, int start, int end) {
    }

    @Override
    public List<? extends GenomicAnnotation> getBlocks() {
        return null;
    }

    @Override
    public boolean mayHaveBlocks() {
        return false;
    }
}

