/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.sequence;

import Jama.Matrix;
import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.sequence.SequenceRegion;
import edu.mit.broad.prodinfo.sequence.WindowSlider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence {
    private static final Pattern SOFT_MASKED_PAT = Pattern.compile("[acgt]+");
    private static final Pattern SEQUENCE_GAP_PAT = Pattern.compile("[Nn]+");
    private static final Pattern UNGAPPED_SEQUENCE_PAT = Pattern.compile("[^Nn]+");
    private String id;
    private StringBuilder sequenceBases;
    private short[] encodedSequence;
    private Matrix vectorEncodedSequence;
    private boolean forwardStrand = true;
    private boolean encodeIgnoreCase = false;
    public static final char[] SHORT_READ_FLOW = new char[]{'T', 'A', 'C', 'G'};
    public static final char[] LONG_READ_FLOW = new char[]{'G', 'A', 'T', 'C'};
    public static final short SHORT_ENCODED_A = 0;
    public static final short SHORT_ENCODED_C = 1;
    public static final short SHORT_ENCODED_G = 2;
    public static final short SHORT_ENCODED_T = 3;
    public static final short SHORT_ENCODED_GAP = 4;
    public static final short SHORT_ENCODED_a = 5;
    public static final short SHORT_ENCODED_c = 6;
    public static final short SHORT_ENCODED_g = 7;
    public static final short SHORT_ENCODED_t = 8;
    public static final short SHORT_ENCODED_N = 9;

    public Sequence(String id) {
        this.id = id;
        this.sequenceBases = new StringBuilder();
    }

    public Sequence(String id, boolean isLarge) {
        this(id);
        if (isLarge) {
            this.sequenceBases = new StringBuilder(850000000);
        }
    }

    public String getId() {
        return this.id;
    }

    protected void setForwardStrand(boolean isForwardStrand) {
        this.forwardStrand = isForwardStrand;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void unloadSequence() {
        this.sequenceBases.delete(0, this.sequenceBases.length());
        this.sequenceBases.trimToSize();
    }

    public int getLength() {
        return this.sequenceBases.length();
    }

    public void setCharAt(int position, char newCharacter) throws IllegalAccessException {
        if (this.sequenceBases == null) {
            throw new IllegalAccessException("This methods is only implemented for un encoded sequences. sequenceBases is null, it must be non null.");
        }
        this.sequenceBases.setCharAt(position, newCharacter);
    }

    public String getSequenceBases() {
        String bases = "";
        if (this.sequenceBases.length() > 0) {
            bases = this.sequenceBases.toString();
        } else if (this.encodedSequence != null && this.encodedSequence.length > 0) {
            StringBuffer buf = new StringBuffer(this.encodedSequence.length);
            if (!this.encodeIgnoreCase) {
                block24: for (int i = 0; i < this.encodedSequence.length; ++i) {
                    switch (this.encodedSequence[i]) {
                        case 6: {
                            buf.append("c");
                            continue block24;
                        }
                        case 1: {
                            buf.append("C");
                            continue block24;
                        }
                        case 2: {
                            buf.append("G");
                            continue block24;
                        }
                        case 7: {
                            buf.append("g");
                            continue block24;
                        }
                        case 5: {
                            buf.append("a");
                            continue block24;
                        }
                        case 0: {
                            buf.append("A");
                            continue block24;
                        }
                        case 3: {
                            buf.append("T");
                            continue block24;
                        }
                        case 8: {
                            buf.append("t");
                            continue block24;
                        }
                        case 4: {
                            buf.append("-");
                            continue block24;
                        }
                        default: {
                            buf.append("N");
                        }
                    }
                }
            } else {
                block25: for (int i = 0; i < this.encodedSequence.length; ++i) {
                    switch (this.encodedSequence[i]) {
                        case 0: {
                            buf.append("A");
                            continue block25;
                        }
                        case 1: {
                            buf.append("C");
                            continue block25;
                        }
                        case 2: {
                            buf.append("G");
                            continue block25;
                        }
                        case 3: {
                            buf.append("T");
                            continue block25;
                        }
                        case 4: {
                            buf.append("-");
                            continue block25;
                        }
                        default: {
                            buf.append("N");
                        }
                    }
                }
            }
            bases = buf.toString();
        } else if (this.vectorEncodedSequence != null) {
            Random random = new Random();
            int seqLength = this.vectorEncodedSequence.getColumnDimension();
            StringBuffer buf = new StringBuffer(seqLength);
            block26: for (int j = 0; j < seqLength; ++j) {
                double draw = random.nextDouble();
                int drawedBase = -1;
                double cummulativeProbability = 0.0;
                for (int i = 0; i < 4; ++i) {
                    if (!(draw <= (cummulativeProbability += this.vectorEncodedSequence.get(i, j)))) continue;
                    drawedBase = i;
                    break;
                }
                switch (drawedBase) {
                    case 0: {
                        buf.append("A");
                        continue block26;
                    }
                    case 1: {
                        buf.append("C");
                        continue block26;
                    }
                    case 2: {
                        buf.append("G");
                        continue block26;
                    }
                    case 3: {
                        buf.append("T");
                        continue block26;
                    }
                    default: {
                        buf.append("-");
                    }
                }
            }
            bases = buf.toString();
        }
        return bases;
    }

    public void setSequenceBases(String sequence) {
        this.sequenceBases = new StringBuilder(sequence);
    }

    public void appendToSequence(String partialSequence) {
        this.sequenceBases.append(partialSequence);
    }

    public void appendToSequence(char c) {
        this.sequenceBases.append(c);
    }

    public boolean isGap(int position) {
        boolean isGap = false;
        if (this.encodedSequence != null && this.encodedSequence.length >= position) {
            isGap = this.encodeIgnoreCase && this.encodedSequence[position] == 4;
        } else if (this.vectorEncodedSequence != null && this.vectorEncodedSequence.getColumnDimension() >= position) {
            double maxProb = 0.0;
            for (int i = 0; i < 4; ++i) {
                double baseProbability = this.vectorEncodedSequence.get(i, position);
                if (!(maxProb < baseProbability)) continue;
                maxProb = baseProbability;
            }
            isGap = maxProb == 0.0;
        } else if (this.sequenceBases != null & this.sequenceBases.length() >= position) {
            isGap = '-' == this.sequenceBases.charAt(position);
        }
        return isGap;
    }

    public List<GenomicAnnotation> getSoftmaskedRegions() {
        ArrayList<GenomicAnnotation> softMaskedRegions = new ArrayList<GenomicAnnotation>();
        if (this.sequenceBases == null) {
            return softMaskedRegions;
        }
        Matcher m = SOFT_MASKED_PAT.matcher(this.sequenceBases);
        int i = 1;
        while (m.find()) {
            BasicGenomicAnnotation softMaskedReg = new BasicGenomicAnnotation(this.getId() + "_SoftmaskedReg_" + i++);
            softMaskedReg.setStart(m.start() + 1);
            softMaskedReg.setEnd(m.end() + 1);
            softMaskedReg.setChromosome(this.getId());
            softMaskedRegions.add(softMaskedReg);
        }
        return softMaskedRegions;
    }

    public short[] getEncodedSequence() {
        return this.encodedSequence;
    }

    public Matrix getVectorEncodedSequence() {
        return this.vectorEncodedSequence;
    }

    public Matrix encodeSequenceAsVector() {
        this.vectorEncodedSequence = new Matrix(4, this.sequenceBases.length());
        for (int j = 0; j < this.sequenceBases.length(); ++j) {
            char c = this.sequenceBases.charAt(j);
            if ('a' == c || 'A' == c) {
                this.vectorEncodedSequence.set(0, j, 1.0);
                continue;
            }
            if ('C' == c || 'c' == c) {
                this.vectorEncodedSequence.set(1, j, 1.0);
                continue;
            }
            if ('G' == c || 'g' == c) {
                this.vectorEncodedSequence.set(2, j, 1.0);
                continue;
            }
            if ('T' != c && 't' != c) continue;
            this.vectorEncodedSequence.set(3, j, 1.0);
        }
        return this.vectorEncodedSequence;
    }

    public short[] encodeSequence() {
        if (this.encodedSequence != null) {
            return this.encodedSequence;
        }
        short[] encodedSeq = new short[this.sequenceBases.length()];
        for (int i = 0; i < this.sequenceBases.length(); ++i) {
            char c = this.sequenceBases.charAt(i);
            encodedSeq[i] = 'c' == c ? 6 : ('C' == c ? 1 : ('G' == c ? 2 : ('g' == c ? 7 : ('a' == c ? 5 : ('A' == c ? 0 : ('t' == c ? 8 : ('T' == c ? 3 : 9)))))));
        }
        this.encodedSequence = encodedSeq;
        this.encodeIgnoreCase = false;
        return encodedSeq;
    }

    public short[] encodeSequenceIgnoreCase() {
        if (this.encodedSequence != null) {
            return this.encodedSequence;
        }
        short[] encodedSeq = new short[this.sequenceBases.length()];
        for (int i = 0; i < this.sequenceBases.length(); ++i) {
            char c = this.sequenceBases.charAt(i);
            encodedSeq[i] = 'a' == c || 'A' == c ? 0 : ('C' == c || 'c' == c ? 1 : ('G' == c || 'g' == c ? 2 : ('T' == c || 't' == c ? 3 : ('-' == c ? 4 : 4))));
        }
        this.encodedSequence = encodedSeq;
        this.encodeIgnoreCase = true;
        return encodedSeq;
    }

    public List<Short> compute454Flow(char[] flowOrder) {
        return this.compute454Flow(flowOrder, 1, this.sequenceBases.length());
    }

    public List<Short> compute454Flow(char[] flowOrder, int start, int end) {
        char[] subSeqChrs = new char[end - start];
        this.sequenceBases.getChars(start - 1, end - 1, subSeqChrs, 0);
        ArrayList<Short> flow = new ArrayList<Short>();
        int seqIdx = 0;
        int flowIdx = 0;
        char flowLetter = '\u0000';
        short flowRead = 0;
        while (seqIdx < subSeqChrs.length) {
            flowLetter = flowOrder[flowIdx % 4];
            char seqChar = Character.toUpperCase(subSeqChrs[seqIdx]);
            if (seqChar != 'A' && seqChar != 'T' && seqChar != 'G' && seqChar != 'C') {
                System.err.println("Sequence Character " + seqChar + " is not a base, ignoring it");
                ++seqIdx;
            }
            if (flowLetter == seqChar) {
                flowRead = (short)(flowRead + 1);
                ++seqIdx;
                continue;
            }
            flow.add(flowRead);
            ++flowIdx;
            flowRead = 0;
        }
        return flow;
    }

    public float gcContent() {
        return Sequence.computeGCContent(this.sequenceBases.toString());
    }

    public boolean contains(String motif) {
        Sequence revMotifSeq = new Sequence("rev_motif");
        revMotifSeq.setSequenceBases(motif);
        revMotifSeq.reverse();
        String revMotif = revMotifSeq.getSequenceBases();
        return this.getSequenceBases().contains(motif) || this.getSequenceBases().contains(revMotif);
    }

    public static float computeGCContent(String dnaString) {
        int gcs = 0;
        for (int i = 0; i < dnaString.length(); ++i) {
            char c = Character.toUpperCase(dnaString.charAt(i));
            if ('C' != c && 'G' != c) continue;
            ++gcs;
        }
        return (float)gcs / (float)dnaString.length();
    }

    public void reverse() {
        String seqBases = this.getSequenceBases();
        StringBuilder reversedSeq = new StringBuilder(seqBases.length());
        for (int j = seqBases.length() - 1; j >= 0; --j) {
            char c = seqBases.charAt(j);
            if ('c' == c) {
                reversedSeq.append('g');
                continue;
            }
            if ('C' == c) {
                reversedSeq.append('G');
                continue;
            }
            if ('G' == c) {
                reversedSeq.append('C');
                continue;
            }
            if ('g' == c) {
                reversedSeq.append('c');
                continue;
            }
            if ('a' == c) {
                reversedSeq.append('t');
                continue;
            }
            if ('A' == c) {
                reversedSeq.append('T');
                continue;
            }
            if ('t' == c) {
                reversedSeq.append('a');
                continue;
            }
            if ('T' == c) {
                reversedSeq.append('A');
                continue;
            }
            reversedSeq.append(c);
        }
        this.sequenceBases = reversedSeq;
        if (this.encodedSequence != null) {
            this.encodedSequence = null;
            this.encodeSequenceIgnoreCase();
        } else if (this.vectorEncodedSequence != null) {
            this.vectorEncodedSequence = null;
            this.encodeSequenceAsVector();
        }
        this.forwardStrand = false;
    }

    public static String reverseSequence(String seq) {
        Sequence tmpSeq = new Sequence("tmp");
        tmpSeq.setSequenceBases(seq);
        tmpSeq.reverse();
        return tmpSeq.getSequenceBases();
    }

    public void uppercase() {
        StringBuilder uppercasedSeq;
        this.sequenceBases = uppercasedSeq = new StringBuilder(this.sequenceBases.toString().toUpperCase());
    }

    public SequenceRegion getRegion(int start, int end) {
        SequenceRegion region = new SequenceRegion(this.getId());
        region.setRegionStart(start);
        region.setRegionEnd(end);
        String bases = this.getSequenceBases();
        if (bases != null && bases.length() > 0) {
            region.setSequenceBases(bases.substring(start, end));
        }
        return region;
    }

    public void getRegion(SequenceRegion region) {
        region.setSequenceBases(this.sequenceBases.substring(region.getStart(), region.getEnd()));
    }

    public void getRegions(List<? extends SequenceRegion> regions) {
        for (SequenceRegion sequenceRegion : regions) {
            this.getRegion(sequenceRegion);
        }
    }

    public SequenceRegion extractRegionBasedOnGC(float targetGC, int size, int buffer) {
        SequenceRegion theRegion = null;
        float closestGC = 0.0f;
        System.out.println("extracting region based on GC for sequence " + this.getId() + " of size " + this.getSequenceBases().length() + " buffer " + buffer);
        if (this.getSequenceBases() == null || this.getSequenceBases().length() < buffer) {
            return theRegion;
        }
        for (int i = buffer; i < this.getSequenceBases().length() - buffer - size; i += buffer) {
            String currentSequence = this.getSequenceBases().substring(i - buffer, i + size + buffer - 1);
            float currentGC = Sequence.computeGCContent(currentSequence);
            System.out.println("position " + i + " currentGC " + currentGC + ", targetGC " + targetGC + ",  closestGC distance to target " + Math.abs(closestGC - targetGC) + " currentGC distance to target " + Math.abs(targetGC - currentGC));
            if (!(Math.abs(closestGC - targetGC) > Math.abs(targetGC - currentGC))) continue;
            closestGC = currentGC;
            theRegion = new SequenceRegion(this.getId());
            theRegion.setSequenceBases(currentSequence);
            theRegion.setRegionStart(i - buffer);
            theRegion.setEnd(i + size + buffer - 1);
        }
        System.out.println("Returning closest GC region: " + theRegion + " GC% " + closestGC);
        return theRegion;
    }

    public boolean isForwardStrand() {
        return this.forwardStrand;
    }

    public StringBuilder getSequenceBuilder() {
        return this.sequenceBases == null || this.sequenceBases.length() == 0 ? new StringBuilder(this.getSequenceBases()) : this.sequenceBases;
    }

    public int getGapsSize() {
        int totalGaps = 0;
        if (this.sequenceBases != null && this.sequenceBases.length() > 0) {
            char[] baseArray = this.sequenceBases.toString().toUpperCase().toCharArray();
            for (int i = 0; i < baseArray.length; ++i) {
                if (baseArray[i] != 'N') continue;
                ++totalGaps;
            }
        }
        return totalGaps;
    }

    public WindowSlider getSlider(int windowSize, int overlap) {
        return WindowSlider.getSlider(this, windowSize, overlap);
    }

    public List<SequenceRegion> chunk(int chunkSize, int chunkOverlap) {
        int numOfChunks = (int)Math.floor((float)this.getLength() / (float)(chunkSize - chunkOverlap));
        int chunkStart = 0;
        int chunkEnd = 0;
        System.out.println("\tChunking " + this.getId() + " number of chunks " + numOfChunks);
        ArrayList<SequenceRegion> chunks = new ArrayList<SequenceRegion>(numOfChunks);
        for (int i = 0; i < numOfChunks; ++i) {
            chunkStart = i * (chunkSize - chunkOverlap);
            chunkEnd = chunkStart + chunkSize;
            SequenceRegion chunk = this.getRegion(chunkStart, chunkEnd);
            chunks.add(chunk);
        }
        if (chunkEnd < this.getLength()) {
            chunkStart = chunkEnd - chunkOverlap;
            SequenceRegion lastChunk = this.getRegion(chunkStart, this.getLength());
            chunks.add(lastChunk);
        }
        System.out.println("\tObtained " + chunks.size() + " chunks");
        return chunks;
    }

    public int getEnd() {
        return this.getLength();
    }

    public List<int[]> findUngappedSequenceChunks() {
        Matcher m = UNGAPPED_SEQUENCE_PAT.matcher(this.getSequenceBases());
        ArrayList<int[]> gapUngapp = new ArrayList<int[]>();
        while (m.find()) {
            int[] ungappedReg = new int[]{m.start(), m.end()};
            gapUngapp.add(ungappedReg);
        }
        return gapUngapp;
    }
}

