/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.sequence;

import edu.mit.broad.prodinfo.assembly.AgpEntry;
import edu.mit.broad.prodinfo.sequence.AbstractFastaParser;
import edu.mit.broad.prodinfo.sequence.FastaHandler;
import edu.mit.broad.prodinfo.sequence.FastaParser;
import edu.mit.broad.prodinfo.sequence.Sequence;
import edu.mit.broad.prodinfo.sequence.SequenceRegion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastaSequenceIO {
    public static final int LINE_LENGTH = 60;
    File file;

    public static void main(String[] args) throws IOException {
        String fileName = args[0];
        String seqId = args[1];
        String regions = args[2];
        String outFile = args[3];
        System.out.println("looking for seq " + seqId + " in file " + fileName);
        String[] regStrings = regions.split(",");
        ArrayList<SequenceRegion> seqs = new ArrayList<SequenceRegion>(regStrings.length);
        for (int i = 0; i < regStrings.length; ++i) {
            String[] startEnd = regStrings[i].split("\\.\\.");
            System.out.println(regStrings[i]);
            SequenceRegion seq = new SequenceRegion(seqId);
            seq.setRegionStart(Integer.parseInt(startEnd[0]));
            seq.setRegionEnd(Integer.parseInt(startEnd[1]));
            seqs.add(seq);
        }
        FastaSequenceIO fsIOIn = new FastaSequenceIO(fileName);
        fsIOIn.extractRegions(seqs);
        FastaSequenceIO fsIOOut = new FastaSequenceIO(outFile);
        fsIOOut.write(seqs);
    }

    public FastaSequenceIO(String fileName) {
        this.file = new File(fileName);
    }

    public FastaSequenceIO(File file) {
        this.file = file;
    }

    public FastaSequenceIO() {
    }

    public List<Sequence> loadAll() throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        List<Sequence> seqs = this.loadAll(is);
        ((InputStream)is).close();
        return seqs;
    }

    public List<Sequence> loadAll(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        String currentSeqId = null;
        ArrayList<Sequence> seqs = new ArrayList<Sequence>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith(">")) {
                currentSeqId = line.substring(1);
                Sequence seq = new Sequence(currentSeqId);
                seqs.add(seq);
                continue;
            }
            ((Sequence)seqs.get(seqs.size() - 1)).appendToSequence(line);
        }
        br.close();
        return seqs;
    }

    public void extractRecordsIntoSequenceList(List<? extends Sequence> sequenceList) throws Exception {
        HashMap<String, Sequence> seqNameMap = new HashMap<String, Sequence>(sequenceList.size());
        for (Sequence sequence : sequenceList) {
            seqNameMap.put(sequence.getId(), sequence);
        }
        Set set = seqNameMap.keySet();
        int seqsToFind = set.size();
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        String line = null;
        String currentSeqId = null;
        int found = 0;
        boolean inTargetSequence = false;
        while ((line = br.readLine()) != null && found < seqsToFind) {
            if (line.startsWith(">")) {
                if (inTargetSequence) {
                    inTargetSequence = false;
                    ++found;
                }
                String[] spaceSeparatedIds = line.substring(1).split("\\s");
                currentSeqId = spaceSeparatedIds[0];
                continue;
            }
            Sequence seq = (Sequence)seqNameMap.get(currentSeqId);
            if (seq == null) continue;
            seq.appendToSequence(line);
        }
        System.out.println("Found " + found + " sequences expected to find " + seqsToFind);
        br.close();
    }

    public void mergeRecords(Sequence seq, String regEx) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        Pattern pattern = Pattern.compile(regEx);
        String line = null;
        String currentSeqId = null;
        int found = 0;
        boolean inTargetSequence = false;
        while ((line = br.readLine()) != null) {
            if (line.startsWith(">")) {
                Matcher m;
                if (inTargetSequence) {
                    inTargetSequence = false;
                    ++found;
                }
                if (!(m = pattern.matcher(currentSeqId = line.substring(1))).find()) continue;
                inTargetSequence = true;
                continue;
            }
            if (!inTargetSequence) continue;
            seq.appendToSequence(line);
        }
        System.out.println("Found " + found + " sequences ");
        br.close();
    }

    public List<Sequence> extractRecordsWithIDsMatching(List<String> regExs, boolean encode) throws IOException {
        Stack<Sequence> extracted = new Stack<Sequence>();
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(regExs.size());
        Iterator<String> regExIt = regExs.iterator();
        while (regExIt.hasNext()) {
            Pattern pattern = Pattern.compile(regExIt.next());
            patterns.add(pattern);
        }
        String line = null;
        String currentSeqId = null;
        int found = 0;
        boolean inTargetSequence = false;
        block1: while ((line = br.readLine()) != null) {
            if (line.startsWith(">")) {
                if (inTargetSequence) {
                    Sequence last;
                    inTargetSequence = false;
                    if (encode && (last = (Sequence)extracted.peek()) != null) {
                        last.encodeSequence();
                        last.unloadSequence();
                    }
                    ++found;
                }
                currentSeqId = line.substring(1);
                for (Pattern pattern : patterns) {
                    Matcher m = pattern.matcher(currentSeqId);
                    if (!m.find()) continue;
                    Sequence seq = new Sequence(currentSeqId);
                    inTargetSequence = true;
                    extracted.add(seq);
                    continue block1;
                }
                continue;
            }
            if (!inTargetSequence) continue;
            Sequence seq = (Sequence)extracted.peek();
            seq.appendToSequence(line);
        }
        System.out.println("Found " + found + " sequences were looking for " + regExs.size() + " extracted list size " + extracted.size());
        br.close();
        return extracted;
    }

    public List<Sequence> extractRecordsWithIDLike(String regEx, boolean encode) throws IOException {
        ArrayList<String> oneRegExList = new ArrayList<String>(1);
        oneRegExList.add(regEx);
        return this.extractRecordsWithIDsMatching(oneRegExList, encode);
    }

    public List<Sequence> extractRecords(Collection<String> recordIdList, InputStream is) throws IOException {
        Stack<Sequence> extracted = new Stack<Sequence>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        String currentSeqId = null;
        int found = 0;
        boolean inTargetSequence = false;
        System.out.println("to find: " + recordIdList);
        while ((line = br.readLine()) != null && found < recordIdList.size()) {
            Sequence seq;
            if (line.startsWith(">")) {
                if (inTargetSequence) {
                    inTargetSequence = false;
                    ++found;
                }
                if (!recordIdList.contains(currentSeqId = line.substring(1))) continue;
                seq = new Sequence(currentSeqId);
                inTargetSequence = true;
                extracted.add(seq);
                continue;
            }
            if (!inTargetSequence) continue;
            seq = (Sequence)extracted.pop();
            seq.appendToSequence(line);
            extracted.push(seq);
        }
        System.out.println("Found " + found + " sequences expected to find " + recordIdList.size());
        br.close();
        return extracted;
    }

    public List<Sequence> extractRecords(Collection<String> recordIdList) throws IOException {
        return this.extractRecords(recordIdList, new FileInputStream(this.file));
    }

    public List<AgpEntry> getAGP(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        String seqName = line.substring(1);
        if (seqName.startsWith("chr")) {
            seqName = seqName.substring(3);
        }
        Stack<AgpEntry> agp = new Stack<AgpEntry>();
        boolean inGap = true;
        int currEntrySize = 0;
        int position = 1;
        char[] lineChars = null;
        int num = 1;
        int contig = 1;
        while ((line = br.readLine()) != null) {
            lineChars = line.toCharArray();
            for (int i = 0; i < lineChars.length; ++i) {
                char c = Character.toUpperCase(lineChars[i]);
                if (c == 'N' && (!inGap || agp.isEmpty())) {
                    if (!agp.isEmpty()) {
                        AgpEntry lastContig = agp.peek();
                        lastContig.setEnd(position - 1);
                    }
                    AgpEntry newGap = new AgpEntry(seqName);
                    newGap.setStart(position);
                    newGap.setType(2);
                    newGap.setNumber(num++);
                    newGap.setName("fragment");
                    agp.push(newGap);
                    currEntrySize = 1;
                    inGap = true;
                } else if (c == 'N' && inGap) {
                    ++currEntrySize;
                } else if (c != 'N' && !inGap) {
                    ++currEntrySize;
                } else if (c != 'N' && inGap) {
                    if (!agp.isEmpty()) {
                        AgpEntry lastGap = agp.peek();
                        lastGap.setEnd(position - 1);
                    }
                    AgpEntry newContig = new AgpEntry(seqName);
                    newContig.setStart(position);
                    newContig.setType(4);
                    newContig.setNumber(num++);
                    newContig.setName("contig_" + contig++);
                    agp.push(newContig);
                    currEntrySize = 1;
                    inGap = false;
                }
                ++position;
            }
            if (agp.isEmpty()) continue;
            AgpEntry last = agp.peek();
            last.setEnd(position - 1);
        }
        br.close();
        return agp;
    }

    public void extractRegion(SequenceRegion region) throws IOException {
        ArrayList<SequenceRegion> tmpList = new ArrayList<SequenceRegion>(1);
        tmpList.add(region);
        this.extractRegions(tmpList);
    }

    public void extractRegions(List<? extends SequenceRegion> regions) throws IOException {
        this.extractRegions(regions, false);
    }

    public void extractRegions(List<? extends SequenceRegion> regions, boolean useRegionOrientation) throws IOException {
        FileInputStream fis = new FileInputStream(this.file);
        this.extractRegions(regions, useRegionOrientation, fis);
        fis.close();
    }

    public void extractRegions(List<? extends SequenceRegion> regions, boolean useRegionOrientation, InputStream is) throws IOException {
        HashMap<String, ArrayList<SequenceRegion>> regionMap = new HashMap<String, ArrayList<SequenceRegion>>();
        for (SequenceRegion sequenceRegion : regions) {
            ArrayList<SequenceRegion> idSeqs = (ArrayList<SequenceRegion>)regionMap.get(sequenceRegion.getContainingSequenceId());
            if (idSeqs == null) {
                idSeqs = new ArrayList<SequenceRegion>();
                regionMap.put(sequenceRegion.getContainingSequenceId(), idSeqs);
            }
            idSeqs.add(sequenceRegion);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(inputStreamReader);
        String line = null;
        String currentSeqId = null;
        long currentEndSeqPos = 0L;
        List seqRegions = null;
        Iterator<SequenceRegion> rIt = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith(">")) {
                currentSeqId = line.substring(1).trim();
                currentEndSeqPos = 0L;
                seqRegions = (List)regionMap.get(currentSeqId);
                continue;
            }
            if (seqRegions == null) continue;
            currentEndSeqPos += (long)line.length();
            rIt = seqRegions.iterator();
            Object var14_15 = null;
            while (rIt.hasNext()) {
                SequenceRegion sequenceRegion = rIt.next();
                if ((long)sequenceRegion.getRegionStart() > currentEndSeqPos || (long)sequenceRegion.getRegionEnd() <= currentEndSeqPos - (long)line.length()) continue;
                sequenceRegion.appendToSequence(line.substring((int)Math.max(0L, (long)sequenceRegion.getRegionStart() - (currentEndSeqPos - (long)line.length() + 1L)), (int)Math.min((long)(line.length() - 1), (long)sequenceRegion.getRegionEnd() - (currentEndSeqPos - (long)line.length() + 1L)) + 1));
            }
        }
        for (SequenceRegion sequenceRegion : regions) {
            if (sequenceRegion.getStart() + sequenceRegion.getSequenceBases().length() < sequenceRegion.getEnd()) {
                System.out.println("Reset end was " + sequenceRegion.getEnd() + " but sequence length is " + sequenceRegion.getSequenceBases().length());
                sequenceRegion.setEnd(sequenceRegion.getStart() + sequenceRegion.getSequenceBases().length() - 1);
            }
            if (!useRegionOrientation || !sequenceRegion.inReversedOrientation()) continue;
            sequenceRegion.reverse();
        }
    }

    public void write(List<? extends Sequence> seqs) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.file));
        for (Sequence sequence : seqs) {
            this.write(sequence, bw);
        }
        bw.close();
    }

    public void write(Sequence seq) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.file));
        this.write(seq, bw);
        bw.close();
    }

    public void write(Sequence seq, String fileName) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
        this.write(seq, bw);
        bw.close();
    }

    public void append(List<? extends Sequence> records, String fileName) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName, true));
        this.write(records, bw);
        bw.close();
    }

    public void append(Sequence seq, String output) throws IOException {
        ArrayList<Sequence> tmpList = new ArrayList<Sequence>(1);
        tmpList.add(seq);
        this.append(tmpList, output);
    }

    public void write(List<? extends Sequence> seqs, String fileName) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
        this.write(seqs, bw);
        bw.close();
    }

    public void write(List<? extends Sequence> seqs, BufferedWriter bw) throws IOException {
        Iterator<? extends Sequence> it = seqs.iterator();
        while (it.hasNext()) {
            this.write(it.next(), bw);
        }
    }

    public void write(Sequence seq, BufferedWriter bw) throws IOException {
        StringBuilder sequenceBuilder = seq.getSequenceBuilder();
        if (seq == null || sequenceBuilder.length() == 0) {
            return;
        }
        if (sequenceBuilder.length() == 0) {
            return;
        }
        int currentIndex = 0;
        this.writeSequenceId(seq, bw);
        bw.newLine();
        while (currentIndex < sequenceBuilder.length()) {
            int toWrite = Math.min(60, sequenceBuilder.length() - currentIndex) - 1;
            bw.write(sequenceBuilder.substring(currentIndex, currentIndex + toWrite + 1));
            bw.newLine();
            currentIndex = currentIndex + toWrite + 1;
        }
    }

    protected void writeSequenceId(Sequence seq, BufferedWriter bw) throws IOException {
        bw.write(">" + seq.getId());
    }

    public void unchunk(File[] inDirList, int chunkSize, String unchunkSeqName, String outputFile) throws IOException {
        Sequence unchunked = chunkSize * inDirList.length > 450000000 ? new Sequence(unchunkSeqName, true) : new Sequence(unchunkSeqName, false);
        for (int i = 0; i < inDirList.length; ++i) {
            System.out.println("loading " + inDirList[i].getAbsolutePath());
            FastaSequenceIO chunkIO = new FastaSequenceIO(inDirList[i]);
            Sequence seq = chunkIO.loadAll().get(0);
            unchunked.appendToSequence(seq.getSequenceBases());
            seq.unloadSequence();
        }
        this.write(unchunked, outputFile);
    }

    public void setSource(File newSource) {
        this.file = newSource;
    }

    public void breakUpMultifile(final int sizeToBreakup) throws IOException {
        FileInputStream fis = new FileInputStream(this.file);
        final String outPrefix = this.file.getAbsolutePath();
        FastaParser fp = new FastaParser();
        fp.parse(fis, new FastaHandler(){
            int seqNum = 0;
            int grpNum = 0;
            BufferedWriter out = null;
            int base = 0;

            public void eof(AbstractFastaParser parser) throws IOException {
                this.out.close();
            }

            public void newBase(AbstractFastaParser parser) throws IOException {
                this.out.write(parser.getCurrentBase());
                if (this.base > 0 && this.base % 60 == 0) {
                    this.out.newLine();
                }
            }

            public void newSequence(AbstractFastaParser parser) throws IOException {
                if (this.seqNum % sizeToBreakup == 0) {
                    if (this.out != null) {
                        this.out.close();
                    }
                    this.out = new BufferedWriter(new FileWriter(outPrefix + "_" + this.grpNum++));
                }
                ++this.seqNum;
                this.out.write(">" + parser.getCurrentSequenceId());
                this.out.newLine();
            }
        });
    }
}

