/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.sequence;

import edu.mit.broad.prodinfo.sequence.AbstractFastaParser;
import edu.mit.broad.prodinfo.sequence.FastaQualityHandler;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class FastaQualityParser
extends AbstractFastaParser {
    int currentQual = 0;

    public void parse(InputStream in, FastaQualityHandler handler) throws IOException {
        this.fileSize = 0L;
        byte[] buf = new byte[8192];
        int i = 0;
        int read = 0;
        boolean readingSeqId = false;
        StringBuilder seqIdBuilder = new StringBuilder();
        try {
            while ((read = in.read(buf)) > 0) {
                this.fileSize += (long)read;
                for (int j = 0; j < read; ++j) {
                    char c = (char)buf[j];
                    ++this.offset;
                    if (c == '>') {
                        readingSeqId = true;
                        continue;
                    }
                    if (readingSeqId) {
                        if (c != '\n' & c != '\r') {
                            seqIdBuilder.append(c);
                            continue;
                        }
                        this.setCurrentSequenceId(seqIdBuilder.toString());
                        System.out.println("new sequence " + this.getCurrentSequenceId());
                        handler.newSequence(this);
                        readingSeqId = false;
                        seqIdBuilder = new StringBuilder();
                        continue;
                    }
                    if (c == ' ' || c == '\n' || c == '\r') {
                        handler.newQuality(this);
                        this.currentQual = 0;
                        i = 0;
                        continue;
                    }
                    this.currentQual = Character.getNumericValue(c) + this.currentQual * (int)Math.pow(10.0, i);
                    ++i;
                }
            }
        }
        catch (EOFException eof) {
            handler.eof(this);
        }
        handler.eof(this);
    }

    public int getCurrentQuality() {
        return this.currentQual;
    }
}

