/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.sequence;

import edu.mit.broad.prodinfo.sequence.AbstractFastaParser;
import edu.mit.broad.prodinfo.sequence.FastaQualityHandler;
import edu.mit.broad.prodinfo.sequence.FastaQualityParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class FastaQualityIndex {
    private HashMap<String, SequenceFileLayout> indexMap = new HashMap();
    long fileSize = 0L;

    public void createIndexFromQualityFile(String fastaQualityFile, final long period) throws IOException {
        FastaQualityParser fqp = new FastaQualityParser();
        fqp.parse(new FileInputStream(fastaQualityFile), new FastaQualityHandler(){
            int baseNum = 0;

            public void eof(AbstractFastaParser parser) throws IOException {
                ++this.baseNum;
                SequenceFileLayout sfl = (SequenceFileLayout)FastaQualityIndex.this.indexMap.get(parser.getCurrentSequenceId());
                sfl.addOffset(this.baseNum, parser.getFileSize());
                sfl.setLength(this.baseNum);
                FastaQualityIndex.this.fileSize = parser.getFileSize();
            }

            public void newQuality(FastaQualityParser parser) throws IOException {
                if ((long)this.baseNum % period == 0L) {
                    SequenceFileLayout sfl = (SequenceFileLayout)FastaQualityIndex.this.indexMap.get(parser.getCurrentSequenceId());
                    sfl.addOffset(this.baseNum, parser.getOffset());
                }
                ++this.baseNum;
            }

            public void newSequence(AbstractFastaParser parser) {
                String seqId = parser.getCurrentSequenceId();
                SequenceFileLayout sfl = new SequenceFileLayout(seqId);
                FastaQualityIndex.this.indexMap.put(seqId, sfl);
                this.baseNum = 0;
            }

            public void newBase(AbstractFastaParser parser) throws IOException {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAscii(String indexFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(indexFile));
        try {
            String line;
            String header = br.readLine();
            String[] headerInfo = header.split("\t");
            if ("HEADER" != headerInfo[0]) {
                throw new IOException("Index file format error, first line should  start with HEADER");
            }
            this.fileSize = Long.parseLong(headerInfo[2]);
            while ((line = br.readLine()) != null) {
                String[] lineTopInfo = line.split("\\|");
                String seqId = lineTopInfo[0];
                SequenceFileLayout sfl = new SequenceFileLayout(seqId);
                this.indexMap.put(seqId, sfl);
                String[] offsetInfo = lineTopInfo[1].split(" ");
                for (int i = 0; i < offsetInfo.length; ++i) {
                    String[] basePositionInfo = offsetInfo[i].split("-");
                    sfl.addOffset(Integer.parseInt(basePositionInfo[0]), Long.parseLong(basePositionInfo[1]));
                }
            }
        }
        finally {
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsText(String outFile) throws IOException {
        ArrayList<String> seqList = new ArrayList<String>(this.indexMap.keySet());
        Collections.sort(seqList);
        Iterator seqIt = seqList.iterator();
        BufferedWriter bw = new BufferedWriter(new FileWriter(outFile));
        try {
            bw.write("HEADER\t" + seqList.size() + "\t" + this.fileSize);
            bw.newLine();
            while (seqIt.hasNext()) {
                String seqId = (String)seqIt.next();
                SequenceFileLayout sfl = this.indexMap.get(seqId);
                bw.write(sfl.toString());
                bw.newLine();
            }
        }
        finally {
            bw.close();
        }
    }

    public static void main(String[] args) throws Exception {
        String file = args[0];
        int period = Integer.parseInt(args[1]);
        FastaQualityIndex fqp = new FastaQualityIndex();
        fqp.createIndexFromQualityFile(args[0], period);
        fqp.writeAsText(file + ".idx");
    }

    public static class SequenceFileLayout {
        private String seqId;
        LinkedHashMap<Integer, Long> offsetMap = new LinkedHashMap();
        int length;

        public SequenceFileLayout(String seqId) {
            this.seqId = seqId;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void addOffset(int baseNum, long offset) {
            this.offsetMap.put(baseNum, offset);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.seqId);
            sb.append("|");
            for (int pos : this.offsetMap.keySet()) {
                sb.append(pos).append("-").append(this.offsetMap.get(pos));
                sb.append(" ");
            }
            return sb.toString();
        }
    }
}

