/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.sequence;

import edu.mit.broad.prodinfo.sequence.AbstractFastaParser;
import edu.mit.broad.prodinfo.sequence.FastaQualityHandler;
import edu.mit.broad.prodinfo.sequence.FastaQualityParser;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class FastaQualityBinaryIO {
    public static final int SEQ_ID_REC_LENGTH = 300;
    public static final int BUFFER_SIZE = 8192;

    public void createBinaryFromAscii(InputStream in, String outFile) throws IOException {
        FastaQualityParser fqp = new FastaQualityParser();
        final RandomAccessFile out = new RandomAccessFile(outFile, "rw");
        final HashMap sequenceOffsetMap = new HashMap();
        fqp.parse(in, new FastaQualityHandler(){
            int baseNum = 0;
            long sequenceStartOffset = 0L;
            byte[] buffer = new byte[8192];
            int bufferFill = 0;

            public void eof(AbstractFastaParser parser) throws IOException {
                ++this.baseNum;
                out.write(this.buffer, 0, this.bufferFill);
                out.seek(this.sequenceStartOffset + 300L);
                out.writeInt(this.baseNum);
            }

            public void newQuality(FastaQualityParser parser) throws IOException {
                this.buffer[this.bufferFill++] = (byte)parser.getCurrentQuality();
                if (this.bufferFill == 8192) {
                    out.write(this.buffer);
                    this.bufferFill = 0;
                }
                ++this.baseNum;
            }

            public void newSequence(AbstractFastaParser parser) throws IOException {
                int i;
                long currentOffset = out.getFilePointer();
                if (out.getFilePointer() > 0L) {
                    out.write(this.buffer, 0, this.bufferFill);
                    out.writeChar(10);
                    this.bufferFill = 0;
                    currentOffset = out.getFilePointer();
                    out.seek(this.sequenceStartOffset + 300L);
                    out.writeInt(this.baseNum);
                    out.seek(currentOffset);
                }
                String seqId = parser.getCurrentSequenceId();
                char[] seqIdChars = seqId.toCharArray();
                int bytesToWrite = Math.min(300, seqIdChars.length);
                this.sequenceStartOffset = currentOffset;
                sequenceOffsetMap.put(seqId, currentOffset);
                for (i = 0; i < bytesToWrite; ++i) {
                    out.write((byte)seqIdChars[i]);
                }
                for (i = 0; i < 300 - bytesToWrite; ++i) {
                    out.write(32);
                }
                out.skipBytes(4);
                this.baseNum = 0;
            }

            public void newBase(AbstractFastaParser parser) throws IOException {
            }
        });
        out.close();
        BufferedWriter bw = new BufferedWriter(new FileWriter(outFile + ".idx"));
        ArrayList sortedSeqIds = new ArrayList(sequenceOffsetMap.keySet());
        Collections.sort(sortedSeqIds);
        for (String seqId : sortedSeqIds) {
            bw.write(seqId + "\t" + sequenceOffsetMap.get(seqId));
            bw.newLine();
        }
        bw.close();
    }

    public void toDBFromAscii(InputStream in, final Connection conn, String table) throws IOException, SQLException {
        String insSQL = "INSERT INTO " + table + "(scaffold, quality) VALUES (?, ?)";
        String selSQL = "SELECT quality FROM " + table + " WHERE scaffold = ?";
        String updSQL = "UPDATE " + table + " SET quality = ?, gap = ?, q10 = ?, q15 = ?, q20 = ?, q25  =?, q30 = ? " + " WHERE scaffold = ?";
        FastaQualityParser fqp = new FastaQualityParser();
        final PreparedStatement insertCS = conn.prepareStatement(insSQL);
        final PreparedStatement selectCS = conn.prepareStatement(selSQL);
        final PreparedStatement updateCS = conn.prepareStatement(updSQL);
        fqp.parse(in, new FastaQualityHandler(){
            int baseNum = 0;
            byte[] buffer = new byte[8192];
            int bufferFill = 0;
            int seqNum = 0;
            String workingSeqId = null;
            OutputStream blobOS = null;
            Blob qualityBlob = null;
            int gapNum = 0;
            int q10OrLessNum = 0;
            int q15OrLessNum = 0;
            int q20OrLessNum = 0;
            int q25OrLessNum = 0;
            int q30OrLessNum = 0;

            public void eof(AbstractFastaParser parser) throws IOException {
                ++this.baseNum;
                this.blobOS.write(this.buffer, 0, this.bufferFill);
                this.blobOS.close();
                try {
                    updateCS.setString(8, this.workingSeqId);
                    updateCS.setBlob(1, this.qualityBlob);
                    updateCS.setInt(2, this.gapNum);
                    updateCS.setInt(3, this.q10OrLessNum);
                    updateCS.setInt(4, this.q15OrLessNum + this.q10OrLessNum);
                    updateCS.setInt(5, this.q20OrLessNum + this.q15OrLessNum + this.q10OrLessNum);
                    updateCS.setInt(6, this.q25OrLessNum + this.q20OrLessNum + this.q15OrLessNum + this.q10OrLessNum);
                    updateCS.setInt(7, this.q30OrLessNum + this.q25OrLessNum + this.q20OrLessNum + this.q15OrLessNum + this.q10OrLessNum);
                    updateCS.execute();
                    conn.commit();
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.getStackTrace());
                    throw new IOException(sqle.getMessage());
                }
                System.out.println("Got EOF writing last buffer ");
            }

            public void newQuality(FastaQualityParser parser) throws IOException {
                int qual = parser.getCurrentQuality();
                this.buffer[this.bufferFill++] = (byte)qual;
                if (this.bufferFill == 8192) {
                    this.blobOS.write(this.buffer);
                    this.bufferFill = 0;
                }
                if (qual == 0) {
                    ++this.gapNum;
                } else if (qual <= 10) {
                    ++this.q10OrLessNum;
                } else if (qual <= 15) {
                    ++this.q15OrLessNum;
                } else if (qual <= 20) {
                    ++this.q20OrLessNum;
                } else if (qual <= 25) {
                    ++this.q25OrLessNum;
                } else if (qual <= 30) {
                    ++this.q30OrLessNum;
                }
                ++this.baseNum;
            }

            public void newSequence(AbstractFastaParser parser) throws IOException {
                try {
                    if (this.seqNum > 0) {
                        System.out.println("Got new sequence, writing last " + this.workingSeqId + " buffer ");
                        this.blobOS.write(this.buffer, 0, this.bufferFill);
                        this.blobOS.flush();
                        this.blobOS.close();
                        updateCS.setString(8, this.workingSeqId);
                        updateCS.setBlob(1, this.qualityBlob);
                        updateCS.setInt(2, this.gapNum);
                        updateCS.setInt(3, this.q10OrLessNum);
                        updateCS.setInt(4, this.q15OrLessNum + this.q10OrLessNum);
                        updateCS.setInt(5, this.q20OrLessNum + this.q15OrLessNum + this.q10OrLessNum);
                        updateCS.setInt(6, this.q25OrLessNum + this.q20OrLessNum + this.q15OrLessNum + this.q10OrLessNum);
                        updateCS.setInt(7, this.q30OrLessNum + this.q25OrLessNum + this.q20OrLessNum + this.q15OrLessNum + this.q10OrLessNum);
                        updateCS.execute();
                        conn.commit();
                        this.bufferFill = 0;
                    }
                    String seqId = parser.getCurrentSequenceId();
                    insertCS.setString(1, seqId);
                    insertCS.setBytes(2, new byte[0]);
                    insertCS.execute();
                    selectCS.setString(1, parser.getCurrentSequenceId());
                    selectCS.executeQuery();
                    ResultSet rs = selectCS.getResultSet();
                    rs.next();
                    this.qualityBlob = rs.getBlob(1);
                    this.blobOS = this.qualityBlob.setBinaryStream(1L);
                    ++this.seqNum;
                    this.baseNum = 0;
                    this.gapNum = 0;
                    this.q10OrLessNum = 0;
                    this.q15OrLessNum = 0;
                    this.q20OrLessNum = 0;
                    this.q25OrLessNum = 0;
                    this.q30OrLessNum = 0;
                    this.workingSeqId = seqId;
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace(System.out);
                    throw new IOException(sqle.getMessage());
                }
            }

            public void newBase(AbstractFastaParser parser) throws IOException {
            }
        });
    }

    public void createAsciiFromBinary(String binaryQualityFile, int numQualBasesPerRow) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(binaryQualityFile, "r");
        byte[] seqIdBytes = new byte[300];
        System.out.println("offset " + raf.getFilePointer());
        raf.read(seqIdBytes);
        System.out.println("offset after reading seq name " + raf.getFilePointer());
        String seqId = new String(seqIdBytes).trim();
        int seqIdLength = raf.readInt();
        System.out.println("offset after reading seq length " + raf.getFilePointer());
        byte[] firstQual = new byte[seqIdLength];
        raf.read(firstQual);
        System.out.println("got seq id " + seqId + " of length " + seqIdLength);
        for (int i = 0; i < firstQual.length; ++i) {
            if (i > 0 && i % 26 == 0) {
                System.out.print("\n");
            }
            System.out.print(firstQual[i] + " ");
        }
        raf.close();
    }

    public int[] getQualityBases(Connection conn, String table, String seqId, int start, int numOfBases) throws SQLException {
        int[] qualities = null;
        String selSQL = "SELECT quality FROM " + table + " WHERE scaffold = ?";
        PreparedStatement selectCS = conn.prepareStatement(selSQL);
        selectCS.setString(1, seqId);
        ResultSet rs = selectCS.executeQuery();
        if (rs.next()) {
            Blob quality = rs.getBlob(1);
            byte[] qualBytes = quality.getBytes(start + 1, numOfBases);
            qualities = new int[qualBytes.length];
            for (int i = 0; i < qualBytes.length; ++i) {
                qualities[i] = qualBytes[i];
            }
        }
        return qualities;
    }

    public int[] getQualityBases(Connection conn, String table, String seqId) throws SQLException {
        int[] qualities = null;
        String selSQL = "SELECT quality FROM " + table + " WHERE scaffold = ?";
        PreparedStatement selectCS = conn.prepareStatement(selSQL);
        selectCS.setString(1, seqId);
        ResultSet rs = selectCS.executeQuery();
        if (rs.next()) {
            Blob quality = rs.getBlob(1);
            long size = quality.length();
            byte[] qualBytes = quality.getBytes(1L, (int)size);
            qualities = new int[(int)size];
            for (int i = 0; i < qualBytes.length; ++i) {
                qualities[i] = qualBytes[i];
            }
        }
        return qualities;
    }
}

