/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.multiplealignment;

import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentIO;
import edu.mit.broad.prodinfo.util.CLUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhylipInterleavedMultipleAlignmentIO
implements MultipleAlignmentIO {
    static final int DEFAULT_SPACING = 9;
    static final int MAX_CHARS_PER_LINE = 90;
    static final int SEQ_NAME_LENGTH = 10;
    private int spacing = 9;

    @Override
    public MultipleAlignment load(String source) throws IOException, ParseException {
        FileInputStream fis = new FileInputStream(new File(source));
        MultipleAlignment m = this.load(fis);
        fis.close();
        return m;
    }

    @Override
    public MultipleAlignment load(String fileName, List<String> sequencesToLoad) throws IOException, ParseException {
        FileInputStream fis = new FileInputStream(new File(fileName));
        MultipleAlignment m = this.load(fis, sequencesToLoad);
        fis.close();
        return m;
    }

    @Override
    public MultipleAlignment load(InputStream in) throws IOException, ParseException {
        return this.load(in, new ArrayList<String>());
    }

    @Override
    public MultipleAlignment load(InputStream in, List<String> sequencesToLoad) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = br.readLine();
        String[] headerInfo = line.split("\\s+");
        int seqNum = Integer.parseInt(headerInfo[1]);
        boolean isFirstBatch = true;
        int seqCounter = 0;
        MultipleAlignment ma = new MultipleAlignment();
        String[] alignedSeqIds = new String[seqNum];
        while ((line = br.readLine()) != null) {
            MultipleAlignment.AlignedSequence alignedSequence;
            if (line.trim().length() == 0) continue;
            if (isFirstBatch) {
                String seqId = line.substring(0, 10).trim();
                line = line.substring(10);
                alignedSeqIds[seqCounter] = seqId;
                alignedSequence = new MultipleAlignment.AlignedSequence(seqId);
                alignedSequence.setId(seqId);
                ma.addSequence(alignedSequence);
                isFirstBatch = seqCounter < seqNum - 1;
            }
            String[] seqAlignedBlocks = line.split("\\s+");
            alignedSequence = ma.getAlignedSequence(alignedSeqIds[seqCounter]);
            for (int i = 0; i < seqAlignedBlocks.length; ++i) {
                alignedSequence.appendToSequence(seqAlignedBlocks[i]);
            }
            seqCounter = (seqCounter + 1) % seqNum;
        }
        return ma;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public void write(BufferedWriter bw, MultipleAlignment ma) throws IOException {
        List<MultipleAlignment.AlignedSequence> seqs = ma.getAlignedSequences();
        int seqNum = seqs.size();
        if (seqs.size() == 0) {
            return;
        }
        int nucleotideNum = seqs.get(0).getSequenceBases().length();
        bw.write("\t" + seqNum + "\t" + nucleotideNum);
        bw.newLine();
        for (int i = 0; i < seqs.size(); ++i) {
            MultipleAlignment.AlignedSequence seq = seqs.get(i);
            CLUtil.writeLeftJustifiedField(bw, seq.getName(), 10);
            this.writeLine(bw, seq.getSequenceBases(), 0);
            bw.newLine();
        }
        bw.newLine();
        int lineNum = (int)Math.ceil((float)nucleotideNum / 90.0f);
        for (int line = 1; line < lineNum; ++line) {
            for (int i = 0; i < seqs.size(); ++i) {
                MultipleAlignment.AlignedSequence seq = seqs.get(i);
                this.writeLine(bw, seq.getSequenceBases(), line);
                bw.newLine();
            }
            bw.newLine();
        }
    }

    @Override
    public void write(BufferedWriter bw, MultipleAlignment ma, List<String> order) throws IOException {
        if (order == null || order.size() == 0) {
            this.write(bw, ma);
            return;
        }
        List<MultipleAlignment.AlignedSequence> seqs = ma.getAlignedSequences();
        int seqNum = order.size();
        int nucleotideNum = seqs.get(0).getSequenceBases().length();
        bw.write("\t" + seqNum + "\t" + nucleotideNum);
        bw.newLine();
        for (int i = 0; i < seqNum; ++i) {
            MultipleAlignment.AlignedSequence seq = ma.getAlignedSequence(order.get(i));
            CLUtil.writeLeftJustifiedField(bw, seq.getName(), 10);
            this.writeLine(bw, seq.getSequenceBases(), 0);
            bw.newLine();
        }
        bw.newLine();
        int lineNum = (int)Math.ceil((float)nucleotideNum / 90.0f);
        for (int line = 1; line < lineNum; ++line) {
            for (int i = 0; i < seqNum; ++i) {
                MultipleAlignment.AlignedSequence seq = ma.getAlignedSequence(order.get(i));
                this.writeLine(bw, seq.getSequenceBases(), line);
                bw.newLine();
            }
            bw.newLine();
        }
    }

    private int writeLine(BufferedWriter bw, String sequence, int lineNum) throws IOException {
        int start = lineNum * 90;
        int end = Math.min(start + 90, sequence.length());
        String seqToWrite = sequence.substring(start, end);
        int chunkNum = (int)Math.ceil((float)seqToWrite.length() / (float)this.spacing);
        int pos = 0;
        for (int i = 0; i < chunkNum; ++i) {
            if (i < chunkNum - 1) {
                bw.write(seqToWrite.substring(pos, pos + this.spacing));
                bw.write(" ");
            } else {
                bw.write(seqToWrite.substring(pos));
            }
            pos += this.spacing;
        }
        return pos;
    }

    @Override
    public String getPreferredFileExtension() {
        return "iphy";
    }
}

