/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.multiplealignment;

import edu.mit.broad.prodinfo.multiplealignment.FastaMultipleAlignmentIO;
import edu.mit.broad.prodinfo.multiplealignment.MAFIO;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentIO;
import edu.mit.broad.prodinfo.multiplealignment.PhylipInterleavedMultipleAlignmentIO;
import edu.mit.broad.prodinfo.multiplealignment.PhylipSequencialMultipleAlignmentIO;

public class MultipleAlignmentIOFactory {
    public static MultipleAlignmentIO create(String format) {
        MultipleAlignmentIO maio = null;
        if ("FASTA".equalsIgnoreCase(format)) {
            maio = new FastaMultipleAlignmentIO();
        } else if ("PHYLIP".equalsIgnoreCase(format)) {
            maio = new PhylipInterleavedMultipleAlignmentIO();
        } else if ("SEQPHYLIP".equalsIgnoreCase(format)) {
            maio = new PhylipSequencialMultipleAlignmentIO();
        } else if ("MAF".equalsIgnoreCase(format)) {
            maio = new MAFIO();
        } else {
            throw new RuntimeException("Unsuported format " + format);
        }
        return maio;
    }
}

