/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.multiplealignment;

import Jama.Matrix;
import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentIO;
import edu.mit.broad.prodinfo.sequence.Sequence;
import edu.mit.broad.prodinfo.sequence.SequenceRegion;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAlignment {
    private float score;
    private LinkedHashMap<String, AlignedSequence> alignments;
    private MultipleAlignmentIO ioHelper;
    public static final short A_CODE = 0;
    public static final short C_CODE = 1;
    public static final short G_CODE = 2;
    public static final short T_CODE = 3;
    public static final short GAP_CODE = 4;
    protected static int UNGAPPED_ALPHABET_SIZE = 4;
    private String referenceId;
    private boolean isRefGapped;

    public MultipleAlignment() {
        this.alignments = new LinkedHashMap();
    }

    public MultipleAlignment(List<? extends MultipleAlignment> alnBlocks, String ref, String[] seqs) {
    }

    public void encode() {
        for (AlignedSequence as : this.alignments.values()) {
            as.encodeSequenceIgnoreCase();
            as.unloadSequence();
        }
    }

    public void encodeAsMatrix() {
        for (AlignedSequence as : this.alignments.values()) {
            as.encodeSequenceAsVector();
            as.unloadSequence();
        }
    }

    public void reverse() {
        for (AlignedSequence as : this.alignments.values()) {
            as.reverse();
        }
    }

    public int length() {
        return this.alignments.values().iterator().next().getLength();
    }

    public Map<String, Short> getColumn(int i) {
        LinkedHashMap<String, Short> col = new LinkedHashMap<String, Short>(this.getAlignedSequenceIds().size());
        for (String seqId : this.getAlignedSequenceIds()) {
            col.put(seqId, this.alignments.get(seqId).getEncodedSequence()[i - this.getReferenceStart()]);
        }
        return col;
    }

    public Map<String, Matrix> getColumnsAsVector(int start, int number) throws ArrayIndexOutOfBoundsException {
        LinkedHashMap<String, Matrix> cols = new LinkedHashMap<String, Matrix>(this.getAlignedSequenceIds().size());
        Iterator<String> seqIdIt = this.getAlignedSequenceIds().iterator();
        start -= this.getReferenceStart();
        while (seqIdIt.hasNext()) {
            String seqId = seqIdIt.next();
            short[] alignedSeqSeq = this.alignments.get(seqId).getEncodedSequence();
            Matrix alignmentMatrix = this.alignments.get(seqId).getVectorEncodedSequence();
            Matrix seqRegion = new Matrix(UNGAPPED_ALPHABET_SIZE, number);
            for (int j = start; j < start + number; ++j) {
                if (alignedSeqSeq != null) {
                    if (alignedSeqSeq[j] >= UNGAPPED_ALPHABET_SIZE) continue;
                    seqRegion.set((int)alignedSeqSeq[j], j - start, 1.0);
                    continue;
                }
                if (alignmentMatrix == null) continue;
                for (int i = 0; i < alignmentMatrix.getRowDimension(); ++i) {
                    seqRegion.set(i, j - start, alignmentMatrix.get(i, j));
                }
            }
            cols.put(seqId, seqRegion);
        }
        return cols;
    }

    public Map<String, Matrix> getAsMatrix() {
        LinkedHashMap<String, Matrix> matrixAlignment = new LinkedHashMap<String, Matrix>(this.getAlignedSequenceIds().size());
        for (String seqId : this.getAlignedSequenceIds()) {
            matrixAlignment.put(seqId, this.getAlignedSequence(seqId).getVectorEncodedSequence());
        }
        return matrixAlignment;
    }

    public void addShortEncodedColumn(Map<String, Short> col) {
        for (String seqId : col.keySet()) {
            AlignedSequence seq = this.getAlignedSequence(seqId);
            if (seq == null) {
                seq = new AlignedSequence(seqId);
                seq.setId(seqId);
                this.addSequence(seq);
            }
            seq.appendToSequence(this.decodeShort(col.get(seqId)));
        }
    }

    public void addShortEncodedRegion(Map<String, short[]> region) {
        if (region == null || region.isEmpty()) {
            return;
        }
        int cols = region.values().iterator().next().length;
        for (int i = 0; i < cols; ++i) {
            for (String seqId : region.keySet()) {
                AlignedSequence seq = this.getAlignedSequence(seqId);
                if (seq == null) {
                    seq = new AlignedSequence(seqId);
                    seq.setId(seqId);
                    this.addSequence(seq);
                }
                seq.appendToSequence(this.decodeShort(region.get(seqId)[i]));
            }
        }
    }

    public char decodeShort(Short nucleotide) {
        char decoded = ' ';
        switch (nucleotide) {
            case 0: {
                decoded = 'A';
                break;
            }
            case 1: {
                decoded = 'C';
                break;
            }
            case 2: {
                decoded = 'G';
                break;
            }
            case 3: {
                decoded = 'T';
                break;
            }
            default: {
                decoded = '-';
            }
        }
        return decoded;
    }

    public void addSequence(AlignedSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("Trying to add a null sequence");
        }
        if (this.alignments.keySet().contains(seq.getContainingSequenceId())) {
            throw new IllegalArgumentException("Sequence " + seq.getContainingSequenceId() + " has already been added");
        }
        this.alignments.put(seq.getContainingSequenceId(), seq);
    }

    public void addSequences(List<AlignedSequence> sequences) {
        Iterator<AlignedSequence> it = sequences.iterator();
        while (it.hasNext()) {
            this.addSequence(it.next());
        }
    }

    public boolean isEmpty() {
        return this.alignments.isEmpty();
    }

    public void setIOHelper(MultipleAlignmentIO maio) {
        this.ioHelper = maio;
    }

    protected MultipleAlignmentIO getIOHelper() {
        return this.ioHelper;
    }

    public void write(BufferedWriter bw) throws IOException {
        if (this.ioHelper == null) {
            throw new IllegalStateException("The MultipleAlignmentIO (ioHelper) is null set it first");
        }
        this.ioHelper.write(bw, this);
    }

    public void write(BufferedWriter bw, List<String> order) throws IOException {
        if (this.ioHelper == null) {
            throw new IllegalStateException("The MultipleAlignmentIO (ioHelper) is null set it first");
        }
        this.ioHelper.write(bw, this, order);
    }

    public MultipleAlignment sampleColumns(int colNum, int numConsecutiveCols) {
        Random r = new Random();
        LinkedHashMap sequenceCharacters = new LinkedHashMap(this.getAlignedSequenceIds().size());
        Iterator<String> seqIdIt = this.getAlignedSequenceIds().iterator();
        MultipleAlignment sampled = new MultipleAlignment();
        while (seqIdIt.hasNext()) {
            String seq = seqIdIt.next();
            AlignedSequence alignedSeq = this.getAlignedSequence(seq);
            char[] seqBasesArray = alignedSeq.getSequenceBases().toCharArray();
            ArrayList<Character> seqChars = new ArrayList<Character>(seqBasesArray.length);
            sequenceCharacters.put(seq, seqChars);
            for (int i = 0; i < seqBasesArray.length; ++i) {
                seqChars.add(Character.valueOf(seqBasesArray[i]));
            }
            AlignedSequence newSeq = new AlignedSequence(alignedSeq);
            newSeq.unloadSequence();
            sampled.addSequence(newSeq);
        }
        int length = ((List)sequenceCharacters.values().iterator().next()).size();
        sampled.setReferenceId(this.getReferenceId());
        for (int i = 0; i < colNum; ++i) {
            int col = r.nextInt(length - numConsecutiveCols + 1);
            for (String seqId : this.getAlignedSequenceIds()) {
                AlignedSequence seq = sampled.getAlignedSequence(seqId);
                List seqChars = (List)sequenceCharacters.get(seqId);
                for (int j = 0; j < numConsecutiveCols; ++j) {
                    seq.appendToSequence(((Character)seqChars.get(col + j)).charValue());
                }
            }
        }
        return sampled;
    }

    public void permuteColumns() {
        Random r = new Random();
        LinkedHashMap sequenceCharacters = new LinkedHashMap(this.getAlignedSequenceIds().size());
        for (String seq : this.getAlignedSequenceIds()) {
            AlignedSequence alignedSeq = this.getAlignedSequence(seq);
            char[] seqBasesArray = alignedSeq.getSequenceBases().toCharArray();
            ArrayList<Character> seqChars = new ArrayList<Character>(seqBasesArray.length);
            sequenceCharacters.put(seq, seqChars);
            for (int i = 0; i < seqBasesArray.length; ++i) {
                seqChars.add(Character.valueOf(seqBasesArray[i]));
            }
            alignedSeq.unloadSequence();
        }
        for (int length = ((List)sequenceCharacters.values().iterator().next()).size(); length > 0; --length) {
            int pos = r.nextInt(length);
            for (String seqId : this.alignments.keySet()) {
                AlignedSequence seq = this.alignments.get(seqId);
                List seqChars = (List)sequenceCharacters.get(seqId);
                seq.appendToSequence(((Character)seqChars.remove(pos)).charValue());
            }
        }
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public AlignedSequence getAlignedSequence(String containingSequenceId) {
        return this.alignments.get(containingSequenceId);
    }

    public List<AlignedSequence> getAlignedSequences() {
        return new ArrayList<AlignedSequence>(this.alignments.values());
    }

    public List<String> getAlignedSequenceIds() {
        return new ArrayList<String>(this.alignments.keySet());
    }

    public boolean overlaps(SequenceRegion region) {
        boolean overlap = false;
        AlignedSequence seq = this.alignments.get(region.getContainingSequenceId());
        if (seq != null) {
            overlap = seq.overlaps(region);
        }
        return overlap;
    }

    public String getReferenceId() {
        String refId = null;
        if (this.referenceId != null) {
            refId = this.referenceId;
        } else if (!this.alignments.isEmpty()) {
            refId = this.alignments.keySet().iterator().next();
        }
        return refId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId.intern();
    }

    public int getReferenceStart() {
        AlignedSequence refChunk = this.getReference();
        return refChunk == null ? -1 : refChunk.getStart();
    }

    public AlignedSequence getReference() {
        AlignedSequence reference = null;
        if (this.referenceId != null) {
            reference = this.getAlignedSequence(this.referenceId);
        } else if (this.alignments.size() > 0) {
            reference = this.alignments.values().iterator().next();
        }
        return reference;
    }

    public int getReferenceEnd() {
        AlignedSequence refChunk = this.getReference();
        return refChunk == null ? -1 : refChunk.getEnd();
    }

    public boolean isRefGapped() {
        return this.isRefGapped;
    }

    public void setRefGapped(boolean isRefGapped) {
        this.isRefGapped = isRefGapped;
    }

    protected Iterator<AlignedSequence> getAlignedSequences(String refId, int refStart, int refEnd, boolean reverse) {
        ArrayList seqs = new ArrayList(this.alignments.size());
        return seqs.iterator();
    }

    public MultipleAlignment getConcatenatedSubAlignment(String refId, List<? extends GenomicAnnotation> annotations) {
        MultipleAlignment result = new MultipleAlignment();
        result.setIOHelper(this.ioHelper);
        Iterator<? extends GenomicAnnotation> it = annotations.iterator();
        GenomicAnnotation ga = null;
        while (it.hasNext()) {
            ga = it.next();
            result.append(this.getSubAlignment(refId, ga.getStart(), ga.getEnd(), ga.inReversedOrientation()));
        }
        return result;
    }

    public void compress() {
        AlignedSequence seq;
        HashMap<String, StringBuilder> compressSequenceMap = new HashMap<String, StringBuilder>(this.getAlignedSequenceIds().size());
        List<int[]> ungappedRefIslands = this.getUngappedReferenceIslands();
        Iterator<int[]> refIslandIt = ungappedRefIslands.iterator();
        while (refIslandIt.hasNext()) {
            Iterator<AlignedSequence> seqIt = this.getAlignedSequences().iterator();
            int[] ungappedIsland = refIslandIt.next();
            while (seqIt.hasNext()) {
                seq = seqIt.next();
                StringBuilder compressedSeqBuilder = (StringBuilder)compressSequenceMap.get(seq.getId());
                if (compressedSeqBuilder == null) {
                    compressedSeqBuilder = new StringBuilder();
                    compressSequenceMap.put(seq.getId(), compressedSeqBuilder);
                }
                compressedSeqBuilder.append(seq.getSequenceBases().substring(ungappedIsland[0], ungappedIsland[1]));
            }
        }
        for (String seqId : compressSequenceMap.keySet()) {
            seq = this.getAlignedSequence(seqId);
            seq.setSequenceBases(((StringBuilder)compressSequenceMap.get(seqId)).toString());
        }
        this.isRefGapped = false;
    }

    public void remove(List<String> removeList) {
        for (String toRemove : removeList) {
            System.out.print("To remove " + toRemove + " ... ");
            AlignedSequence removedSeq = (AlignedSequence)this.alignments.remove(toRemove);
            System.out.println(removedSeq == null ? " not found " : "yes");
        }
    }

    public MultipleAlignment getSubAlignment(int refStart, int refEnd, boolean reverse) {
        return this.getSubAlignment(this.getReferenceId(), refStart, refEnd, reverse);
    }

    public int getNumberOfAligningSequences() {
        int i = 0;
        for (AlignedSequence seq : this.getAlignedSequences()) {
            if (seq.getUngappedLength() <= 0) continue;
            ++i;
        }
        return i;
    }

    public MultipleAlignment getSubAlignment(String refId, int refStart, int refEnd, boolean reverse) {
        MultipleAlignment result = new MultipleAlignment();
        BasicGenomicAnnotation target = new BasicGenomicAnnotation("ReferenceTarget");
        target.setStart(refStart);
        target.setEnd(refEnd);
        AlignedSequence ref = this.alignments.get(refId);
        if (ref == null) {
            throw new IllegalArgumentException("Bad refId, multiple alignment does not include " + refId);
        }
        target.takeIntersection(ref);
        int stringStartPos = ref.getGapAdjustedCoordinate(target.getStart() - ref.getRegionStart());
        int stringEndPos = ref.getGapAdjustedCoordinate(target.getEnd() - ref.getRegionStart());
        Iterator<AlignedSequence> it = this.getAlignedSequences().iterator();
        SequenceRegion tmpRegion = null;
        while (it.hasNext()) {
            AlignedSequence seq = it.next();
            tmpRegion = seq.getRegion(stringStartPos, stringEndPos);
            if (reverse) {
                tmpRegion.reverse();
            }
            AlignedSequence newSeq = new AlignedSequence(tmpRegion.getContainingSequenceId());
            newSeq.setRegionStart(seq.getRegionStart() + seq.getSequencePosition(stringStartPos));
            newSeq.setRegionEnd(seq.getRegionStart() + seq.getSequencePosition(stringEndPos));
            newSeq.setChromosome(seq.getChromosome());
            newSeq.setSequence(tmpRegion);
            newSeq.setName(tmpRegion.getContainingSequenceId());
            result.addSequence(newSeq);
        }
        result.setIOHelper(this.ioHelper);
        return result;
    }

    public void append(MultipleAlignment other) {
        if (this.alignments.isEmpty()) {
            for (AlignedSequence seq : other.getAlignedSequences()) {
                AlignedSequence seqClone = new AlignedSequence(seq);
                this.alignments.put(seq.getId(), seqClone);
            }
        } else {
            Iterator<AlignedSequence> it = this.getAlignedSequences().iterator();
            AlignedSequence otherSeq = null;
            AlignedSequence thisSeq = null;
            while (it.hasNext()) {
                thisSeq = it.next();
                otherSeq = other.getAlignedSequence(thisSeq.getName());
                if (otherSeq == null) {
                    throw new IllegalStateException("Sequence " + thisSeq.getName() + " has no entry in other alignment, can't append alignment");
                }
                thisSeq.appendToSequence(otherSeq.getSequenceBases());
                thisSeq.setEnd(thisSeq.getEnd() + otherSeq.getUngappedLength());
            }
        }
    }

    public List<int[]> getUngappedReferenceIslands() {
        return this.getReference().findUngappedChunks();
    }

    public List<int[]> getUngappedSequenceReferenceIslands() {
        return this.getReference().findUngappedSequenceChunks();
    }

    public void introduceGaps(boolean canGapReference, int maxNumberOfGaps) throws IllegalAccessException {
        Random r = new Random();
        int alnLength = this.length();
        ArrayList<String> seqIds = new ArrayList<String>(this.getAlignedSequenceIds());
        if (!canGapReference) {
            seqIds.remove(this.getReferenceId());
        }
        for (int i = 0; i < alnLength; ++i) {
            ArrayList<String> availableSeqIds = new ArrayList<String>(seqIds);
            int numOfGaps = r.nextInt(maxNumberOfGaps);
            for (int j = 0; j < numOfGaps; ++j) {
                int toGapIdx = r.nextInt(availableSeqIds.size());
                String seqToGap = (String)availableSeqIds.remove(toGapIdx);
                Sequence seq = this.alignments.get(seqToGap);
                seq.setCharAt(i, '-');
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlignedSequence
    extends SequenceRegion {
        private static final Pattern GAP_PATTERN = Pattern.compile("-+");
        private static final Pattern UNGAP_PATTERN = Pattern.compile("[^-]+");
        private int totalLength;
        Stack<int[]> ungappedRegions;

        public AlignedSequence(Sequence sequence) {
            super(sequence.getId());
            this.setId(sequence.getId());
            this.setName(sequence.getId());
            this.setSequence(sequence);
            this.setRegionStart(0);
            this.setRegionEnd(this.getLength());
            this.setSequenceBases(this.getSequenceBases());
        }

        @Override
        public void setSequenceBases(String bases) {
            super.setSequenceBases(bases);
        }

        public AlignedSequence(String containingSequenceId) {
            super(containingSequenceId);
            this.setId(containingSequenceId);
        }

        @Override
        public int getLength() {
            if (this.getEncodedSequence() != null && this.getEncodedSequence().length > 0) {
                return this.getEncodedSequence().length;
            }
            if (this.getVectorEncodedSequence() != null) {
                return this.getVectorEncodedSequence().getColumnDimension();
            }
            if (this.getSequenceBases() != null && this.getSequenceBases().length() > 0) {
                return this.getSequenceBases().length();
            }
            return super.getLength();
        }

        public int getUngappedLength() {
            int ungappedLength = 0;
            char[] basesArr = this.getSequenceBases().toCharArray();
            int gaps = 0;
            for (int i = 0; i < basesArr.length; ++i) {
                if (basesArr[i] != '-') continue;
                ++gaps;
            }
            ungappedLength = this.getLength() - gaps;
            return ungappedLength;
        }

        public void setStrand(String strand) {
            super.setForwardStrand("-".equals(strand));
        }

        public float getPercentGaps() {
            return 1.0f - (float)this.getUngappedLength() / (float)this.getLength();
        }

        public int getTotalGaps() {
            return this.getLength() - this.getUngappedLength();
        }

        public List<Integer> getGapSizes() {
            Matcher m = GAP_PATTERN.matcher(this.getSequenceBases());
            ArrayList<Integer> gapSizes = new ArrayList<Integer>();
            while (m.find()) {
                m.start();
                m.end();
                gapSizes.add(m.group().length());
            }
            return gapSizes;
        }

        public List<int[]> findUngappedChunks() {
            Matcher m = UNGAP_PATTERN.matcher(this.getSequenceBases());
            ArrayList<int[]> gapUngapp = new ArrayList<int[]>();
            while (m.find()) {
                int[] ungappedReg = new int[]{m.start(), m.end()};
                gapUngapp.add(ungappedReg);
            }
            return gapUngapp;
        }

        public int getGapAdjustedCoordinate(int position) {
            int gapsBetweenChunks;
            int[] chunk;
            List<int[]> ungappedChunks = this.findUngappedChunks();
            Iterator<int[]> chunkIt = ungappedChunks.iterator();
            int gapNum = 0;
            int[] lastChunk = new int[]{0, 0};
            while (chunkIt.hasNext() && (chunk = chunkIt.next())[0] - gapNum - (gapsBetweenChunks = chunk[0] - lastChunk[1]) <= position) {
                gapNum += gapsBetweenChunks;
                lastChunk = chunk;
            }
            return position + gapNum;
        }

        public int getSequencePosition(int coordinate) {
            List<int[]> ungappedChunks = this.findUngappedChunks();
            Iterator<int[]> chunkIt = ungappedChunks.iterator();
            int gapNum = 0;
            int[] lastChunk = new int[]{0, 0};
            while (lastChunk[1] < coordinate && chunkIt.hasNext()) {
                int[] chunk = chunkIt.next();
                int gapsBetweenChunks = chunk[0] - Math.min(lastChunk[1], coordinate);
                if (chunk[0] <= coordinate) {
                    gapNum += gapsBetweenChunks;
                }
                lastChunk = chunk;
            }
            return coordinate - gapNum;
        }

        public int getTotalLength() {
            return this.totalLength;
        }

        public void setTotalLength(int totalLength) {
            this.totalLength = totalLength;
        }
    }
}

