/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.multiplealignment;

import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentIO;
import edu.mit.broad.prodinfo.sequence.FastaSequenceIO;
import edu.mit.broad.prodinfo.sequence.Sequence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastaMultipleAlignmentIO
implements MultipleAlignmentIO {
    @Override
    public MultipleAlignment load(String source) throws IOException {
        MultipleAlignment ma = new MultipleAlignment();
        FastaSequenceIO fsio = new FastaSequenceIO(new File(source));
        Iterator<Sequence> it = fsio.loadAll().iterator();
        while (it.hasNext()) {
            MultipleAlignment.AlignedSequence seq = new MultipleAlignment.AlignedSequence(it.next());
            ma.addSequence(seq);
        }
        return ma;
    }

    @Override
    public MultipleAlignment load(String source, List<String> sequencesToLoad) throws IOException {
        MultipleAlignment ma = new MultipleAlignment();
        FastaSequenceIO fsio = new FastaSequenceIO(new File(source));
        Iterator<Sequence> it = fsio.extractRecords(sequencesToLoad).iterator();
        while (it.hasNext()) {
            MultipleAlignment.AlignedSequence seq = new MultipleAlignment.AlignedSequence(it.next());
            ma.addSequence(seq);
        }
        return ma;
    }

    @Override
    public void write(BufferedWriter bw, MultipleAlignment ma) throws IOException {
        FastaSequenceIO fsio = new FastaSequenceIO();
        fsio.write(ma.getAlignedSequences(), bw);
    }

    @Override
    public void write(BufferedWriter bw, MultipleAlignment ma, List<String> orderOfSequences) throws IOException {
        FastaSequenceIO fsio = new FastaSequenceIO();
        if (orderOfSequences != null && orderOfSequences.size() > 0) {
            for (String seqId : orderOfSequences) {
                fsio.write((Sequence)ma.getAlignedSequence(seqId), bw);
            }
        } else {
            fsio.write(ma.getAlignedSequences(), bw);
        }
    }

    @Override
    public MultipleAlignment load(InputStream in) throws IOException {
        MultipleAlignment ma = new MultipleAlignment();
        FastaSequenceIO fsio = new FastaSequenceIO();
        Iterator<Sequence> it = fsio.loadAll(in).iterator();
        while (it.hasNext()) {
            MultipleAlignment.AlignedSequence seq = new MultipleAlignment.AlignedSequence(it.next());
            ma.addSequence(seq);
        }
        return ma;
    }

    @Override
    public MultipleAlignment load(InputStream in, List<String> sequencesToLoad) throws IOException {
        MultipleAlignment ma = new MultipleAlignment();
        FastaSequenceIO fsio = new FastaSequenceIO();
        Iterator<Sequence> it = fsio.extractRecords(sequencesToLoad, in).iterator();
        while (it.hasNext()) {
            MultipleAlignment.AlignedSequence seq = new MultipleAlignment.AlignedSequence(it.next());
            ma.addSequence(seq);
        }
        return ma;
    }

    @Override
    public String getPreferredFileExtension() {
        return "fa";
    }
}

