/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.multiplealignment;

import edu.mit.broad.prodinfo.annotation.GFF;
import edu.mit.broad.prodinfo.annotation.GFFReader;
import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentFactory;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentIO;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentIOFactory;
import edu.mit.broad.prodinfo.util.CLUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class AlignmentExtractor {
    public static ArrayList<String> degenerateCodonStarts;
    public static ArrayList<String> twoFoldDegenerateCodons;
    public static ArrayList<String> threeFoldDegenerateCodons;
    public static ArrayList<String> nonDegenerateCodons;
    public static HashMap<String, String> codonToAminoacid;
    public static String USAGE;

    public static void main(String[] args) throws IOException, IllegalAccessException, ParseException {
        CLUtil.ArgumentMap argMap = CLUtil.getParameters(args, USAGE);
        if ("1".equals(argMap.getTask())) {
            String alignmentFile = argMap.getInput();
            String outputFile = argMap.getOutput();
            String gff = argMap.getMandatory("ANNOTGFF");
            String inFormat = argMap.containsKey("INFORMAT") ? argMap.get("INFORMAT") : "FASTA";
            String outFormat = argMap.containsKey("OUTFORMAT") ? argMap.get("OUTFORMAT") : "FASTA";
            String[] sequences = argMap.getMandatory("SEQS").split(",");
            AlignmentExtractor.extractGFFRegions(alignmentFile, outputFile, gff, inFormat, outFormat, sequences);
        } else if ("2".equals(argMap.getTask())) {
            String exonMultialignment = argMap.getInput();
            String output = argMap.getOutput();
            String reference = argMap.getMandatory("REF");
            String inFormat = argMap.containsKey("INFORMAT") ? argMap.get("INFORMAT") : "FASTA";
            String outFormat = argMap.containsKey("OUTFORMAT") ? argMap.get("OUTFORMAT") : "FASTA";
            String[] sequences = argMap.getMandatory("OTHERSEQS").split(",");
            AlignmentExtractor.extractAFourFoldDegenerateBases(exonMultialignment, output, reference, sequences, inFormat, outFormat);
        } else if ("3".equals(argMap.getTask())) {
            String exonMultialignment = argMap.getInput();
            String output = argMap.getOutput();
            String reference = argMap.getMandatory("REF");
            String inFormat = argMap.containsKey("INFORMAT") ? argMap.get("INFORMAT") : "FASTA";
            String outFormat = argMap.containsKey("OUTFORMAT") ? argMap.get("OUTFORMAT") : "FASTA";
            String[] sequences = argMap.getMandatory("OTHERSEQS").split(",");
            AlignmentExtractor.extractConservedBases(exonMultialignment, output, reference, sequences, inFormat, outFormat);
        } else if ("4".equals(argMap.getTask())) {
            String[] startEnd = argMap.getMandatory("REGION").split("\\.\\.");
            int start = Integer.parseInt(startEnd[0]);
            int end = Integer.parseInt(startEnd[1]);
            String multiAlignment = argMap.getInput();
            String output = argMap.getOutput();
            String reference = argMap.getMandatory("REF");
            String inFormat = argMap.containsKey("INFORMAT") ? argMap.get("INFORMAT") : "FASTA";
            String outFormat = argMap.containsKey("OUTFORMAT") ? argMap.get("OUTFORMAT") : "FASTA";
            AlignmentExtractor.extractSubAlignment(multiAlignment, output, reference, start, end, inFormat, outFormat);
        } else if ("5".equals(argMap.getTask())) {
            String inFormat = argMap.containsKey("INFORMAT") ? argMap.get("INFORMAT") : "FASTA";
            String outFormat = argMap.containsKey("OUTFORMAT") ? argMap.get("OUTFORMAT") : "PHYLIP";
            InputStream is = argMap.getInputStream();
            MultipleAlignment ma = MultipleAlignmentFactory.create(is, inFormat);
            is.close();
            if (argMap.containsKey("compress")) {
                if (argMap.containsKey("ref")) {
                    ma.setReferenceId(argMap.get("ref"));
                }
                ma.compress();
            }
            BufferedWriter bw = argMap.getOutputWriter();
            ma.setIOHelper(MultipleAlignmentIOFactory.create(outFormat));
            ma.write(bw);
            bw.close();
        } else if ("6".equals(argMap.getTask())) {
            String inFormat = argMap.containsKey("informat") ? argMap.get("informat") : "FASTA";
            String outFormat = argMap.containsKey("outformat") ? argMap.get("outformat") : "PHYLIP";
            String reference = argMap.get("ref");
            int maxGaps = argMap.getInteger("maxGaps");
            InputStream is = argMap.getInputStream();
            MultipleAlignment ma = MultipleAlignmentFactory.create(is, inFormat);
            is.close();
            ma.setIOHelper(MultipleAlignmentIOFactory.create(outFormat));
            if (reference != null) {
                ma.setReferenceId(reference);
            }
            ma.introduceGaps(reference == null, maxGaps);
            BufferedWriter bw = argMap.getOutputWriter();
            ma.write(bw);
            bw.close();
        } else if ("7".equals(argMap.getTask())) {
            String inFormat = argMap.containsKey("informat") ? argMap.get("informat") : "FASTA";
            String outFormat = argMap.containsKey("outformat") ? argMap.get("outformat") : "FASTA";
            InputStream is = argMap.getInputStream();
            MultipleAlignment ma = MultipleAlignmentFactory.create(is, inFormat);
            is.close();
            ma.setIOHelper(MultipleAlignmentIOFactory.create(outFormat));
            ma.permuteColumns();
            BufferedWriter bw = argMap.getOutputWriter();
            ma.write(bw);
            bw.close();
        } else if ("8".equals(argMap.getTask())) {
            String inFormat = argMap.containsKey("informat") ? argMap.get("informat") : "FASTA";
            String outFormat = argMap.containsKey("outformat") ? argMap.get("outformat") : "FASTA";
            int cols = argMap.getInteger("cols");
            int numOfConsecutiveCols = argMap.containsKey("consecutiveCols") ? argMap.getInteger("consecutiveCols") : 1;
            InputStream is = argMap.getInputStream();
            MultipleAlignment ma = MultipleAlignmentFactory.create(is, inFormat);
            is.close();
            MultipleAlignment sampledMA = ma.sampleColumns(cols, numOfConsecutiveCols);
            sampledMA.setIOHelper(MultipleAlignmentIOFactory.create(outFormat));
            BufferedWriter bw = argMap.getOutputWriter();
            sampledMA.write(bw);
            bw.close();
        } else if ("9".equals(argMap.getTask())) {
            String inFormat = argMap.containsKey("informat") ? argMap.get("informat") : "FASTA";
            String outFormat = argMap.containsKey("outformat") ? argMap.get("outformat") : "FASTA";
            int numOfConsecutiveCols = argMap.containsKey("consecutiveCols") ? argMap.getInteger("consecutiveCols") : 1;
            MultipleAlignment combinedAln = new MultipleAlignment();
            BufferedReader br = argMap.getInputReader();
            String line = null;
            while ((line = br.readLine()) != null) {
                MultipleAlignment ma;
                line.trim();
                if (line.startsWith("#") || line.length() <= 0 || (ma = MultipleAlignmentFactory.create(line, inFormat)).isEmpty()) continue;
                combinedAln.append(ma);
            }
            br.close();
            if (argMap.containsKey("maxColumns")) {
                int maxColumns = argMap.getInteger("maxColumns");
                if (combinedAln.length() > maxColumns) {
                    MultipleAlignment sampled;
                    combinedAln = sampled = combinedAln.sampleColumns(maxColumns, numOfConsecutiveCols);
                }
            }
            BufferedWriter bw = argMap.getOutputWriter();
            combinedAln.setIOHelper(MultipleAlignmentIOFactory.create(outFormat));
            combinedAln.write(bw);
            bw.close();
        } else {
            System.err.println(USAGE);
        }
    }

    private static void addDegenerateCodons(String aminoacid, String firstTwoPositions) {
        codonToAminoacid.put(firstTwoPositions + "A", aminoacid);
        codonToAminoacid.put(firstTwoPositions + "C", aminoacid);
        codonToAminoacid.put(firstTwoPositions + "G", aminoacid);
        codonToAminoacid.put(firstTwoPositions + "T", aminoacid);
    }

    private static void extractSubAlignment(String multiAlignment, String output, String reference, int start, int end, String inFormat, String outFormat) throws IOException, ParseException {
        MultipleAlignment source = MultipleAlignmentFactory.create(multiAlignment, inFormat);
        MultipleAlignment subAln = source.getSubAlignment(reference, start, end, false);
        subAln.setIOHelper(MultipleAlignmentIOFactory.create(outFormat));
        BufferedWriter bw = new BufferedWriter(new FileWriter(output));
        subAln.write(bw);
        bw.close();
    }

    private static void extractAFourFoldDegenerateBases(String exonMultialignment, String output, String reference, String[] seqIds, String inFormat, String outFormat) throws IOException, ParseException {
        MultipleAlignment ma = MultipleAlignmentFactory.create(exonMultialignment, inFormat);
        MultipleAlignment fourDAln = MultipleAlignmentFactory.create(outFormat);
        fourDAln.setReferenceId(reference);
        MultipleAlignment.AlignedSequence ref4D = new MultipleAlignment.AlignedSequence(reference);
        ref4D.setName(reference);
        fourDAln.addSequence(ref4D);
        String ref = ma.getAlignedSequence(reference).getSequenceBases();
        String[] nonRefSeqs = new String[seqIds.length];
        MultipleAlignment.AlignedSequence[] nonRef4Ds = new MultipleAlignment.AlignedSequence[seqIds.length];
        for (int i = 0; i < seqIds.length; ++i) {
            nonRefSeqs[i] = ma.getAlignedSequence(seqIds[i]).getSequenceBases();
            nonRef4Ds[i] = new MultipleAlignment.AlignedSequence(seqIds[i]);
            nonRef4Ds[i].setName(seqIds[i]);
            fourDAln.addSequence(nonRef4Ds[i]);
        }
        int codon = 0;
        int pos = 0;
        while (pos < ref.length() - 3) {
            String refCodon = ref.substring(pos, pos + 3);
            if (degenerateCodonStarts.contains(refCodon.substring(0, 2))) {
                ref4D.appendToSequence(refCodon.charAt(2));
                for (int i = 0; i < nonRefSeqs.length; ++i) {
                    nonRef4Ds[i].appendToSequence(nonRefSeqs[i].charAt(pos + 2));
                }
            }
            pos = ++codon * 3;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(output));
        fourDAln.write(bw);
        bw.close();
    }

    private static void extractConservedBases(String exonMultialignment, String output, String reference, String[] seqIds, String inFormat, String outFormat) throws IOException, ParseException {
        MultipleAlignment ma = MultipleAlignmentFactory.create(exonMultialignment, inFormat);
        MultipleAlignment consAln = MultipleAlignmentFactory.create(outFormat);
        consAln.setReferenceId(reference);
        MultipleAlignment.AlignedSequence refCons = new MultipleAlignment.AlignedSequence(reference);
        refCons.setName(reference);
        consAln.addSequence(refCons);
        String ref = ma.getAlignedSequence(reference).getSequenceBases();
        String[] nonRefSeqs = new String[seqIds.length];
        MultipleAlignment.AlignedSequence[] nonRefCons = new MultipleAlignment.AlignedSequence[seqIds.length];
        for (int i = 0; i < seqIds.length; ++i) {
            nonRefSeqs[i] = ma.getAlignedSequence(seqIds[i]).getSequenceBases();
            nonRefCons[i] = new MultipleAlignment.AlignedSequence(seqIds[i]);
            nonRefCons[i].setName(seqIds[i]);
            consAln.addSequence(nonRefCons[i]);
        }
        int codon = 0;
        int pos = 0;
        while (pos < ref.length() - 3) {
            String refCodon = ref.substring(pos, pos + 3);
            refCons.appendToSequence(refCodon.substring(0, 2));
            for (int i = 0; i < nonRefSeqs.length; ++i) {
                nonRefCons[i].appendToSequence(nonRefSeqs[i].substring(pos, pos + 2));
            }
            pos = ++codon * 3;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(output));
        consAln.write(bw);
        bw.close();
    }

    public static void extractGFFRegions(String alignmentFile, String outputFile, String gff, String inFormat, String outFormat, String[] seqs) throws IOException, ParseException {
        GFFReader gffR;
        Map seqGFFMap;
        Stack<GeneAlignmentAnalysis> problemGenes = new Stack<GeneAlignmentAnalysis>();
        MultipleAlignment ma = MultipleAlignmentFactory.create(alignmentFile, inFormat);
        if (!inFormat.equals(outFormat)) {
            MultipleAlignmentIO maio = MultipleAlignmentIOFactory.create(outFormat);
            ma.setIOHelper(maio);
        }
        if ((seqGFFMap = (gffR = new GFFReader(gff)).getSequenceAnnotationMap()).keySet().size() != 1) {
            throw new IllegalStateException("The loaded GFF file contains annotation for more than one sequence: " + seqGFFMap.keySet());
        }
        String refId = seqGFFMap.keySet().iterator().next();
        Iterator annotationIt = seqGFFMap.get(refId).iterator();
        if (!annotationIt.hasNext()) {
            throw new RuntimeException("The GFF list loaded from " + gff + " was empty");
        }
        GFF annotation = (GFF)annotationIt.next();
        MultipleAlignment subAlignment = ma.getSubAlignment(refId, annotation.getStart(), annotation.getEnd(), annotation.inReversedOrientation());
        GeneAlignmentAnalysis firstAnalysis = new GeneAlignmentAnalysis(annotation.getFirstValue("refSeqId"));
        firstAnalysis.addExonAlignment(ma, Integer.valueOf(annotation.getFirstValue("ExonNum")));
        problemGenes.push(firstAnalysis);
        MultipleAlignment tmpAlignment = null;
        while (annotationIt.hasNext()) {
            annotation = (GFF)annotationIt.next();
            String geneId = annotation.getFirstValue("refSeqId");
            int exonNumber = Integer.parseInt(annotation.getFirstValue("ExonNum"));
            tmpAlignment = ma.getSubAlignment(refId, annotation.getStart(), annotation.getEnd(), annotation.inReversedOrientation());
            subAlignment.append(tmpAlignment);
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
        subAlignment.write(bw);
        bw.close();
    }

    static {
        USAGE = "Usage: AlignmentExtractor TASK=<task_num> <task_args>\n\tTasks:\n\t\t1. Extract Regions: IN=<Multiple alignment file> OUT=<output file> ANNOTGFF=<GFF annotation file, sequence name should match one of the aligned sequence IDs> INFORMAT=<[FASTA]/EXON/PHYLIP/SEQPHYLIP> OUTFORMAT<[FASTA]/EXON/PHYLIP> SEQS=<comma separated list of sequence ids>\n\t\t2. Extract 4D sites from exon alignment: IN=<Exon multiple alignment> OUT=<output file> INFORMAT=<input format (default FASTA)> OUTFORMAT=<output format (default FASTA)>\n \t\t3. Extract Conserved sites from exon alignment: IN=<Exon multiple alignment> OUT=<output alignment file> INFORMAT=<input format (default FASTA)> OUTFORMAT=<output format (default FASTA)>\n\t\t4. Extract region IN=<Multiple alignment file> OUT=<output file> REGION=<start..end> REF=<reference> INFORMAT=<[FASTA]/EXON/PHYLIP> OUTFORMAT<[FASTA]/EXON/PHYLIP/SEQPHYLIP> \n\t\t5. Convert alignment file IN=<Multiple Alignment File> OUT=<output file> INFORMAT=<[FASTA]/EXON/PHYLIP> OUTFORMAT<FASTA/EXON/[PHYLIP]/SEQPHYLIP> [-compress <if the output alignment should be reference gap free>] \n\t\t6. Introduce Random Gaps -in <Multiple Alignment File default is standard input> -out <output gapped alignment defalut is standard out> -informat <[FASTA]/EXON/PHYLIP> -outformat <FASTA/EXON/[PHYLIP]/SEQPHYLIP> -maxGaps <maximum number of gaps> [-ref <reference if no gaps should be introduced in reference>]\n\t\t7. Permute Columns -in <Multiple Alignment File default is standard input> -out <output gapped alignment defalut is standard out> -informat <[FASTA]/EXON/PHYLIP> -outformat <FASTA/EXON/[PHYLIP]/SEQPHYLIP> \n\t8. Sample Columns from Alignment -in <Multiple Alignment File default is standard input> -out <output gapped alignment defalut is standard out> -informat <[FASTA]/EXON/PHYLIP> -outformat <[FASTA]/EXON/PHYLIP/SEQPHYLIP> -cols <Number of columns to sample> [-consecutiveCols <Sample consecutive columns rather than single ones>]\n\t9. Combined alignments -informat <[FASTA], PHYLIP, SEQPHYLIP> -outformat <[FASTA], PHYLIP, SEQPHYLIP> -in <Standard input of file with a list of alignment files> -out <standard output or file name> [-maxColumns <If specified, and the combined alignment is larger than this value, a sampled alignmnet will be generated instead of the combined one>]\n";
        codonToAminoacid = new HashMap();
        degenerateCodonStarts = new ArrayList(8);
        degenerateCodonStarts.add("CT");
        degenerateCodonStarts.add("GT");
        degenerateCodonStarts.add("TC");
        degenerateCodonStarts.add("CC");
        degenerateCodonStarts.add("AC");
        degenerateCodonStarts.add("GC");
        degenerateCodonStarts.add("CG");
        degenerateCodonStarts.add("GG");
        AlignmentExtractor.addDegenerateCodons("Leu", "CT");
        AlignmentExtractor.addDegenerateCodons("Val", "GT");
        AlignmentExtractor.addDegenerateCodons("Ser", "TC");
        AlignmentExtractor.addDegenerateCodons("Pro", "CC");
        AlignmentExtractor.addDegenerateCodons("Thr", "AC");
        AlignmentExtractor.addDegenerateCodons("Ala", "GC");
        AlignmentExtractor.addDegenerateCodons("Arg", "CG");
        AlignmentExtractor.addDegenerateCodons("Gly", "GG");
        twoFoldDegenerateCodons = new ArrayList(18);
        twoFoldDegenerateCodons.add("TAT");
        codonToAminoacid.put("TAT", "Tyr");
        twoFoldDegenerateCodons.add("TAC");
        codonToAminoacid.put("TAC", "Tyr");
        twoFoldDegenerateCodons.add("GAT");
        codonToAminoacid.put("GAT", "Asp");
        twoFoldDegenerateCodons.add("GAC");
        codonToAminoacid.put("GAC", "Asp");
        twoFoldDegenerateCodons.add("GAA");
        codonToAminoacid.put("GAA", "Glu");
        twoFoldDegenerateCodons.add("GAG");
        codonToAminoacid.put("GAG", "Glu");
        twoFoldDegenerateCodons.add("TTT");
        codonToAminoacid.put("TTT", "Phe");
        twoFoldDegenerateCodons.add("TTC");
        codonToAminoacid.put("TTC", "Phe");
        twoFoldDegenerateCodons.add("TGT");
        codonToAminoacid.put("TGT", "Cys");
        twoFoldDegenerateCodons.add("TGC");
        codonToAminoacid.put("TGC", "Cys");
        twoFoldDegenerateCodons.add("CAT");
        codonToAminoacid.put("CAT", "His");
        twoFoldDegenerateCodons.add("CAC");
        codonToAminoacid.put("CAC", "His");
        twoFoldDegenerateCodons.add("CAA");
        codonToAminoacid.put("CAA", "Gln");
        twoFoldDegenerateCodons.add("CAG");
        codonToAminoacid.put("CAG", "Gln");
        twoFoldDegenerateCodons.add("AAT");
        codonToAminoacid.put("AAT", "Lys");
        twoFoldDegenerateCodons.add("AAC");
        codonToAminoacid.put("AAC", "Lys");
        twoFoldDegenerateCodons.add("AAG");
        codonToAminoacid.put("AAG", "Asn");
        twoFoldDegenerateCodons.add("AAA");
        codonToAminoacid.put("AAA", "Asn");
        twoFoldDegenerateCodons.add("AGT");
        codonToAminoacid.put("AGT", "Ser");
        twoFoldDegenerateCodons.add("AGC");
        codonToAminoacid.put("AGC", "Ser");
        threeFoldDegenerateCodons = new ArrayList(3);
        threeFoldDegenerateCodons.add("ATT");
        threeFoldDegenerateCodons.add("ATC");
        threeFoldDegenerateCodons.add("ATA");
        codonToAminoacid.put("ATT", "Ile");
        codonToAminoacid.put("ATC", "Ile");
        codonToAminoacid.put("ATA", "Ile");
        nonDegenerateCodons = new ArrayList(2);
        nonDegenerateCodons.add("ATG");
        codonToAminoacid.put("ATG", "Met");
        nonDegenerateCodons.add("TGG");
        codonToAminoacid.put("TGG", "Trp");
    }

    private static class GeneAlignmentAnalysis {
        private String geneId;
        private HashMap<String, List<Integer>> speciesGappedExons;
        private HashMap<String, Integer> speciesFirstMissenseExons;

        public GeneAlignmentAnalysis(String geneId) {
            this.geneId = geneId;
            this.speciesGappedExons = new HashMap();
            this.speciesFirstMissenseExons = new HashMap();
        }

        public boolean hasIssues() {
            return !this.speciesGappedExons.isEmpty() || !this.speciesFirstMissenseExons.isEmpty();
        }

        public boolean hasMissenseExons() {
            return !this.speciesFirstMissenseExons.isEmpty();
        }

        public String getGeneId() {
            return this.geneId;
        }

        public void addExonAlignment(MultipleAlignment ma, int exonNumber) {
            for (String id : ma.getAlignedSequenceIds()) {
                MultipleAlignment.AlignedSequence seq = ma.getAlignedSequence(id);
                float percentGaps = seq.getPercentGaps();
                if ((double)percentGaps > 0.5) {
                    List<Integer> gappedExons = this.speciesGappedExons.get(id);
                    if (gappedExons == null) {
                        gappedExons = new ArrayList<Integer>();
                    }
                    gappedExons.add(exonNumber);
                    continue;
                }
                List<Integer> gapSizes = seq.getGapSizes();
                if (this.speciesFirstMissenseExons.containsKey(id) || gapSizes.isEmpty() || gapSizes.size() <= 1 && seq.getSequenceBases().endsWith("-")) continue;
                int totalGaps = 0;
                for (int i = 0; i < gapSizes.size(); ++i) {
                    totalGaps = gapSizes.get(i);
                }
                if (totalGaps % 3 <= 0) continue;
                this.speciesFirstMissenseExons.put(id, exonNumber);
            }
        }

        public void write(BufferedWriter bw, String[] seqIds) throws IOException {
            bw.write(this.geneId);
            bw.write("\t");
            for (int j = 0; j < seqIds.length; ++j) {
                String id = seqIds[j];
                if (this.speciesGappedExons.containsKey(id)) {
                    List<Integer> unalignedExons = this.speciesGappedExons.get(id);
                    for (int i = 0; i < unalignedExons.size(); ++i) {
                        bw.write(String.valueOf(unalignedExons.get(i)));
                        if (i >= unalignedExons.size() - 1) continue;
                        bw.write(",");
                    }
                } else {
                    bw.write("0");
                }
                bw.write("\t");
                if (!this.speciesFirstMissenseExons.containsKey(id)) continue;
                if (this.speciesFirstMissenseExons.containsKey(id)) {
                    bw.write(String.valueOf(this.speciesFirstMissenseExons.get(id)));
                    continue;
                }
                bw.write(0);
            }
        }
    }
}

