/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.datastrutures;

import edu.mit.broad.prodinfo.datastrutures.IllegalTreeOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRootedTree<T> {
    private String name;
    private TreeNode<T> root;
    private ArrayList<ArrayList<TreeNode<T>>> levels = new ArrayList();

    public GenericRootedTree(String name, T rootElement) {
        try {
            this.root = new TreeNode<T>(this, rootElement);
        }
        catch (IllegalTreeOperationException e) {
            e.printStackTrace();
        }
        this.name = name;
    }

    public TreeNode<T> getRoot() {
        return this.root;
    }

    public String getName() {
        return this.name;
    }

    private void addNodeToLevel(int level, TreeNode<T> node) throws IllegalTreeOperationException {
        if (level > this.levels.size()) {
            throw new IllegalTreeOperationException("Trying to add a level that is more than one level deeper than any existing  level ");
        }
        if (level == this.levels.size()) {
            ArrayList levelList = new ArrayList();
            this.levels.add(levelList);
        }
        ArrayList<TreeNode<T>> levelNodeList = this.levels.get(level);
        levelNodeList.add(level, node);
    }

    public List<TreeNode<T>> getNodes(int level) {
        return this.levels.get(level);
    }

    public List<TreeNode<T>> getLeaves() {
        return this.getNodes(this.levels.size() - 1);
    }

    public List<T> getNodeElements(int level) {
        List<TreeNode<T>> nodes = this.getNodes(level);
        ArrayList<T> elements = new ArrayList<T>(nodes.size());
        Iterator<TreeNode<T>> it = nodes.iterator();
        while (it.hasNext()) {
            elements.add(it.next().getElement());
        }
        return elements;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeNode<T> {
        private GenericRootedTree<T> tree;
        private TreeNode<T> parent;
        private ArrayList<TreeNode<T>> children;
        private T nodeElement;
        private int level;

        public TreeNode(GenericRootedTree<T> tree, T element) throws IllegalTreeOperationException {
            this.nodeElement = element;
            this.level = 0;
            this.children = new ArrayList();
            ((GenericRootedTree)tree).addNodeToLevel(this.level, this);
        }

        public TreeNode(GenericRootedTree<T> tree, T element, TreeNode<T> parent) throws IllegalTreeOperationException {
            this.nodeElement = element;
            this.parent = parent;
            this.level = parent.getLevel() + 1;
            this.children = new ArrayList();
            ((GenericRootedTree)tree).addNodeToLevel(this.level, this);
        }

        public int getLevel() {
            return this.level;
        }

        protected void setLevel(int level) {
            this.level = level;
        }

        public void setParent(TreeNode<T> parent) {
            this.parent = parent;
            parent.addChild(this);
            this.level = parent.getLevel() + 1;
            for (TreeNode<T> child : this.children) {
                child.setParent(this);
            }
        }

        public void addChild(TreeNode<T> child) {
            this.children.add(child);
        }

        public T getElement() {
            return this.nodeElement;
        }

        public TreeNode<T> getParent() {
            return this.parent;
        }
    }
}

