/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.chromosome;

import edu.mit.broad.prodinfo.sequence.FastaSequenceIO;
import edu.mit.broad.prodinfo.sequence.Sequence;
import edu.mit.broad.prodinfo.sequence.SequenceRegion;
import java.io.File;
import java.io.IOException;

public class Genome {
    public void expandFromMultiFasta(String dir, String multifasta, String multiAGP) throws IOException {
        FastaSequenceIO fsio = new FastaSequenceIO(multifasta);
        File xDir = new File(dir + "X");
        if (!xDir.exists()) {
            xDir.mkdir();
        }
        SequenceRegion sr = new SequenceRegion("chrX");
        sr = new SequenceRegion("chrY");
        sr.setRegionStart(1);
        sr.setRegionEnd(500000000);
        fsio.extractRegion(sr);
        sr.setId("chrY");
        File yDir = new File(dir + "Y");
        if (!yDir.exists()) {
            yDir.mkdir();
        }
        fsio.write((Sequence)sr, yDir.getAbsolutePath() + "/chrY.fa");
        boolean goOn = true;
        int chr = 1;
        File chrDir = null;
        while (goOn) {
            sr = new SequenceRegion("chr" + chr);
            sr.setRegionStart(1);
            sr.setRegionEnd(500000000);
            fsio.extractRegion(sr);
            sr.setId("chr" + chr);
            if (sr.getSequenceBases() != null) {
                chrDir = new File(dir + chr);
                if (!chrDir.exists()) {
                    chrDir.mkdir();
                }
                fsio.write((Sequence)sr, chrDir.getAbsolutePath() + "/chr" + chr + ".fa");
            } else {
                goOn = false;
            }
            ++chr;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Ussage: Genome <dir to expand> <chromosome multifasta file> <multi AGP file>");
        }
        Genome g = new Genome();
        g.expandFromMultiFasta(args[0], args[1], args[2]);
    }
}

