/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.chromosome;

import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.TwoSubjectAnnotation;
import edu.mit.broad.prodinfo.sequence.Sequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGenomicAnnotation
implements GenomicAnnotation {
    private int start;
    private int end;
    private String name;
    private String orientation;
    private String chromosome;
    private Sequence sequence;
    private int fivePrimerBuffer;
    private int threePrimerBuffer;
    private String id;
    private double score;
    int lastBreakInIndex = 0;

    protected BasicGenomicAnnotation() {
    }

    public BasicGenomicAnnotation(String name) {
        this.name = name;
    }

    public BasicGenomicAnnotation(String name, String chr, int start, int end) {
        this(name);
        this.setChromosome(chr);
        this.setStart(start);
        this.setEnd(end);
    }

    public BasicGenomicAnnotation(GenomicAnnotation ga) {
        this.start = ga.getStart();
        this.end = ga.getEnd();
        this.name = ga.getName();
        this.orientation = ga.getOrientation();
        this.score = ga.getScore();
        this.chromosome = ga.getChromosome() != null ? ga.getChromosome().intern() : null;
        this.sequence = ga.getSequence();
        this.fivePrimerBuffer = ga.getFivePrimeBases();
        this.threePrimerBuffer = ga.getThreePrimeBases();
        this.id = ga.getId();
    }

    public BasicGenomicAnnotation(String[] info) {
        if (info[0].contains(":")) {
            String[] firstSplit = info[0].split(":");
            this.setChromosome(firstSplit[0]);
            String[] secondSplit = firstSplit[1].split("-");
            this.setStart(Integer.parseInt(secondSplit[0]));
            this.setEnd(Integer.parseInt(secondSplit[1]));
        } else {
            this.setChromosome(info[0].substring(3));
            this.setStart(Integer.parseInt(info[1]));
            this.setEnd(Integer.parseInt(info[2]));
            if (info.length > 3) {
                this.setId(info[3]);
                this.setName(info[3]);
            } else {
                this.setName(info[0] + "_" + info[1] + "-" + info[2]);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        BasicGenomicAnnotation other = (BasicGenomicAnnotation)o;
        if (this.chromosome != null && !this.chromosome.equals(other.getChromosome())) {
            return false;
        }
        if (this.name != null && !this.name.equals(other.getName())) {
            return false;
        }
        return this.start == other.getStart() && this.end == other.getEnd();
    }

    public int hashCode() {
        int hash = 0;
        if (this.chromosome != null) {
            char[] chrChars = this.chromosome.toCharArray();
            for (int i = 0; i < chrChars.length; ++i) {
                hash += chrChars[i];
            }
            hash <<= 31;
        }
        if (this.name != null) {
            hash += this.name.hashCode() << 30;
        }
        return hash += (this.start + this.end) / 2;
    }

    @Override
    public long getMiddle() {
        return Math.round((float)(this.getStart() + this.getEnd()) / 2.0f);
    }

    @Override
    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public String toString() {
        return this.getLocationString();
    }

    @Override
    public String getChromosomeString() {
        if (this.getChromosome() == null) {
            return null;
        }
        String str = "";
        if (this.getChromosome().length() < 3) {
            str = "chr";
        }
        return str + this.getChromosome();
    }

    @Override
    public String getLocationString() {
        return this.getChromosomeString() + ":" + this.getStart() + "-" + this.getEnd();
    }

    protected void setStart(String data) {
        this.start = Integer.parseInt(data);
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    protected void setEnd(String data) {
        this.end = Integer.parseInt(data);
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    public void setBoundariesFromAnnoations(List<? extends GenomicAnnotation> annotations) {
        for (GenomicAnnotation genomicAnnotation : annotations) {
            this.start = this.start > 0 ? Math.min(this.start, genomicAnnotation.getStart()) : genomicAnnotation.getStart();
            this.end = Math.max(this.end, genomicAnnotation.getEnd());
        }
    }

    @Override
    public void takeIntersection(GenomicAnnotation other) {
        if (this.getStart() < other.getEnd() && this.getEnd() > other.getStart()) {
            this.setStart(Math.max(this.getStart(), other.getStart()));
            this.setEnd(Math.min(this.getEnd(), other.getEnd()));
        }
    }

    @Override
    public int getDistanceTo(GenomicAnnotation other) {
        int dist = 0;
        if (!this.getChromosome().equals(other.getChromosome())) {
            dist = 1000000000;
        } else if (!this.overlaps(other)) {
            dist = this.getStart() > other.getEnd() ? this.getStart() - other.getEnd() : other.getStart() - this.getEnd();
        }
        return dist;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id.intern();
    }

    @Override
    public void takeUnion(GenomicAnnotation other) {
        if (this.overlaps(other)) {
            this.setStart(Math.min(this.getStart(), other.getStart()));
            this.setEnd(Math.max(this.getEnd(), other.getEnd()));
        }
    }

    public void reduceToDifference(GenomicAnnotation other) {
        if (this.overlaps(other)) {
            if (this.getStart() < other.getStart()) {
                this.setEnd(Math.min(this.getEnd(), other.getStart() - 1));
            } else {
                this.setStart(Math.max(this.getStart(), other.getEnd() + 1));
            }
        }
    }

    @Override
    public List<GenomicAnnotation> disect(GenomicAnnotation a) {
        ArrayList<GenomicAnnotation> disection = new ArrayList<GenomicAnnotation>();
        if (this.overlaps(a)) {
            disection.addAll(this.minus(a));
            BasicGenomicAnnotation copy = new BasicGenomicAnnotation(this);
            copy.takeIntersection(a);
            disection.add(copy);
            Collections.sort(disection);
        }
        return disection;
    }

    @Override
    public List<GenomicAnnotation> disect(List<? extends GenomicAnnotation> disectors) {
        ArrayList<GenomicAnnotation> disection = new ArrayList<GenomicAnnotation>();
        disection.add(this);
        for (GenomicAnnotation genomicAnnotation : disectors) {
            if (genomicAnnotation.getStart() > this.getEnd()) break;
            if (!this.overlaps(genomicAnnotation)) continue;
            ArrayList<GenomicAnnotation> newDisection = new ArrayList<GenomicAnnotation>(disection.size());
            for (GenomicAnnotation disectionComponent : disection) {
                if (disectionComponent.overlaps(genomicAnnotation)) {
                    newDisection.addAll(disectionComponent.disect(genomicAnnotation));
                    continue;
                }
                newDisection.add(disectionComponent);
            }
            disection = newDisection;
        }
        return disection;
    }

    @Override
    public void stitchTo(GenomicAnnotation other) {
        this.setStart(Math.min(this.getStart(), other.getStart()));
        this.setEnd(Math.max(this.getEnd(), other.getEnd()));
    }

    @Override
    public boolean isFlankedBy(TwoSubjectAnnotation twoSubjectAnnotation, int buffer) {
        BasicGenomicAnnotation left = new BasicGenomicAnnotation("left");
        left.setStart(this.getStart() - buffer);
        left.setEnd(this.getStart() + buffer);
        BasicGenomicAnnotation right = new BasicGenomicAnnotation("right");
        right.setStart(this.getEnd() - buffer);
        right.setEnd(this.getEnd() + buffer);
        BasicGenomicAnnotation A = new BasicGenomicAnnotation("A");
        A.setStart(twoSubjectAnnotation.getAStart());
        A.setEnd(twoSubjectAnnotation.getAEnd());
        BasicGenomicAnnotation B = new BasicGenomicAnnotation("B");
        B.setStart(twoSubjectAnnotation.getBStart());
        B.setEnd(twoSubjectAnnotation.getBEnd());
        return A.overlaps(left) && B.overlaps(right) || A.overlaps(right) && B.overlaps(left);
    }

    public List<GenomicAnnotation> minus(List<? extends GenomicAnnotation> others, boolean listIsDisjoint, int startAtIdx) {
        GenomicAnnotation a;
        ArrayList<GenomicAnnotation> dif = new ArrayList<GenomicAnnotation>();
        dif.add(this);
        Collections.sort(others);
        Iterator<? extends GenomicAnnotation> it = null;
        if (!listIsDisjoint) {
            List<? extends GenomicAnnotation> stitchedOthers = BasicGenomicAnnotation.stitchList(others, 0);
            it = stitchedOthers.iterator();
        } else {
            it = others.listIterator(startAtIdx);
        }
        this.lastBreakInIndex = startAtIdx;
        while (it.hasNext() && (a = it.next()).getStart() <= this.getEnd()) {
            ++this.lastBreakInIndex;
            ArrayList<GenomicAnnotation> newList = new ArrayList<GenomicAnnotation>(dif.size());
            for (GenomicAnnotation oldRegion : dif) {
                newList.addAll(oldRegion.minus(a));
            }
            dif = newList;
        }
        return dif;
    }

    @Override
    public List<GenomicAnnotation> minus(List<? extends GenomicAnnotation> others) {
        return this.minus(others, false, 0);
    }

    @Override
    public List<GenomicAnnotation> minus(GenomicAnnotation other) {
        ArrayList<GenomicAnnotation> dif = new ArrayList<GenomicAnnotation>();
        if (!this.overlaps(other)) {
            dif.add(this);
        } else {
            BasicGenomicAnnotation intersection = new BasicGenomicAnnotation(this);
            intersection.takeIntersection(other);
            BasicGenomicAnnotation first = new BasicGenomicAnnotation(this);
            first.setEnd(intersection.getStart() - 1);
            if (first.getLength() > 0) {
                dif.add(first);
            }
            BasicGenomicAnnotation second = new BasicGenomicAnnotation(this);
            second.setStart(intersection.getEnd() + 1);
            if (second.getLength() > 0) {
                dif.add(second);
            }
        }
        return dif;
    }

    public static <T extends GenomicAnnotation> List<T> stitchList(List<? extends T> sortedList, int maxDistanceToStitch) {
        Stack<Object> result = new Stack<Object>();
        if (sortedList.size() == 0) {
            return result;
        }
        Iterator<T> it = sortedList.iterator();
        result.push(it.next());
        while (it.hasNext()) {
            GenomicAnnotation next = (GenomicAnnotation)it.next();
            GenomicAnnotation curr = (GenomicAnnotation)result.pop();
            if (curr.overlaps(next, maxDistanceToStitch)) {
                curr.stitchTo(next);
                curr.setName(curr.getName() + "-" + next.getName());
                result.push(curr);
                continue;
            }
            result.push(curr);
            result.push(next);
        }
        return result;
    }

    @Override
    public boolean overlaps(GenomicAnnotation other) {
        return this.overlaps(other, 0);
    }

    @Override
    public boolean overlaps(GenomicAnnotation other, int buffer) {
        return (other.getChromosome() == null || other.getChromosome().equals(this.getChromosome())) && this.getStart() < other.getEnd() + buffer && this.getEnd() > other.getStart() - buffer;
    }

    @Override
    public boolean contains(GenomicAnnotation other) {
        return (other.getChromosome() == null || other.getChromosome().equals(this.getChromosome())) && this.getStart() <= other.getStart() && this.getEnd() >= other.getEnd();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public int lastIdxWhereListSearchBroke() {
        return this.lastBreakInIndex;
    }

    @Override
    public void setReversedOrientation(boolean isInReversedOrientation) {
        this.orientation = isInReversedOrientation ? "-" : "=";
    }

    @Override
    public boolean inReversedOrientation() {
        return "-".equals(this.orientation);
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public boolean isOrientation() {
        return "+".equals(this.orientation);
    }

    public void setOrientation(boolean orientation) {
        this.setOrientation(orientation ? "+" : "-");
    }

    @Override
    public void setOrientation(String orientationString) {
        this.orientation = orientationString.intern();
    }

    @Override
    public String getChromosome() {
        return this.chromosome;
    }

    @Override
    public void setChromosome(String chromosome) {
        if (chromosome != null) {
            String chr = chromosome;
            if (chromosome.startsWith("chr")) {
                chr = chromosome.replace("chr", "");
            }
            this.chromosome = chr.intern();
        }
    }

    public void setThreePrimeBuffer(int bufferSize) {
        this.setEnd(this.getEnd() + bufferSize);
        this.threePrimerBuffer = bufferSize;
    }

    public void setFivePrimeBuffer(int bufferSize) {
        this.setStart(this.getStart() - bufferSize);
        this.fivePrimerBuffer = bufferSize;
    }

    @Override
    public int getFivePrimeBases() {
        return this.fivePrimerBuffer;
    }

    @Override
    public int getThreePrimeBases() {
        return this.threePrimerBuffer;
    }

    @Override
    public String getOrientation() {
        return this.inReversedOrientation() ? "-" : "+";
    }

    @Override
    public int compareTo(GenomicAnnotation arg0) {
        if (this.getChromosome() != null && arg0.getChromosome() != null && !this.getChromosome().equals(arg0.getChromosome())) {
            return this.getChromosome().compareTo(arg0.getChromosome()) * 1000000000;
        }
        return this.getStart() != arg0.getStart() ? this.getStart() - arg0.getStart() : this.getEnd() - arg0.getEnd();
    }

    @Override
    public int getOrientedEnd() {
        return this.inReversedOrientation() ? this.getStart() : this.getEnd();
    }

    @Override
    public int getOrientedStart() {
        return this.inReversedOrientation() ? this.getEnd() : this.getStart();
    }

    @Override
    public void addBlock(String name, int start, int end) {
    }

    @Override
    public List<? extends GenomicAnnotation> getBlocks() {
        return null;
    }

    @Override
    public boolean mayHaveBlocks() {
        return false;
    }
}

