/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.assembly;

import edu.mit.broad.prodinfo.assembly.AgpEntry;
import edu.mit.broad.prodinfo.assembly.Gap;
import edu.mit.broad.prodinfo.sequence.FastaSequenceIO;
import edu.mit.broad.prodinfo.sequence.Sequence;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperContig
extends Sequence {
    String name;
    int size;
    List<AgpEntry> gaps;
    List<AgpEntry> contigs;

    public SuperContig(String name) {
        super(name);
        this.name = name;
        this.gaps = new ArrayList<AgpEntry>();
        this.contigs = new ArrayList<AgpEntry>();
    }

    public void addAGPEntry(AgpEntry entry) {
        if (entry.getType() == 2) {
            this.addGap(entry);
        } else {
            this.addContig(entry);
        }
    }

    public void addContig(AgpEntry contig) {
        this.contigs.add(contig);
        this.size += contig.getLength();
    }

    public void addGap(AgpEntry gap) {
        this.gaps.add(gap);
        this.size += gap.getLength();
    }

    public List<AgpEntry> getContigs() {
        return this.contigs;
    }

    public List<AgpEntry> getGaps() {
        return this.gaps;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public void loadContigsFromContigFile(File sequenceFile) throws Exception {
        FastaSequenceIO fsio = new FastaSequenceIO(sequenceFile);
        fsio.extractRecordsIntoSequenceList(this.contigs);
    }

    @Override
    public String getSequenceBases() {
        String sequenceBases = super.getSequenceBases();
        if (sequenceBases == null || sequenceBases.length() == 0) {
            AgpEntry firstGap = this.gaps.size() > 0 ? this.gaps.get(0) : null;
            AgpEntry firstContig = this.contigs.get(0);
            List<AgpEntry> first = firstGap != null && firstGap.getStart() < firstContig.getStart() ? this.gaps : this.contigs;
            List<AgpEntry> second = firstGap != null && firstGap.getStart() < firstContig.getStart() ? this.contigs : this.gaps;
            int i = 0;
            for (i = 0; i < Math.min(first.size(), second.size()); ++i) {
                if (first.get(i).getSequenceBases() == null) {
                    throw new RuntimeException("contig " + first.get(i) + " has no sequence");
                }
                if (second.get(i).getSequenceBases() == null) {
                    throw new RuntimeException("contig " + second.get(i) + " has no sequence");
                }
                this.appendToSequence(first.get(i).getSequenceBases());
                this.appendToSequence(second.get(i).getSequenceBases());
            }
            if (first.size() > second.size()) {
                this.appendToSequence(first.get(i).getSequenceBases());
            }
            sequenceBases = super.getSequenceBases();
        }
        return sequenceBases;
    }

    @Override
    public void unloadSequence() {
        Iterator<AgpEntry> contigIt = this.contigs.iterator();
        while (contigIt.hasNext()) {
            contigIt.next().unloadSequence();
        }
        super.unloadSequence();
    }

    public void loadContigsFromContigFileByName(File sequenceFile, final String agpContigPrefix) throws IOException {
        FastaSequenceIO fsio = new FastaSequenceIO(sequenceFile);
        ArrayList<String> regExList = new ArrayList<String>(this.contigs.size());
        for (AgpEntry contig : this.contigs) {
            regExList.add("_" + contig.getName().replace(agpContigPrefix, "") + " ");
        }
        this.addSequenceToContigs(fsio, regExList, new Comparator<Sequence>(){

            @Override
            public int compare(Sequence arg0, Sequence arg1) {
                return arg0.getId().contains("_" + arg1.getId().replace(agpContigPrefix, "") + " ") ? 0 : 1;
            }
        });
    }

    public void loadContigsFromContigFileBySize(File sequenceFile) throws Exception {
        FastaSequenceIO fsio = new FastaSequenceIO(sequenceFile);
        ArrayList<String> regExList = new ArrayList<String>(this.contigs.size());
        for (AgpEntry contig : this.contigs) {
            regExList.add(contig.getLength() + " nt");
        }
        this.addSequenceToContigs(fsio, regExList, new Comparator<Sequence>(){

            @Override
            public int compare(Sequence arg0, Sequence arg1) {
                return arg0.getLength() - arg1.getLength();
            }
        });
    }

    private void addSequenceToContigs(FastaSequenceIO fsio, List<String> regExList, Comparator<Sequence> comparator) throws IOException {
        List<Sequence> contigSeqs = fsio.extractRecordsWithIDsMatching(regExList, false);
        Iterator<AgpEntry> contigIt = this.contigs.iterator();
        while (contigIt.hasNext()) {
            Iterator<Sequence> contigSeqIt = contigSeqs.iterator();
            AgpEntry contig = contigIt.next();
            boolean found = false;
            System.out.println("Trying to find sequence for " + contig.getId() + " is in reversed orientation " + contig.inReversedOrientation());
            while (contigSeqIt.hasNext() && !found) {
                Sequence contigSeq = contigSeqIt.next();
                if (comparator.compare(contigSeq, contig) != 0) continue;
                if (contig.inReversedOrientation()) {
                    System.out.println("contig " + contig.getName() + " is inverted ");
                    contigSeq.reverse();
                }
                contig.setSequenceBases(contigSeq.getSequenceBases());
                contigSeq.unloadSequence();
                System.out.println("\tFOUND!Adding sequence to " + contig.getName() + " size " + contig.getLength() + " name " + contig.getName());
                found = true;
            }
            if (found) continue;
            throw new RuntimeException("\tCould not find " + contig.getId() + " length " + contig.getLength());
        }
    }

    public void addInitialGap() {
        AgpEntry firstGap = this.gaps.size() > 0 ? this.gaps.get(0) : null;
        AgpEntry firstContig = this.contigs.get(0);
        List<AgpEntry> first = firstGap != null && firstGap.getStart() < firstContig.getStart() ? this.gaps : this.contigs;
        String chr = first.get(0).getChromosome();
        if (first.get(0).getStart() > 1) {
            System.out.println("chr" + chr + " agp does not start at 1, adding initial gap");
            Gap initialGap = new Gap(chr);
            initialGap.setStart(1);
            initialGap.setEnd(first.get(0).getStart() - 1);
            initialGap.setChromosome(chr);
            ArrayList<AgpEntry> tmpGaps = new ArrayList<AgpEntry>(this.gaps.size() + 1);
            tmpGaps.add(initialGap);
            Iterator<AgpEntry> gapIt = this.gaps.iterator();
            while (gapIt.hasNext()) {
                tmpGaps.add(gapIt.next());
            }
            this.gaps = tmpGaps;
        }
    }
}

