/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.assembly;

import edu.mit.broad.prodinfo.sequence.SequenceRegion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCoverageReader {
    ArrayList<CoveredSequenceRegion> coverageRegions;
    ArrayList<CoveredSequenceRegion> coverageRegionsOrderedByCoverage;

    public ReadCoverageReader(String sequenceId, File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = null;
        int lastCov = 0;
        this.coverageRegions = new ArrayList();
        while ((line = br.readLine()) != null) {
            String[] info = line.split("\t");
            int pos = Integer.parseInt(info[0]);
            int cov = Integer.parseInt(info[1]);
            if (pos == 1) {
                CoveredSequenceRegion first = new CoveredSequenceRegion(sequenceId);
                first.setRegionStart(1);
                first.setCoverage(cov);
                this.coverageRegions.add(first);
            } else if (cov != lastCov) {
                CoveredSequenceRegion priorRegion = this.coverageRegions.get(this.coverageRegions.size() - 1);
                priorRegion.setRegionEnd(pos - 1);
                CoveredSequenceRegion newRegion = new CoveredSequenceRegion(sequenceId);
                newRegion.setRegionStart(pos);
                newRegion.setCoverage(cov);
                this.coverageRegions.add(newRegion);
            }
            lastCov = cov;
        }
    }

    public int getCoverageForPercentOfBases(float percentOfintervals) {
        if (this.coverageRegionsOrderedByCoverage == null) {
            this.coverageRegionsOrderedByCoverage = new ArrayList(this.coverageRegions.size());
            for (int i = 0; i < this.coverageRegions.size(); ++i) {
                this.coverageRegionsOrderedByCoverage.add(this.coverageRegions.get(i));
            }
            Collections.sort(this.coverageRegionsOrderedByCoverage, new Comparator<CoveredSequenceRegion>(){

                @Override
                public int compare(CoveredSequenceRegion arg0, CoveredSequenceRegion arg1) {
                    return arg0.coverage - arg1.coverage;
                }
            });
        }
        System.out.print("#regions <" + this.coverageRegions.size() + "> percentOfIntervals<" + percentOfintervals + "> multiplication <" + (float)this.coverageRegions.size() * percentOfintervals + "> ");
        int numberOfIntervals = (int)Math.floor((float)this.coverageRegions.size() * percentOfintervals);
        System.out.println("Number of intervals to use " + numberOfIntervals + " total size " + this.coverageRegions.size());
        return this.coverageRegionsOrderedByCoverage.get(this.coverageRegions.size() - numberOfIntervals).coverage;
    }

    public List<CoveredSequenceRegion> getRegions(int minCoverage) {
        ArrayList<CoveredSequenceRegion> regions = new ArrayList<CoveredSequenceRegion>();
        for (CoveredSequenceRegion reg : this.coverageRegions) {
            SequenceRegion priorReg;
            if (reg.getCoverage() < minCoverage) continue;
            SequenceRegion sequenceRegion = priorReg = regions.size() > 0 ? regions.get(regions.size() - 1) : null;
            if (priorReg != null && priorReg.getEnd() + 1 == reg.getStart()) {
                priorReg.stitchTo(reg);
                continue;
            }
            regions.add(reg);
        }
        return regions;
    }

    public static class CoveredSequenceRegion
    extends SequenceRegion {
        private int coverage;

        public CoveredSequenceRegion(String containingSequenceId) {
            super(containingSequenceId);
        }

        public void setCoverage(int coverage) {
            this.coverage = coverage;
        }

        public int getCoverage() {
            return this.coverage;
        }
    }
}

