/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.assembly;

import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import java.io.File;

public class ChunkResolver {
    private File dir;
    private int chunkSize;
    private String suffix;

    public ChunkResolver(File topLevelDirectory, int chunkSize, String suffix) {
        this.dir = topLevelDirectory;
        this.chunkSize = chunkSize;
        this.suffix = suffix;
    }

    public Chunk getChunk(String chr, int position, int maxSize) {
        if (chr.length() < 3) {
            chr = "chr" + chr;
        }
        int chunkStart = position / this.chunkSize * this.chunkSize;
        Chunk chunk = new Chunk(chr, chunkStart, this.chunkSize, this.dir.getAbsolutePath(), this.suffix, maxSize);
        return chunk;
    }

    public static class Chunk
    extends BasicGenomicAnnotation {
        File location;

        public Chunk(String chr, int start, int chunkSize, String path, String suffix, int maxSize) {
            chr = chr.replace("chr", "");
            this.setStart(start);
            this.setEnd(Math.min(start + chunkSize - 1, maxSize));
            this.setChromosome(chr);
            String name = "chr" + chr + "_" + this.getStart() + "-" + this.getEnd();
            this.setName(name);
            this.location = new File(path + "/" + chr + "/" + name + suffix);
        }

        public File getLocation() {
            return this.location;
        }

        public int getOffset(int genomicLocation) {
            int offset = 0;
            if (genomicLocation < this.getStart() || genomicLocation > this.getEnd()) {
                throw new IllegalArgumentException("Location " + genomicLocation + " does not fall with chunk " + this.toString());
            }
            offset = genomicLocation - this.getStart();
            return offset;
        }
    }
}

