/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.assembly;

import edu.mit.broad.prodinfo.assembly.AgpEntry;
import edu.mit.broad.prodinfo.assembly.Gap;

public class AgpEntryFactory {
    public static AgpEntry createEntry(String[] rawInfo) {
        AgpEntry entry = null;
        String parentName = rawInfo[0];
        entry = new AgpEntry(parentName);
        entry.setName(rawInfo[5]);
        entry.setInReverseOrientation(rawInfo.length == 9 && "-".equals(rawInfo[8]));
        entry.setStart(Integer.parseInt(rawInfo[1]));
        entry.setEnd(Integer.parseInt(rawInfo[2]));
        entry.setNumber(Integer.parseInt(rawInfo[3]));
        if (rawInfo[0].startsWith("Un") || rawInfo[0].startsWith("un")) {
            entry.setChromosome("Un");
        } else {
            entry.setChromosome(rawInfo[0].length() < 4 ? rawInfo[0] : rawInfo[0].substring(3));
            if (entry.getChromosome().startsWith("0")) {
                entry.setChromosome(entry.getChromosome().substring(1));
            }
        }
        if ("F".equals(rawInfo[4])) {
            entry.setName(rawInfo[5]);
            entry.setType(0);
        } else if ("centromere".equalsIgnoreCase(rawInfo[6])) {
            entry.setName("centromere");
            entry.setType(1);
        } else if ("short_arm".equalsIgnoreCase(rawInfo[6])) {
            entry.setName("short_arm");
            entry.setType(5);
        } else if ("N".equals(rawInfo[4])) {
            entry = new Gap(entry);
        } else if ("W".equalsIgnoreCase(rawInfo[4])) {
            entry.setType(4);
        } else {
            entry.setName("other");
            entry.setType(3);
        }
        return entry;
    }
}

