/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.assembly;

import edu.mit.broad.prodinfo.sequence.SequenceRegion;

public class AgpEntry
extends SequenceRegion {
    public static final int CLONE_TYPE = 0;
    public static final int CENTROMERE_TYPE = 1;
    public static final int GAP_TYPE = 2;
    public static final int CONTIG_TYPE = 4;
    public static final int OTHER_TYPE = 3;
    public static final int SHORT_ARM_TYPE = 5;
    private boolean reversedOrientation;
    private int type;
    private int number;

    public AgpEntry(String parentSequence) {
        super(parentSequence);
    }

    protected void setInReverseOrientation(boolean isInreverseOrientation) {
        this.reversedOrientation = isInreverseOrientation;
    }

    public boolean inReversedOrientation() {
        return this.reversedOrientation;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return super.getLength() + 1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("chr" + this.getContainingSequenceId());
        buf.append("\t").append(this.getStart()).append("\t").append(this.getEnd()).append("\t").append(this.getNumber()).append("\t");
        switch (this.getType()) {
            case 0: {
                buf.append("F\t");
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                buf.append("N\t");
                break;
            }
            case 4: {
                buf.append("W\t");
                break;
            }
            default: {
                buf.append("O\t");
            }
        }
        buf.append(this.getName()).append("\t").append("0\t").append(this.getLength() + 1).append("\t+");
        return buf.toString();
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }
}

