/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.annotation;

import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFF
extends BasicGenomicAnnotation {
    private String source;
    private String feature;
    private int frame;
    private String group;
    private HashMap<String, List<String>> attributes;

    public GFF() {
        this.attributes = new HashMap();
    }

    public GFF(String name) {
        super(name);
        this.attributes = new HashMap();
    }

    public GFF(GenomicAnnotation annotation) {
        super(annotation);
        this.attributes = new HashMap();
        this.setSource("Unknown");
        this.setFeature("GenomicAnnotation");
    }

    public GFF(GFF gff) {
        super(gff);
        this.attributes = new HashMap(gff.attributes.size());
        for (String key : gff.attributes.keySet()) {
            this.attributes.put(key, gff.getValues(key));
        }
        this.setSource(gff.getSource());
        this.frame = gff.getFrame();
        this.setFeature(gff.getFeature());
    }

    public GFF(String[] rawFields) {
        this.attributes = new HashMap();
        int i = 0;
        super.setChromosome(rawFields[i++].substring(3));
        this.setSource(rawFields[i++]);
        this.setFeature(rawFields[i++]);
        this.setStart(rawFields[i++]);
        this.setEnd(rawFields[i++]);
        String scoreStr = rawFields[i++];
        if (!".".equals(scoreStr)) {
            this.setScore(new Float(Float.parseFloat(scoreStr)).floatValue());
        }
        this.setStrand(rawFields[i++]);
        String frameStr = rawFields[i++];
        if (!".".equals(frameStr)) {
            this.setFrame(Integer.parseInt(frameStr));
        }
        this.setAttributes(rawFields[i]);
    }

    public void setAttributes(String rawAttributeData) {
        String[] attributeArray = rawAttributeData.split(" *; *");
        for (int i = 0; i < attributeArray.length; ++i) {
            String[] attributeData = attributeArray[i].split(" +");
            for (int j = 1; j < attributeData.length; ++j) {
                this.addAttribute(attributeData[0], attributeData[j]);
            }
        }
        if (this.getFirstValue("name") != null) {
            this.setName(this.getFirstValue("name"));
        } else if (attributeArray.length == 1) {
            this.setName(attributeArray[0]);
        } else {
            this.setName("no_name");
        }
    }

    public String getStrand() {
        return super.inReversedOrientation() ? "-" : "+";
    }

    public void setStrand(String strand) {
        this.setReversedOrientation("-".equals(strand) || "-1".equals(strand));
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature.intern();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public String getSource() {
        return this.source;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        List<String> values = this.attributes.get(attributeName);
        if (values == null) {
            values = new ArrayList<String>();
            this.attributes.put(attributeName.intern(), values);
        }
        values.add(attributeValue);
    }

    public void addAttributeValues(String attributeName, List<String> values) {
        List<String> attValues = this.attributes.get(attributeName);
        if (values == null) {
            attValues = new ArrayList<String>();
            this.attributes.put(attributeName.intern(), attValues);
        }
        values.addAll(values);
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public List<String> getValues(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public String getFirstValue(String attributeName) {
        String val = null;
        if (this.attributes.containsKey(attributeName) && this.attributes.get(attributeName).size() > 0) {
            val = this.attributes.get(attributeName).get(0);
        }
        return val;
    }

    public String getSequenceName() {
        return ("chr" + super.getChromosome()).intern();
    }

    public void setSource(String source) {
        this.source = source.intern();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getGFFFieldString(this.getSequenceName()));
        sb.append("\t").append(this.getGFFFieldString(this.getSource())).append("\t").append(this.getGFFFieldString(this.getFeature())).append("\t").append(this.getStart()).append("\t").append(this.getEnd()).append("\t").append(this.getGFFFieldString(this.getScore())).append("\t").append(this.getStrand()).append("\t").append(this.frame).append("\t").append(this.getGFFFieldString(this.group)).append("\tname ").append(this.getName());
        Iterator<String> attributeNameIt = this.attributes.keySet().iterator();
        String attributeName = null;
        while (attributeNameIt.hasNext()) {
            attributeName = attributeNameIt.next();
            if ("name".equals(attributeName)) continue;
            sb.append(" ; ");
            sb.append(attributeName);
            Iterator<String> attValIt = this.attributes.get(attributeName).iterator();
            while (attValIt.hasNext()) {
                sb.append(" ").append(attValIt.next());
            }
        }
        return sb.toString();
    }

    private String getGFFFieldString(Object obj) {
        return obj == null ? "." : obj.toString();
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group.intern();
    }
}

