/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.annotation;

import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscontinuousAnnotation<G extends GenomicAnnotation>
extends BasicGenomicAnnotation
implements List<G> {
    List<G> parts = new ArrayList<G>();
    int maxDistToStitch;

    public DiscontinuousAnnotation(String name) {
        super(name);
    }

    public DiscontinuousAnnotation(String name, List<G> list, int maxDistanceToStitch) {
        this(name);
        this.maxDistToStitch = maxDistanceToStitch;
        this.addAll((Collection<G>)list);
    }

    @Override
    public boolean contains(GenomicAnnotation other) {
        int pos = Collections.binarySearch(this.parts, other, new Comparator<GenomicAnnotation>(){

            @Override
            public int compare(GenomicAnnotation arg0, GenomicAnnotation arg1) {
                return arg0.contains(arg1) ? 0 : arg0.compareTo(arg1);
            }
        });
        return pos >= 0;
    }

    @Override
    public int getDistanceTo(GenomicAnnotation other) {
        GenomicAnnotation closest = this.getClosestPart(other);
        return closest.getDistanceTo(other);
    }

    @Override
    public int getEnd() {
        return this.parts.size() > 0 ? ((GenomicAnnotation)this.parts.get(this.parts.size() - 1)).getEnd() : 0;
    }

    @Override
    public int getStart() {
        return this.parts.size() > 0 ? ((GenomicAnnotation)this.parts.get(0)).getStart() : 0;
    }

    @Override
    public List<GenomicAnnotation> minus(List<? extends GenomicAnnotation> others) {
        ArrayList<GenomicAnnotation> diff = new ArrayList<GenomicAnnotation>(this.parts.size());
        Iterator<G> partIt = this.parts.iterator();
        while (partIt.hasNext()) {
            diff.addAll(((GenomicAnnotation)partIt.next()).minus(others));
        }
        return diff;
    }

    @Override
    public List<GenomicAnnotation> minus(GenomicAnnotation other) {
        ArrayList<GenomicAnnotation> oneList = new ArrayList<GenomicAnnotation>(1);
        oneList.add(other);
        return this.minus(oneList);
    }

    @Override
    public boolean overlaps(GenomicAnnotation other, int buffer) {
        int pos = Collections.binarySearch(this.parts, other, new Comparator<GenomicAnnotation>(){

            @Override
            public int compare(GenomicAnnotation arg0, GenomicAnnotation arg1) {
                return arg0.overlaps(arg1) ? 0 : arg0.compareTo(arg1);
            }
        });
        return pos >= 0;
    }

    @Override
    public boolean overlaps(GenomicAnnotation other) {
        return this.overlaps(other, 0);
    }

    @Override
    public void setEnd(int end) {
    }

    @Override
    public void setStart(int start) {
    }

    public int getEffectiveLength() {
        int length = 0;
        Iterator<G> it = this.parts.iterator();
        while (it.hasNext()) {
            length += ((GenomicAnnotation)it.next()).getLength();
        }
        return length;
    }

    @Override
    public void takeIntersection(GenomicAnnotation other) {
        GenomicAnnotation closest = this.getClosestPart(other);
        if (closest.overlaps(other)) {
            closest.takeIntersection(other);
        }
    }

    @Override
    public void takeUnion(GenomicAnnotation other) {
        GenomicAnnotation closest = this.getClosestPart(other);
        closest.takeUnion(other);
    }

    public GenomicAnnotation getClosestPart(GenomicAnnotation annot) {
        Object closest = null;
        if (this.size() > 0) {
            closest = this.get(this.getClosestPartIdx(annot));
        }
        return closest;
    }

    private int getClosestPartIdx(GenomicAnnotation annot) {
        int pos;
        int closestPos = pos = Collections.binarySearch(this.parts, annot);
        if (this.parts.size() > 0 && pos < 0) {
            int nextPos = Math.min(this.parts.size() - 1, -pos - 1);
            int priorPos = Math.max(0, -pos - 2);
            GenomicAnnotation prior = (GenomicAnnotation)this.parts.get(priorPos);
            GenomicAnnotation next = (GenomicAnnotation)this.parts.get(nextPos);
            closestPos = annot.getDistanceTo(prior) > annot.getDistanceTo(next) ? nextPos : priorPos;
        }
        return closestPos;
    }

    public List<G> getOverlappingParts(GenomicAnnotation annot) {
        ArrayList<GenomicAnnotation> overlaps = new ArrayList<GenomicAnnotation>(1);
        if (this.size() > 0) {
            GenomicAnnotation a;
            int closestIdx = this.getClosestPartIdx(annot);
            ListIterator<G> listIt = this.listIterator(closestIdx);
            boolean overlapped = true;
            while (listIt.hasNext() && overlapped) {
                a = (GenomicAnnotation)listIt.next();
                if (a.overlaps(annot)) {
                    overlaps.add(a);
                    continue;
                }
                overlapped = false;
            }
            if (closestIdx - 1 >= 0) {
                listIt = this.listIterator(closestIdx - 1);
                overlapped = true;
                while (listIt.hasPrevious() && overlapped) {
                    a = (GenomicAnnotation)listIt.previous();
                    if (a.overlaps(annot)) {
                        overlaps.add(a);
                        continue;
                    }
                    overlapped = false;
                }
            }
        }
        Collections.sort(overlaps);
        return overlaps;
    }

    @Override
    public boolean add(G annotation) {
        return this.parts.add(annotation);
    }

    public void consolidate() {
        Collections.sort(this.parts);
        this.parts = BasicGenomicAnnotation.stitchList(this.parts, this.maxDistToStitch);
    }

    @Override
    public void add(int arg0, GenomicAnnotation arg1) {
        throw new UnsupportedOperationException("The position of added genomic annotations are determined based on their natural ordering, they can't be set");
    }

    @Override
    public boolean addAll(Collection<? extends G> arg0) {
        for (GenomicAnnotation a : arg0) {
            this.add((G)a);
        }
        return true;
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends G> arg1) {
        throw new UnsupportedOperationException("The position of added genomic annotations are determined based on their natural ordering, they can't be set");
    }

    @Override
    public void clear() {
        this.parts.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.parts.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.parts.containsAll(arg0);
    }

    @Override
    public G get(int i) {
        return (G)((GenomicAnnotation)this.parts.get(i));
    }

    @Override
    public int indexOf(Object arg0) {
        return this.parts.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    @Override
    public Iterator<G> iterator() {
        return this.parts.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.parts.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<G> listIterator() {
        return this.parts.listIterator();
    }

    @Override
    public ListIterator<G> listIterator(int i) {
        return this.parts.listIterator(i);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.parts.remove(arg0);
    }

    @Override
    public G remove(int i) {
        return (G)((GenomicAnnotation)this.parts.remove(i));
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.parts.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.parts.retainAll(arg0);
    }

    @Override
    public G set(int i, G arg1) {
        throw new UnsupportedOperationException("The position of added genomic annotations are determined based on their natural ordering, they can't be set");
    }

    @Override
    public int size() {
        return this.parts.size();
    }

    @Override
    public List<G> subList(int i, int j) {
        return this.parts.subList(i, j);
    }

    @Override
    public Object[] toArray() {
        return this.parts.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.parts.toArray(arg0);
    }
}

