/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.annotation;

import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.ParseException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BED
extends BasicGenomicAnnotation {
    private String rgb;
    private int thickStart;
    private int thickEnd;
    private int[][] blockSizeStarts;

    public BED(String name) {
        super(name);
    }

    public BED(GenomicAnnotation anot) {
        super(anot);
    }

    public BED(BED anot) {
        super(anot);
        this.thickStart = anot.thickStart;
        this.thickEnd = anot.thickEnd;
        this.blockSizeStarts = anot.blockSizeStarts;
    }

    public BED(String[] info) throws ParseException {
        this.setChromosome(info[0].length() < 4 ? info[0] : info[0].substring(3));
        this.setStart(Integer.parseInt(info[1]));
        this.setEnd(Integer.parseInt(info[2]));
        if (info.length == 3) {
            this.setName(info[0] + ":" + info[1] + "-" + info[2]);
        } else {
            this.setName(info[3]);
        }
        if (info.length > 4) {
            this.setScore(Double.parseDouble(info[4]));
        }
        if (info.length > 5) {
            this.setOrientation(info[5]);
            if (info.length == 7) {
                this.rgb = info[6];
            } else {
                int blockCount;
                this.thickStart = info.length > 7 && info[6].length() > 0 ? Integer.parseInt(info[6]) : 0;
                this.thickEnd = info.length >= 8 && info[7].length() > 0 ? Integer.parseInt(info[7]) : 0;
                String string = this.rgb = info.length >= 9 && info[8].length() > 0 ? info[8] : null;
                if (info.length > 9 && (blockCount = Integer.parseInt(info[9])) > 0) {
                    this.blockSizeStarts = new int[blockCount][2];
                    String[] starts = info[10].split(",");
                    String[] ends = info[11].split(",");
                    if (starts.length != blockCount || ends.length != blockCount) {
                        throw new ParseException("BAD BED FORMAT apparently the number of start (" + info[10] + ") and end (" + info[11] + ") items does not agree with te blockCount " + info[9]);
                    }
                    for (int i = 0; i < blockCount; ++i) {
                        this.blockSizeStarts[i][0] = Integer.parseInt(starts[i]);
                        this.blockSizeStarts[i][1] = Integer.parseInt(ends[i]);
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean setNegativeScoresTo0) {
        StringBuffer buf = new StringBuffer("chr");
        buf.append(this.getChromosome()).append("\t").append(this.getStart()).append("\t").append(this.getEnd()).append("\t").append(this.getName()).append("\t").append(this.getScore() < 0.0 && setNegativeScoresTo0 ? "0" : Double.valueOf(this.getScore())).append("\t").append(this.getOrientation()).append("\t").append(this.thickStart > 0 ? this.thickStart : this.getStart()).append("\t").append(this.thickEnd > 0 ? this.thickEnd : this.getEnd()).append("\t").append(this.rgb != null ? this.rgb : "0,0,0").append("\t");
        if (this.blockSizeStarts != null && this.blockSizeStarts.length > 0) {
            int i;
            buf.append(this.blockSizeStarts.length).append("\t");
            for (i = 0; i < this.blockSizeStarts.length - 1; ++i) {
                buf.append(this.blockSizeStarts[i][0]).append(",");
            }
            buf.append(this.blockSizeStarts[this.blockSizeStarts.length - 1][0]).append("\t");
            for (i = 0; i < this.blockSizeStarts.length - 1; ++i) {
                buf.append(this.blockSizeStarts[i][1]).append(",");
            }
            buf.append(this.blockSizeStarts[this.blockSizeStarts.length - 1][1]);
        }
        return buf.toString();
    }

    public String toWIGString() {
        StringBuffer buf = new StringBuffer("chr");
        buf.append(this.getChromosome()).append("\t").append(this.getStart()).append("\t").append(this.getEnd()).append("\t").append(Math.round(this.getScore()));
        return buf.toString();
    }

    public int[][] getBlockSizeStarts() {
        return this.blockSizeStarts;
    }

    public void setBlockSizeStarts(int[][] blockSizeStarts) {
        this.blockSizeStarts = blockSizeStarts;
    }

    public List<GenomicAnnotation> getBlocks() {
        ArrayList<GenomicAnnotation> blocks = new ArrayList<GenomicAnnotation>();
        if (this.blockSizeStarts != null) {
            for (int i = 0; i < this.blockSizeStarts.length; ++i) {
                BasicGenomicAnnotation block = new BasicGenomicAnnotation(this.getName() + "_" + i);
                block.setChromosome(this.getChromosome());
                block.setStart(this.getStart() + this.blockSizeStarts[i][1]);
                block.setEnd(block.getStart() + this.blockSizeStarts[i][0]);
                blocks.add(block);
            }
        }
        return blocks;
    }

    public String getRgb() {
        return this.rgb;
    }

    public void setRgb(String rgb) {
        this.rgb = rgb;
    }

    public int getThickEnd() {
        return this.thickEnd;
    }

    public void setThickEnd(int thickEnd) {
        this.thickEnd = thickEnd;
    }

    public int getThickStart() {
        return this.thickStart;
    }

    public void setThickStart(int thickStart) {
        this.thickStart = thickStart;
    }

    @Override
    public void addBlock(String name, int start, int end) {
        int adjustedStart = start - this.getStart();
        int length = end - start;
        System.err.print("Mapped region: " + this.getLocationString() + "(" + this.getOrientation() + ") adding " + name + " " + start + "-" + end);
        if (this.blockSizeStarts == null || this.blockSizeStarts.length == 0) {
            this.blockSizeStarts = new int[1][2];
            this.blockSizeStarts[0][0] = length;
            this.blockSizeStarts[0][1] = adjustedStart;
        } else {
            int[][] newBlockSizes = new int[this.blockSizeStarts.length + 1][2];
            boolean newAdded = false;
            int i = 0;
            int j = 0;
            while (i < this.blockSizeStarts.length) {
                if (this.blockSizeStarts[i][1] <= adjustedStart || newAdded) {
                    newBlockSizes[j][0] = this.blockSizeStarts[i][0];
                    newBlockSizes[j][1] = this.blockSizeStarts[i][1];
                    ++i;
                    ++j;
                    continue;
                }
                if (this.blockSizeStarts[i][1] <= adjustedStart || newAdded) continue;
                newBlockSizes[j][0] = length;
                newBlockSizes[j][1] = adjustedStart;
                newAdded = true;
                System.err.print(" added at idx " + j);
                ++j;
            }
            if (!newAdded) {
                newBlockSizes[this.blockSizeStarts.length][0] = length;
                newBlockSizes[this.blockSizeStarts.length][1] = adjustedStart;
            }
            this.blockSizeStarts = newBlockSizes;
        }
        System.err.println(" first block start " + this.blockSizeStarts[0][1]);
    }

    @Override
    public boolean mayHaveBlocks() {
        return true;
    }
}

