/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.annotation;

import edu.mit.broad.prodinfo.annotation.AnnotationFactory;
import edu.mit.broad.prodinfo.annotation.AnnotationFactoryFactory;
import edu.mit.broad.prodinfo.annotation.AnnotationReader;
import edu.mit.broad.prodinfo.annotation.AnnotationReaderFactory;
import edu.mit.broad.prodinfo.datastrutures.IntervalTree;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.util.CLUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;

public class AnnotationUtils {
    public static final String USAGE = "Usage: AnnotationUtils TASK=<task_num> <task_args>\n\tTasks:\n\t\t1. Take the intersection two annotation sets: -set1 <File containing first set>  -set2 <File containing second set> \n\t\t\t [-set1format <[BED], GFF or generic> -set2format <[BED], GFF or generic> -outformat <desired output format BED, GFF or generic, default is se1format>\n\t2. Take the difference of two annotation sets: -set1 <File containing first set>  -set2 <File containing second set> \n\t\t [-set1format <[BED], GFF or generic> -set2format <[BED], GFF or generic> -outformat <desired output format BED, GFF or generic, default is se1format>\n\t3. Print out all elements in one set (set1) that overlap another (set2): -set1 <File containing first set>  -set2 <File containing second set> \n\t\t [-set1format <[BED], GFF or generic> -set2format <[BED], GFF or generic> -outformat <desired output format BED, GFF or generic, default is se1format>\n\t4. Merge annotation file -in <annotation file (dowa not support standard input input at this point)> -out <output file name or standard output by default> [-format <[BED], GFF or generic>]\n\t5. Reformat annotatin file  -in <annotation file (dowa not support standard input input at this point)> -out <output file name or standard output by default> [-informat <[BED], GFF or generic> -outformat <BED,[GFF],generic]\n";

    public static void main(String[] args) throws IOException, ParseException {
        CLUtil.ArgumentMap argMap = CLUtil.getParameters(args, USAGE);
        if ("1".equals(argMap.getTask())) {
            String set1In = argMap.getMandatory("set1");
            String set2In = argMap.getMandatory("set2");
            String set1Format = argMap.containsKey("set1format") ? argMap.get("set1format") : "BED";
            String set2Format = argMap.containsKey("set2format") ? argMap.get("set2format") : "BED";
            AnnotationReader<? extends GenomicAnnotation> set1 = AnnotationReaderFactory.create(set1In, set1Format);
            AnnotationReader<? extends GenomicAnnotation> set2 = AnnotationReaderFactory.create(set2In, set2Format);
            set1.intersect(set2.getAnnotationList());
            Iterator<String> chrIt = set1.getChromosomeAnnotationMap().keySet().iterator();
            BufferedWriter bufferedWriter = argMap.getOutputWriter();
            while (chrIt.hasNext()) {
                String chr = chrIt.next();
                IntervalTree<? extends GenomicAnnotation> tree = set1.getChromosomeTree(chr);
                Iterator<? extends GenomicAnnotation> annotIt = tree.valueIterator();
                while (annotIt.hasNext()) {
                    GenomicAnnotation annot = annotIt.next();
                    bufferedWriter.write(annot.toString());
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        } else if ("2".equals(argMap.getTask())) {
            String set1In = argMap.getMandatory("set1");
            String set2In = argMap.getMandatory("set2");
            String set1Format = argMap.containsKey("set1format") ? argMap.get("set1format") : "BED";
            String set2Format = argMap.containsKey("set2format") ? argMap.get("set2format") : "BED";
            AnnotationReader<? extends GenomicAnnotation> set1 = AnnotationReaderFactory.create(set1In, set1Format);
            AnnotationReader<? extends GenomicAnnotation> set2 = AnnotationReaderFactory.create(set2In, set2Format);
            set1.minus(set2.getAnnotationList());
            BufferedWriter bw = argMap.getOutputWriter();
            for (String chr : set1.getChromosomeAnnotationMap().keySet()) {
                IntervalTree<? extends GenomicAnnotation> tree = set1.getChromosomeTree(chr);
                Iterator<? extends GenomicAnnotation> annotIt = tree.valueIterator();
                while (annotIt.hasNext()) {
                    GenomicAnnotation annot = annotIt.next();
                    bw.write(annot.toString());
                    bw.newLine();
                }
            }
            bw.close();
        } else if ("3".equals(argMap.getTask())) {
            String set1In = argMap.getMandatory("set1");
            String set2In = argMap.getMandatory("set2");
            String set1Format = argMap.containsKey("set1format") ? argMap.get("set1format") : "BED";
            String set2Format = argMap.containsKey("set2format") ? argMap.get("set2format") : "BED";
            AnnotationReader<? extends GenomicAnnotation> set1 = AnnotationReaderFactory.create(set1In, set1Format);
            AnnotationReader<? extends GenomicAnnotation> set2 = AnnotationReaderFactory.create(set2In, set2Format);
            set1.filterByOverlap(set2.getAnnotationList());
            BufferedWriter bw = argMap.getOutputWriter();
            for (String chr : set1.getChromosomeAnnotationMap().keySet()) {
                IntervalTree<? extends GenomicAnnotation> tree = set1.getChromosomeTree(chr);
                Iterator<? extends GenomicAnnotation> annotIt = tree.valueIterator();
                while (annotIt.hasNext()) {
                    GenomicAnnotation annot = annotIt.next();
                    bw.write(annot.toString());
                    bw.newLine();
                }
            }
            bw.close();
        } else if ("4".equals(argMap.getTask())) {
            String in = argMap.getInput();
            String format = argMap.containsKey("format") ? argMap.get("format") : "BED";
            AnnotationReader<? extends GenomicAnnotation> set = AnnotationReaderFactory.create(in, format);
            set.merge();
            BufferedWriter bw = argMap.getOutputWriter();
            for (String chr : set.getChromosomeAnnotationMap().keySet()) {
                IntervalTree<? extends GenomicAnnotation> tree = set.getChromosomeTree(chr);
                Iterator<? extends GenomicAnnotation> iterator = tree.valueIterator();
                while (iterator.hasNext()) {
                    GenomicAnnotation annot = iterator.next();
                    bw.write(annot.toString());
                    bw.newLine();
                }
            }
            bw.close();
        } else if ("5".equals(argMap.getTask())) {
            String in = argMap.getInput();
            String informat = argMap.containsKey("format") ? argMap.get("format") : "BED";
            String outformat = argMap.containsKey("format") ? argMap.get("format") : "GFF";
            AnnotationReader<? extends GenomicAnnotation> set = AnnotationReaderFactory.create(in, informat);
            AnnotationFactory<? extends GenomicAnnotation> factory = AnnotationFactoryFactory.getFactory(outformat);
            BufferedWriter bw = argMap.getOutputWriter();
            for (GenomicAnnotation genomicAnnotation : set.getAnnotationList()) {
                GenomicAnnotation reformattedAnnotation = factory.create(genomicAnnotation);
                bw.write(reformattedAnnotation.toString());
                bw.newLine();
            }
            bw.close();
        } else {
            System.err.println("Task " + argMap.getTask() + " is invalid or no task was specified");
        }
    }
}

