/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.annotation;

import edu.mit.broad.prodinfo.annotation.AnnotationFactory;
import edu.mit.broad.prodinfo.datastrutures.IntervalTree;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotationFilter;
import edu.mit.broad.prodinfo.genomicplot.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationReader<T extends GenomicAnnotation> {
    private List<String> browserLines = new ArrayList<String>();
    private List<AnnotationSet<T>> annotationSetMap = new ArrayList<AnnotationSet<T>>();

    public void clear() {
        this.browserLines.clear();
        this.annotationSetMap.clear();
    }

    public void load(File source, AnnotationFactory<? extends T> factory) throws IOException, ParseException {
        this.load(new BufferedReader(new FileReader(source)), factory);
    }

    public void load(BufferedReader br, AnnotationFactory<? extends T> factory) throws IOException, ParseException {
        this.load(br, factory, new GenomicAnnotationFilter<T>(){

            @Override
            public boolean accept(T annotation) {
                return true;
            }

            @Override
            public boolean isEnough(T annotation) {
                return false;
            }
        });
    }

    public void load(File source, AnnotationFactory<? extends T> factory, GenomicAnnotationFilter<T> filter) throws IOException, ParseException {
        this.load(new BufferedReader(new FileReader(source)), factory, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(BufferedReader br, AnnotationFactory<? extends T> factory, GenomicAnnotationFilter<T> filter) throws IOException, ParseException {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.toLowerCase().startsWith("browser")) {
                    this.browserLines.add(line);
                    continue;
                }
                if (line.toLowerCase().startsWith("track")) {
                    AnnotationSet track = new AnnotationSet();
                    track.setInfoFromRawData(line);
                    this.annotationSetMap.add(track);
                    continue;
                }
                String[] lineSplit = line.split("\t");
                T annotation = factory.create(lineSplit);
                if (!filter.accept(annotation)) continue;
                if (filter.isEnough(annotation)) {
                    break;
                }
                AnnotationSet<T> currentSet = null;
                if (this.annotationSetMap.isEmpty()) {
                    currentSet = new AnnotationSet<T>();
                    this.annotationSetMap.add(currentSet);
                } else {
                    currentSet = this.annotationSetMap.get(this.annotationSetMap.size() - 1);
                }
                currentSet.addAnnotation(annotation);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, List<T>> getChromosomeAnnotationMap() {
        return this.getChromosomeAnnotationMap(0);
    }

    public Map<String, List<T>> getChromosomeAnnotationMap(int i) {
        return this.annotationSetMap.size() > i ? this.annotationSetMap.get(i).getAsChromosomeAnnotationMap() : null;
    }

    public int getBaseCoverage(List<T> annotations) {
        int cov = 0;
        for (GenomicAnnotation annotation : annotations) {
            cov += annotation.getLength();
        }
        return cov;
    }

    public int numberCovered(List<? extends GenomicAnnotation> annotations) {
        int num = 0;
        for (GenomicAnnotation genomicAnnotation : annotations) {
            Iterator<IntervalTree.Node<T>> overlapIt;
            IntervalTree<T> tree = this.getChromosomeTree(genomicAnnotation.getChromosome());
            if (tree == null || !(overlapIt = tree.overlappers(genomicAnnotation.getStart(), genomicAnnotation.getEnd())).hasNext()) continue;
            ++num;
        }
        return num;
    }

    public void intersect(List<? extends GenomicAnnotation> annotations) {
        HashMap<String, IntervalTree<T>> intersectTree = new HashMap<String, IntervalTree<T>>();
        for (GenomicAnnotation genomicAnnotation : annotations) {
            IntervalTree<T> tree = this.getChromosomeTree(genomicAnnotation.getChromosome());
            if (tree == null) continue;
            Iterator<IntervalTree.Node<T>> overlaperIt = tree.overlappers(genomicAnnotation.getStart(), genomicAnnotation.getEnd());
            int intersectNum = 0;
            while (overlaperIt.hasNext()) {
                IntervalTree.Node<T> overlapperNode = overlaperIt.next();
                GenomicAnnotation overlapper = (GenomicAnnotation)overlapperNode.getValue();
                T intersect = this.createAnnotation(genomicAnnotation);
                intersect.setName(overlapper.getName() + "_" + genomicAnnotation.getName());
                intersect.setScore(overlapper.getScore());
                IntervalTree<Object> newTree = intersectTree.get(genomicAnnotation.getChromosome());
                if (newTree == null) {
                    newTree = new IntervalTree();
                    intersectTree.put(genomicAnnotation.getChromosome(), newTree);
                }
                intersect.takeIntersection(overlapper);
                newTree.put(intersect.getStart(), intersect.getEnd(), intersect);
                ++intersectNum;
            }
        }
        this.setChromosomeTreeMap(0, intersectTree);
    }

    public void minus(List<? extends GenomicAnnotation> annotations) {
        Iterator<? extends GenomicAnnotation> it = annotations.iterator();
        ArrayList<GenomicAnnotation> toRemove = new ArrayList<GenomicAnnotation>();
        while (it.hasNext()) {
            GenomicAnnotation annot = it.next();
            IntervalTree<T> tree = this.getChromosomeTree(annot.getChromosome());
            if (tree == null) continue;
            IntervalTree.ValuesIterator overlaperIt = new IntervalTree.ValuesIterator(tree.overlappers(annot.getStart(), annot.getEnd()));
            while (overlaperIt.hasNext()) {
                GenomicAnnotation overlapper = (GenomicAnnotation)overlaperIt.next();
                if (toRemove.contains(overlapper)) continue;
                toRemove.add(overlapper);
            }
        }
        for (GenomicAnnotation t : toRemove) {
            IntervalTree<T> tree = this.getChromosomeTree(t.getChromosome());
            tree.remove(t.getStart(), t.getEnd());
        }
    }

    public void filterByOverlap(List<? extends GenomicAnnotation> annotations) {
        HashMap<String, IntervalTree<T>> intersectTree = new HashMap<String, IntervalTree<T>>();
        for (GenomicAnnotation genomicAnnotation : annotations) {
            IntervalTree<T> tree = this.getChromosomeTree(genomicAnnotation.getChromosome());
            if (tree == null) continue;
            Iterator<IntervalTree.Node<T>> overlaperIt = tree.overlappers(genomicAnnotation.getStart(), genomicAnnotation.getEnd());
            while (overlaperIt.hasNext()) {
                IntervalTree.Node<T> overlapperNode = overlaperIt.next();
                GenomicAnnotation overlapper = (GenomicAnnotation)overlapperNode.getValue();
                IntervalTree<Object> newTree = intersectTree.get(genomicAnnotation.getChromosome());
                if (newTree == null) {
                    newTree = new IntervalTree();
                    intersectTree.put(genomicAnnotation.getChromosome(), newTree);
                }
                if (newTree.find(overlapperNode.getStart(), overlapperNode.getEnd()) != null) continue;
                newTree.put(overlapper.getStart(), overlapper.getEnd(), overlapper);
            }
        }
        this.setChromosomeTreeMap(0, intersectTree);
    }

    public int getBaseCoverage() {
        return this.getBaseCoverage(this.getAnnotationList());
    }

    public abstract T createAnnotation(GenomicAnnotation var1);

    public void shift(int amountToShift) {
        for (GenomicAnnotation annotation : this.getAnnotationList()) {
            IntervalTree<T> tree = this.getChromosomeTree(annotation.getChromosome());
            tree.remove(annotation.getStart(), annotation.getEnd());
            annotation.setStart(annotation.getStart() + amountToShift);
            annotation.setEnd(annotation.getEnd() + amountToShift);
            tree.put(annotation.getStart(), annotation.getStart(), annotation);
        }
    }

    public void merge() {
        this.merge(0);
    }

    public List<T> getOverlappers(List<? extends GenomicAnnotation> annotationList) {
        ArrayList<GenomicAnnotation> overlappers = new ArrayList<GenomicAnnotation>();
        for (GenomicAnnotation genomicAnnotation : annotationList) {
            IntervalTree<T> tree = this.getChromosomeTree(genomicAnnotation.getChromosome());
            if (tree == null) continue;
            IntervalTree.ValuesIterator overlapperIt = new IntervalTree.ValuesIterator(tree.overlappers(genomicAnnotation.getStart(), genomicAnnotation.getEnd()));
            while (overlapperIt.hasNext()) {
                GenomicAnnotation overlapper = (GenomicAnnotation)overlapperIt.next();
                if (overlappers.contains(overlapper)) continue;
                overlappers.add(overlapper);
            }
        }
        return overlappers;
    }

    public List<T> getOverlappers(GenomicAnnotation annotation) {
        ArrayList<GenomicAnnotation> overlappers = new ArrayList<GenomicAnnotation>();
        IntervalTree<T> tree = this.getChromosomeTree(annotation.getChromosome());
        if (tree != null) {
            IntervalTree.ValuesIterator overlapperIt = new IntervalTree.ValuesIterator(tree.overlappers(annotation.getStart(), annotation.getEnd()));
            while (overlapperIt.hasNext()) {
                GenomicAnnotation overlapper = (GenomicAnnotation)overlapperIt.next();
                if (overlappers.contains(overlapper)) continue;
                overlappers.add(overlapper);
            }
        }
        return overlappers;
    }

    public void merge(int setNumber) {
        HashMap<String, IntervalTree<T>> mergedTreeMap = new HashMap<String, IntervalTree<T>>();
        Map<String, IntervalTree<T>> originalTreeMap = this.getChromosomeTreeMap(setNumber);
        for (String chr : originalTreeMap.keySet()) {
            IntervalTree<GenomicAnnotation> newTree = new IntervalTree<GenomicAnnotation>();
            mergedTreeMap.put(chr, newTree);
            IntervalTree<T> oldTree = originalTreeMap.get(chr);
            IntervalTree.ValuesIterator valueIt = new IntervalTree.ValuesIterator(oldTree.iterator());
            while (valueIt.hasNext()) {
                GenomicAnnotation currentElement = (GenomicAnnotation)valueIt.next();
                IntervalTree.ValuesIterator overlapperIt = new IntervalTree.ValuesIterator(newTree.overlappers(currentElement.getStart(), currentElement.getEnd()));
                if (overlapperIt.hasNext()) {
                    GenomicAnnotation overlapper = (GenomicAnnotation)overlapperIt.next();
                    if (overlapperIt.hasNext()) {
                        throw new IllegalStateException("Two elements overlapped the current element in the new merged tree, this should never happen");
                    }
                    newTree.remove(overlapper.getStart(), overlapper.getEnd());
                    overlapper.takeUnion(currentElement);
                    newTree.put(overlapper.getStart(), overlapper.getEnd(), overlapper);
                    continue;
                }
                newTree.put(currentElement.getStart(), currentElement.getEnd(), currentElement);
            }
        }
        this.setChromosomeTreeMap(setNumber, mergedTreeMap);
    }

    public void addAnnotation(T annotation, int track) {
        AnnotationSet<T> set = this.annotationSetMap.get(track);
        if (set == null) {
            throw new IndexOutOfBoundsException("No track for given index " + track);
        }
        set.addAnnotation(annotation);
    }

    public void addAnnotation(T annotation) {
        this.addAnnotation(annotation, 0);
    }

    public List<T> getAnnotationsForSequence(String sequenceName) {
        return this.getChromosomeAnnotationMap(0).get(sequenceName);
    }

    public List<T> getAnnotationsForSequence(String sequenceName, int setNumber) {
        return this.getChromosomeAnnotationMap(setNumber).get(sequenceName);
    }

    public Map<String, List<T>> getSequenceAnnotationMap() {
        return this.getChromosomeAnnotationMap(0);
    }

    public Map<String, List<T>> getSequenceAnnotationMap(int setNumber) {
        return this.getChromosomeAnnotationMap(setNumber);
    }

    public IntervalTree<T> getChromosomeTree(String chr, int i) {
        return this.annotationSetMap.get(i).getAnnotationTree(chr);
    }

    public IntervalTree<T> getChromosomeTree(String chr) {
        return this.annotationSetMap.get(0).getAnnotationTree(chr);
    }

    private void setChromosomeTreeMap(int i, Map<String, IntervalTree<T>> treeMap) {
        this.annotationSetMap.get(i).setAnnotationTreeMap(treeMap);
    }

    public Map<String, IntervalTree<T>> getChromosomeTreeMap(int i) {
        return this.annotationSetMap.get(i).getAnnotationTreeMap();
    }

    public Map<String, IntervalTree<T>> getChromosomeTreeMap() {
        return this.annotationSetMap.get(0).getAnnotationTreeMap();
    }

    public String getTrackInfo(int i) {
        return this.annotationSetMap.get(i).getInfoAsString();
    }

    public List<T> getChromosomeBEDs(String chr) {
        return this.getChromosomeAnnotationMap().get(chr);
    }

    protected void addAnnotationSet(AnnotationSet<T> track) {
        this.annotationSetMap.add(track);
    }

    public List<T> getChromosomeBEDs(String chr, int i) {
        return this.getChromosomeAnnotationMap(i).get(chr);
    }

    public List<T> getAnnotationList(int setNumber) {
        Map<String, List<T>> map = this.getSequenceAnnotationMap(setNumber);
        ArrayList all = new ArrayList();
        Iterator<List<T>> sequenceAnnotationIt = map.values().iterator();
        while (sequenceAnnotationIt.hasNext()) {
            all.addAll(sequenceAnnotationIt.next());
        }
        return all;
    }

    public List<T> getAnnotationList() {
        return this.getAnnotationList(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationSet<T extends GenomicAnnotation> {
        static final Pattern trackFreeFormAttributes = Pattern.compile("([^ ]+)= *\"(.+)\"");
        static final Pattern trackDeterminedAttributes = Pattern.compile("([^ ]+)= *(.+)");
        String name;
        HashMap<String, String> setFreeFormInfo = new HashMap();
        HashMap<String, String> setDeterminedInfo = new HashMap();
        Map<String, IntervalTree<T>> chromosomeAnnotationTree = new HashMap<String, IntervalTree<T>>();

        public String getInfoAsString() {
            StringBuilder buf = new StringBuilder("track ");
            if (this.name != null) {
                buf.append("name=").append(this.name).append("  ");
            }
            for (String attribute : this.setFreeFormInfo.keySet()) {
                buf.append(attribute).append("=\"").append(this.setFreeFormInfo.get(attribute)).append("\"  ");
            }
            for (String attribute : this.setDeterminedInfo.keySet()) {
                buf.append(attribute).append("=").append(this.setDeterminedInfo.get(attribute)).append("  ");
            }
            return buf.toString();
        }

        public void setInfoFromRawData(String rawInfo) {
            String value;
            String attribute;
            Matcher m = trackFreeFormAttributes.matcher(rawInfo);
            while (m.find()) {
                attribute = m.group(0);
                value = m.group(1);
                if ("name".equals(attribute)) {
                    this.name = value;
                    continue;
                }
                this.setFreeFormInfo.put(attribute, value);
            }
            m = trackDeterminedAttributes.matcher(rawInfo);
            while (m.find()) {
                attribute = m.group(0);
                value = m.group(1);
                if ("name".equals(attribute)) {
                    this.name = value;
                    continue;
                }
                this.setDeterminedInfo.put(attribute, value);
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addAnnotation(T annotation) {
            String chr = annotation.getChromosome();
            IntervalTree<Object> chrAnnotationTree = this.chromosomeAnnotationTree.get(chr);
            if (chrAnnotationTree == null) {
                chrAnnotationTree = new IntervalTree();
                this.chromosomeAnnotationTree.put(chr, chrAnnotationTree);
            }
            chrAnnotationTree.put(annotation.getStart(), annotation.getEnd(), annotation);
        }

        public IntervalTree<T> getAnnotationTree(String chr) {
            return this.chromosomeAnnotationTree.get(chr);
        }

        public Map<String, IntervalTree<T>> getAnnotationTreeMap() {
            return this.chromosomeAnnotationTree;
        }

        public void setAnnotationTreeMap(Map<String, IntervalTree<T>> map) {
            this.chromosomeAnnotationTree = map;
        }

        public Map<String, List<T>> getAsChromosomeAnnotationMap() {
            HashMap<String, List<T>> chrAnnotationMap = new HashMap<String, List<T>>(this.chromosomeAnnotationTree.size());
            for (String chr : this.chromosomeAnnotationTree.keySet()) {
                IntervalTree<T> chrTree = this.chromosomeAnnotationTree.get(chr);
                ArrayList chrAnnotations = new ArrayList(chrTree.size());
                chrAnnotationMap.put(chr, chrAnnotations);
                IntervalTree.ValuesIterator annotationIt = new IntervalTree.ValuesIterator(chrTree.iterator());
                while (annotationIt.hasNext()) {
                    chrAnnotations.add(annotationIt.next());
                }
            }
            return chrAnnotationMap;
        }
    }
}

