/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.annotation;

import edu.mit.broad.prodinfo.annotation.AnnotationFactory;
import edu.mit.broad.prodinfo.annotation.BED;
import edu.mit.broad.prodinfo.annotation.GFF;
import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFactoryFactory {
    public static BEDFactory bedFactory = new BEDFactory();
    public static GFFFactory gffFactory = new GFFFactory();
    public static BasicGenomicFactory basicGenomicAnnotationfactory = new BasicGenomicFactory();

    public static AnnotationFactory<? extends GenomicAnnotation> getFactory(String annotationType) {
        if ("BED".equalsIgnoreCase(annotationType)) {
            return bedFactory;
        }
        if ("GFF".equalsIgnoreCase(annotationType)) {
            return gffFactory;
        }
        return basicGenomicAnnotationfactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicGenomicFactory
    implements AnnotationFactory<BasicGenomicAnnotation> {
        @Override
        public BasicGenomicAnnotation create(String[] rawFields) throws ParseException {
            return new BasicGenomicAnnotation(rawFields);
        }

        @Override
        public BasicGenomicAnnotation create(GenomicAnnotation a) {
            return new BasicGenomicAnnotation(a);
        }

        @Override
        public BasicGenomicAnnotation create(String name) {
            return new BasicGenomicAnnotation(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GFFFactory
    implements AnnotationFactory<GFF> {
        @Override
        public GFF create(String[] rawFields) throws ParseException {
            return new GFF(rawFields);
        }

        @Override
        public GFF create(GenomicAnnotation a) {
            return new GFF(a);
        }

        @Override
        public GFF create(String name) {
            return new GFF(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BEDFactory
    implements AnnotationFactory<BED> {
        @Override
        public BED create(String[] rawFields) throws ParseException {
            return new BED(rawFields);
        }

        @Override
        public BED create(GenomicAnnotation a) {
            return new BED(a);
        }

        @Override
        public BED create(String name) {
            return new BED(name);
        }
    }
}

