/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.util.Vector;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PreorderTreeIterator;

public final class Util {
    public static void addIntoVector(Vector from, Vector addto) {
        int i = 0;
        while (i < from.size()) {
            addto.addElement(from.elementAt(i));
            ++i;
        }
    }

    public static String sanitize(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() < 1;
    }

    public static double atLeastZero(double d) {
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    public static int roundToInt(double d) {
        return (int)(d + 0.5);
    }

    public static String StringArrayToString(String[] a) {
        StringBuffer sb = new StringBuffer();
        if (a != null && a.length > 0) {
            int i = 0;
            while (i < a.length - 1) {
                sb.append(String.valueOf(a[i]) + ", ");
                ++i;
            }
            sb.append(a[a.length - 1]);
        }
        return sb.toString();
    }

    public static String removeWhiteSpace(String s) {
        int i = 0;
        while (i <= s.length() - 1) {
            if (s.charAt(i) == ' ' || s.charAt(i) == '\t' || s.charAt(i) == '\n' || s.charAt(i) == '\r') {
                s = String.valueOf(s.substring(0, i)) + s.substring(i + 1);
                --i;
            }
            ++i;
        }
        return s;
    }

    public static boolean doIntersect(String[] a, String[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length < 1 || b.length < 1) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            String ai = a[i];
            int j = 0;
            while (j < b.length) {
                if (ai != null && b[j] != null && ai.equals(b[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private Util() {
    }

    public static void cleanSpeciesNamesInExtNodes(Phylogeny tree) {
        PhylogenyNode node = tree.getFirstExternalNode();
        String species = "";
        int i = 0;
        while (node != null) {
            species = node.getTaxonomy().trim();
            if (species.length() > 0) {
                i = species.indexOf("/");
                if (i >= 0) {
                    species = species.substring(0, i);
                }
                if ((i = species.indexOf("_")) >= 0) {
                    species = species.substring(0, i);
                }
                if ((i = species.indexOf("-")) >= 0) {
                    species = species.substring(0, i);
                }
                if ((i = species.indexOf("\\")) >= 0) {
                    species = species.substring(0, i);
                }
                if ((i = species.indexOf(";")) >= 0) {
                    species = species.substring(0, i);
                }
                if ((i = species.indexOf(".")) >= 0) {
                    species = species.substring(0, i);
                }
                node.setTaxonomy(species);
            }
            node = node.getNextExternalNode();
        }
    }

    public static void extractSpeciesNameFromSeqName(Phylogeny tree) {
        PreorderTreeIterator it = null;
        int i = 0;
        it = new PreorderTreeIterator(tree);
        String seqname = "";
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.getTaxonomy().length() >= 1) continue;
            seqname = n.getSeqName();
            i = seqname.lastIndexOf("_");
            if (i >= 0) {
                seqname.trim();
                seqname = seqname.substring(i + 1);
                i = seqname.indexOf("/");
                if (i >= 0) {
                    seqname = seqname.substring(0, i);
                }
                if ((i = seqname.indexOf("-")) >= 0) {
                    seqname = seqname.substring(0, i);
                }
                if ((i = seqname.indexOf("\\")) >= 0) {
                    seqname = seqname.substring(0, i);
                }
                if ((i = seqname.indexOf(";")) >= 0) {
                    seqname = seqname.substring(0, i);
                }
                if ((i = seqname.indexOf(".")) >= 0) {
                    seqname = seqname.substring(0, i);
                }
                n.setTaxonomy(seqname);
                continue;
            }
            n.setTaxonomy(seqname);
        }
    }
}

