/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.io.File;
import org.forester.io.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.parsers.nhx.NHXParser;

public final class transfersBranchLenghts {
    public static void main(String[] args) {
        Phylogeny tree1 = null;
        Phylogeny tree2 = null;
        File f1 = null;
        File f2 = null;
        File f3 = null;
        boolean reroot = false;
        if (args.length != 3 && args.length != 4) {
            System.err.println("transfersBranchLenghts: Wrong number of arguments. Usage: \"java transfersBranchLenghts <treefile with correct b.l.> <treefile with bootstraps><outputfile> [R to reroot both trees in the same manner]\"");
            System.exit(-1);
        }
        if (args.length == 4 && args[3].equals("R")) {
            reroot = true;
        }
        try {
            f1 = new File(args[0]);
            f2 = new File(args[1]);
            f3 = new File(args[2]);
            if (f3.exists()) {
                System.err.println("transfersBranchLenghts: " + f3.getAbsolutePath() + " does already exist.");
                System.exit(-1);
            }
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            tree1 = factory.create(f1, new NHXParser())[0];
            tree2 = factory.create(f2, new NHXParser())[0];
        }
        catch (Exception e) {
            System.err.println("treeCombine: Could not read tree(s): " + e);
            System.exit(-1);
        }
        if (reroot) {
            try {
                PhylogenyNode tree2extnode0 = tree2.getFirstExternalNode();
                tree2.reRoot(tree2extnode0);
                tree2.adjustNodeCount(false);
                tree1.reRoot(tree1.getNode(tree2extnode0.getSeqName()));
                tree1.adjustNodeCount(false);
            }
            catch (Exception e) {
                System.err.println("Exception during rerooting" + e);
                System.exit(-1);
            }
        }
        try {
            double max_bs;
            if (tree2.getFirstExternalNode().getParent() != null && tree2.getFirstExternalNode().getParent().getBootstrap() == -99.0) {
                System.out.println();
                System.out.println("transfersBranchLengths: WARNING: Phylogeny \"" + f2 + "\" seems to have unusual bootstrap values.");
                transfersBranchLenghts.moveBranchLengthsToBootstrap(tree2);
                max_bs = tree2.getMaximumBootstrapValue();
                System.out.println("Maximum bootstrap value is: " + max_bs);
                System.out.println("Will normalize bootstrap values to 100.");
                System.out.println();
                tree2.normalizeBootstrapValues(max_bs, 100.0);
            } else {
                max_bs = tree2.getMaximumBootstrapValue();
                System.out.println("Maximum bootstrap value is: " + max_bs);
            }
            transfersBranchLenghts.copyBranchLengthValues(tree1, tree2);
        }
        catch (Exception e) {
            System.err.println("Exception during copying of branch length values:" + e);
            System.exit(-1);
        }
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(tree2, f3);
        }
        catch (Exception e) {
            System.err.println("Could not write tree: " + e);
            System.exit(-1);
        }
    }

    private static final void copyBranchLengthValues(Phylogeny from, Phylogeny to) {
        PhylogenyNode node2;
        PhylogenyNode node0 = null;
        PhylogenyNode node2_ = null;
        PhylogenyNode node1_ = null;
        PhylogenyNode[] nodes1 = null;
        PhylogenyNode[] nodes2 = null;
        int i = 0;
        if (to.isEmpty() || from.isEmpty()) {
            return;
        }
        to.setIndicatorsToZero();
        from.setIndicatorsToZero();
        PhylogenyNode node1 = to.getFirstExternalNode();
        while (node1 != null) {
            node2 = node1;
            while (node2 != null) {
                if (!node2.isExternal()) {
                    node2.setDistanceToParent(0.0);
                }
                node2 = node2.getParent();
            }
            node1 = node1.getNextExternalNode();
        }
        node1 = from.getFirstExternalNode();
        while (node1 != null) {
            node2 = node1;
            while (node2 != null) {
                if (node2.getIndicator() == 0 && !node2.isPseudoNode()) {
                    node2.setIndicator(1);
                    nodes2 = node2.copyAllExtChildren();
                    node0 = nodes2[0];
                    ++i;
                    node1_ = to.getFirstExternalNode();
                    while (node1_ != null) {
                        node2_ = node1_;
                        if (node0.equals(node1_)) {
                            while (node2_ != null) {
                                if (node2_.getIndicator() != i && node2_.getIndicator() != -1) {
                                    node2_.setIndicator(i);
                                    if (nodes2.length == node2_.getSumExtNodes()) {
                                        nodes1 = node2_.copyAllExtChildren();
                                        if (PhylogenyNode.compareArraysOfNodes(nodes2, nodes1)) {
                                            node2_.setIndicator(-1);
                                            node2_.setDistanceToParent(node2.getDistanceToParent());
                                        } else {
                                            String message = "Trees were ";
                                            message = String.valueOf(message) + "not identical.";
                                            throw new IllegalArgumentException(message);
                                        }
                                    }
                                }
                                node2_ = node2_.getParent();
                            }
                        }
                        node1_ = node1_.getNextExternalNode();
                    }
                }
                node2 = node2.getParent();
            }
            node1 = node1.getNextExternalNode();
        }
        if (!from.isRooted()) {
            to.setRooted(false);
        } else {
            to.setRooted(true);
        }
        PhylogenyNode.setNodeCount(to.preorderReID(PhylogenyNode.getNodeCount() + 1));
    }

    private static final void moveBranchLengthsToBootstrap(Phylogeny p) {
        PhylogenyNodeIterator iter = p.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.isInternal() && node.getDistanceToParent() > 0.0) {
                node.setBootstrap((int)node.getDistanceToParent());
            } else {
                node.setBootstrap(-99.0);
            }
            node.setDistanceToParent(-99.0);
        }
    }
}

