/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.parsers.nhx.NHXParser;
import org.forester.util.Util;

public class printAllSpecies {
    public static void main(String[] args) {
        Phylogeny tree = null;
        PhylogenyNode node = null;
        PrintWriter out = null;
        File infile = null;
        File outfile = null;
        if (args.length != 2) {
            System.err.println("\nprintAllSpecies: Wrong number of arguments.");
            System.err.println("Usage: \"java printAllSpecies <infile> <outfile>\"\n");
            System.exit(-1);
        }
        infile = new File(args[0]);
        outfile = new File(args[1]);
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            tree = factory.create(infile, new NHXParser())[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        Util.cleanSpeciesNamesInExtNodes(tree);
        node = tree.getFirstExternalNode();
        try {
            try {
                out = new PrintWriter((Writer)new FileWriter(outfile), true);
                while (node != null) {
                    out.println(node.getTaxonomy());
                    node = node.getNextExternalNode();
                }
            }
            catch (Exception e) {
                System.err.println(e + "\nException during writing.\n");
                System.exit(-1);
            }
        }
        finally {
            out.close();
        }
    }
}

