/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.parsers.xml;

import java.net.MalformedURLException;
import java.net.URL;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.TagValueUnit;
import org.forester.phylogeny.parsers.PhylogenyParserException;
import org.forester.phylogeny.parsers.xml.CladeAnnotationElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class SimplePhyloXMLParser1Handler1
extends DefaultHandler {
    private int _cladeLevel;
    private boolean _inPhylogeny;
    private String _currentElementName;
    private Phylogeny _phylogeny;
    private CladeAnnotationElement _cladeAnnotationElement;
    private PhylogenyNode _current_node;

    SimplePhyloXMLParser1Handler1() {
        this.initialize();
    }

    public void startDocument() throws SAXException {
        this.initialize();
    }

    public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        this.setCurrentElementName(qualifiedName);
        if (qualifiedName.equals("clade")) {
            this.increaseCladeLevel();
            this.setCladeAnnotationElement(new CladeAnnotationElement("", "", "", null));
            this.newClade();
        } else if (qualifiedName.equals("phylogeny")) {
            this.setInPhylogeny(true);
            this.setCladeAnnotationElement(new CladeAnnotationElement("", "", "", null));
            this.newPhylogeny();
        } else {
            CladeAnnotationElement element = new CladeAnnotationElement(namespaceUri, localName, qualifiedName, attributes);
            this.getCladeAnnotationElement().addChildElement(element);
            this.setCladeAnnotationElement(element);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void endElement(String namespaceUri, String localName, String qualifiedName) throws SAXException {
        if (this.getCladeLevel() == 0 && this.isInPhylogeny() && !qualifiedName.equals("phylogeny")) {
            try {
                SimplePhyloXMLParser1Handler1.mapCladeAnnotationElementToPhylogeny(this.getCladeAnnotationElement(), this.getPhylogeny());
            }
            catch (PhylogenyParserException ex) {
                throw new SAXException(ex.getMessage());
            }
        } else if (qualifiedName.equals("clade")) {
            this.decreaseCladeLevel();
            try {
                SimplePhyloXMLParser1Handler1.mapCladeAnnotationElementToPhylogenyNode(this.getCladeAnnotationElement(), this.getCurrentNode());
                if (this.getCurrentNode().isRoot()) ** GOTO lbl22
                this.setCurrentNode(this.getCurrentNode().getParent());
            }
            catch (PhylogenyParserException ex) {
                throw new SAXException(ex.getMessage());
            }
        } else if (qualifiedName.equals("phylogeny")) {
            this.setInPhylogeny(false);
            this.finishPhylogeny();
        } else if (this.getCladeAnnotationElement().getParent() != null) {
            this.setCladeAnnotationElement(this.getCladeAnnotationElement().getParent());
        }
lbl22:
        // 7 sources

        this.setCurrentElementName(null);
    }

    public void characters(char[] chars, int startIndex, int endIndex) {
        String data = new String(chars, startIndex, endIndex).trim();
        if (this.getCurrentElementName() != null && !this.getCurrentElementName().equals("clade") && !this.getCurrentElementName().equals("phylogeny")) {
            this.getCladeAnnotationElement().setValue(data);
        }
    }

    private void initialize() {
        this.setPhylogeny(null);
        this.setCurrentNode(null);
        this.setCurrentElementName(null);
        this.setCladeAnnotationElement(null);
        this.setCladeLevel(0);
        this.setInPhylogeny(false);
    }

    private void newPhylogeny() {
        this.setPhylogeny(new Phylogeny());
    }

    private void newClade() {
        if (this.getCurrentNode() == null) {
            this.initCurrentNode();
        } else {
            this.addNode();
        }
    }

    private void addNode() {
        PhylogenyNode new_node = new PhylogenyNode();
        this.getCurrentNode().addAsChild(new_node);
        this.setCurrentNode(new_node);
    }

    private void finishPhylogeny() throws SAXException {
        this.getPhylogeny().adjustNodeCount(false);
    }

    private void initCurrentNode() {
        if (this.getCurrentNode() != null) {
            throw new IllegalStateException("Attempt to create new current node when current node already exists.");
        }
        if (this.getPhylogeny() == null) {
            throw new IllegalStateException("Attempt to create new current node for non-existing phylogeny.");
        }
        PhylogenyNode node = new PhylogenyNode();
        this.getPhylogeny().setRoot(node);
        this.setCurrentNode(this.getPhylogeny().getRoot());
    }

    private void setPhylogeneyName(String data) {
        this.getPhylogeny().setName(data);
    }

    Phylogeny getPhylogeny() {
        return this._phylogeny;
    }

    private void setPhylogeny(Phylogeny phylogeny) {
        this._phylogeny = phylogeny;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private void setCurrentNode(PhylogenyNode current_node) {
        this._current_node = current_node;
    }

    private void setCladeAnnotationElement(CladeAnnotationElement saxElement) {
        this._cladeAnnotationElement = saxElement;
    }

    private CladeAnnotationElement getCladeAnnotationElement() {
        return this._cladeAnnotationElement;
    }

    private int getCladeLevel() {
        return this._cladeLevel;
    }

    private void setCladeLevel(int cladeLevel) {
        if (cladeLevel < 0) {
            throw new IllegalArgumentException("Attempt to set clade level to a number smaller than zero.");
        }
        this._cladeLevel = cladeLevel;
    }

    private void increaseCladeLevel() {
        ++this._cladeLevel;
    }

    private void decreaseCladeLevel() {
        if (this._cladeLevel < 0) {
            throw new IllegalStateException("Attempt to decrease clade level beyond zero.");
        }
        --this._cladeLevel;
    }

    private boolean isInPhylogeny() {
        return this._inPhylogeny;
    }

    private void setInPhylogeny(boolean inPhylogeny) {
        this._inPhylogeny = inPhylogeny;
    }

    private String getCurrentElementName() {
        return this._currentElementName;
    }

    private void setCurrentElementName(String currentElementName) {
        this._currentElementName = currentElementName;
    }

    private static void mapCladeAnnotationElementToPhylogeny(CladeAnnotationElement annotationElement, Phylogeny phylogeny) throws PhylogenyParserException {
        CladeAnnotationElement root = annotationElement.getRoot();
        int i = 0;
        while (i < root.getNumberOfChildElements()) {
            CladeAnnotationElement element = root.getChildElement(i);
            String qualifiedName = element.getQualifiedName();
            if (qualifiedName.equals("name")) {
                phylogeny.setName(element.getValueAsString());
            } else if (qualifiedName.equals("description")) {
                phylogeny.setDescription(element.getValueAsString());
            }
            ++i;
        }
    }

    private static void mapCladeAnnotationElementToPhylogenyNode(CladeAnnotationElement annotationElement, PhylogenyNode node) throws PhylogenyParserException {
        CladeAnnotationElement root = annotationElement.getRoot();
        int i = 0;
        while (i < root.getNumberOfChildElements()) {
            CladeAnnotationElement element = root.getChildElement(i);
            String qualifiedName = element.getQualifiedName();
            if (qualifiedName.equals("sequence_name")) {
                node.setSeqName(element.getValueAsString());
            } else if (qualifiedName.equals("taxonomy")) {
                node.setTaxonomy(element.getValueAsString());
            } else if (qualifiedName.equals("taxonomy_id")) {
                node.setTaxonomyID(element.getValueAsString());
            } else if (qualifiedName.equals("distance")) {
                node.setDistanceToParent(element.getValueAsDouble());
            } else if (qualifiedName.equals("is_duplication")) {
                node.setDuplication(element.getValueAsBoolean());
            } else if (qualifiedName.equals("confidence")) {
                if (SimplePhyloXMLParser1Handler1.attributeEqualsValue(element, "type", "bootstrap")) {
                    node.setBootstrap(element.getValueAsInt());
                }
            } else if (qualifiedName.equals("color")) {
                if (SimplePhyloXMLParser1Handler1.attributeEqualsValue(element, "type", "rgb")) {
                    int red = 0;
                    int green = 0;
                    int blue = 0;
                    int j = 0;
                    while (j < element.getNumberOfChildElements()) {
                        CladeAnnotationElement c = element.getChildElement(j);
                        if (c.getQualifiedName().equals("red")) {
                            red = c.getValueAsInt();
                        } else if (c.getQualifiedName().equals("green")) {
                            green = c.getValueAsInt();
                        } else if (c.getQualifiedName().equals("blue")) {
                            blue = c.getValueAsInt();
                        }
                        node.setColor(red, green, blue);
                        ++j;
                    }
                }
            } else if (element.getNumberOfChildElements() == 0 && element.getAttributes().size() < 4) {
                TagValueUnit tvu = null;
                boolean for_node = SimplePhyloXMLParser1Handler1.attributeEqualsValue(element, "property", "node");
                if (SimplePhyloXMLParser1Handler1.attributeEqualsValue(element, "type", "long")) {
                    tvu = new TagValueUnit(qualifiedName, element.getValueAsInt(), SimplePhyloXMLParser1Handler1.getAtttributeValue(element, "unit"));
                } else if (SimplePhyloXMLParser1Handler1.attributeEqualsValue(element, "type", "double")) {
                    tvu = new TagValueUnit(qualifiedName, element.getValueAsDouble(), SimplePhyloXMLParser1Handler1.getAtttributeValue(element, "unit"));
                } else if (SimplePhyloXMLParser1Handler1.attributeEqualsValue(element, "type", "url")) {
                    try {
                        tvu = new TagValueUnit(qualifiedName, new URL(element.getValueAsString()));
                    }
                    catch (MalformedURLException e) {
                        throw new PhylogenyParserException(e.getMessage());
                    }
                } else {
                    tvu = SimplePhyloXMLParser1Handler1.attributeEqualsValue(element, "type", "boolean") ? new TagValueUnit(qualifiedName, element.getValueAsBoolean()) : new TagValueUnit(qualifiedName, element.getValueAsString(), SimplePhyloXMLParser1Handler1.getAtttributeValue(element, "unit"));
                }
                node.addCustomTagValue(tvu, for_node);
            }
            ++i;
        }
    }

    private static boolean attributeEqualsValue(CladeAnnotationElement element, String attributeName, String attributeValue) {
        String attr = element.getAttribute(attributeName);
        return attr != null && attr.equals(attributeValue);
    }

    private static String getAtttributeValue(CladeAnnotationElement element, String attributeName) {
        String attr = element.getAttribute(attributeName);
        if (attr != null) {
            return attr;
        }
        return "";
    }
}

