/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.parsers.xml;

import java.util.ArrayList;
import java.util.HashMap;
import org.forester.phylogeny.parsers.PhylogenyParserException;
import org.xml.sax.Attributes;

public class CladeAnnotationElement {
    public static final boolean DEBUG = true;
    private final String _namespaceUri;
    private final String _localName;
    private final String _qualifiedName;
    private String _value;
    private final HashMap _attributes;
    private final ArrayList _childElements;
    private CladeAnnotationElement _parent;

    CladeAnnotationElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) {
        this._namespaceUri = namespaceUri;
        this._localName = localName;
        this._qualifiedName = qualifiedName;
        if (attributes != null) {
            this._attributes = new HashMap(attributes.getLength());
            int i = 0;
            while (i < attributes.getLength()) {
                this.getAttributes().put(new String(attributes.getQName(i)), new String(attributes.getValue(i)));
                ++i;
            }
        } else {
            this._attributes = new HashMap();
        }
        this._childElements = new ArrayList();
        this._parent = null;
    }

    void setValue(String value) {
        this._value = new String(value);
        System.out.println();
        System.out.println("Value is \"" + value + "\" for");
        System.out.println("Local name     = " + this.getLocalName());
        System.out.println("Qualified name = " + this.getQualifiedName());
        System.out.println("Namespace URI  = " + this.getNamespaceUri());
        System.out.print("Attributes     : ");
        for (String key : this.getAttributes().keySet()) {
            System.out.print(String.valueOf(key) + " = \"" + this.getAttributes().get(key) + "\"  ");
        }
        System.out.println();
        System.out.println();
    }

    String getValueAsString() {
        return this._value;
    }

    double getValueAsDouble() throws PhylogenyParserException {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.getValueAsString());
        }
        catch (NumberFormatException ex) {
            throw new PhylogenyParserException("Attempt to parse + \"" + this.getValueAsString() + "\" into double");
        }
        return d;
    }

    int getValueAsInt() throws PhylogenyParserException {
        int i = 0;
        try {
            i = Integer.parseInt(this.getValueAsString());
        }
        catch (NumberFormatException ex) {
            throw new PhylogenyParserException("Attempt to parse + \"" + this.getValueAsString() + "\" into integer");
        }
        return i;
    }

    boolean getValueAsBoolean() throws PhylogenyParserException {
        boolean b = false;
        try {
            b = new Boolean(this.getValueAsString());
        }
        catch (NumberFormatException ex) {
            throw new PhylogenyParserException("Attempt to parse + \"" + this.getValueAsString() + "\" into boolean");
        }
        return b;
    }

    String getNamespaceUri() {
        return this._namespaceUri;
    }

    String getLocalName() {
        return this._localName;
    }

    String getQualifiedName() {
        return this._qualifiedName;
    }

    HashMap getAttributes() {
        return this._attributes;
    }

    String getAttribute(String name) {
        return (String)this.getAttributes().get(name);
    }

    ArrayList getChildElements() {
        return this._childElements;
    }

    int getNumberOfChildElements() {
        return this.getChildElements().size();
    }

    CladeAnnotationElement getParent() {
        return this._parent;
    }

    void setParent(CladeAnnotationElement parent) {
        this._parent = parent;
    }

    CladeAnnotationElement getChildElement(int i) {
        if (i < 0 || i >= this.getNumberOfChildElements()) {
            throw new IllegalArgumentException("Attempt to get child element with index " + i + " for element with " + this.getNumberOfChildElements() + " child elements");
        }
        return (CladeAnnotationElement)this.getChildElements().get(i);
    }

    void addChildElement(CladeAnnotationElement element) {
        element.setParent(this);
        this.getChildElements().add(element);
    }

    CladeAnnotationElement getRoot() {
        CladeAnnotationElement e = this;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        return e;
    }
}

