/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.parsers.nhx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import org.forester.development.Development;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.parsers.PhylogenyParser;
import org.forester.phylogeny.parsers.PhylogenyParserException;

public final class NHXParser
implements PhylogenyParser {
    private static final boolean DEBUG = Development.isDebug();
    private static final boolean TIME = Development.isTime();
    private static final byte STRING = 0;
    private static final byte STRING_BUFFER = 1;
    private static final byte CHAR_ARRAY = 2;
    private static final byte BUFFERED_READER = 3;
    private boolean _saw_closing_paren;
    private byte _input_type;
    private int _source_length;
    private PhylogenyNode _current_node;
    private StringBuffer _current_anotation;
    private Object _nhx_source;
    private int _clade_level;
    private ArrayList _phylogenies;
    private Phylogeny _current_phylogeny;

    public void setSource(Object nhx_source) throws IOException {
        if (nhx_source == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        if (nhx_source instanceof String) {
            this.setInputType((byte)0);
            this.setSourceLength(((String)nhx_source).length());
            this.setNhxSource(nhx_source);
        } else if (nhx_source instanceof StringBuffer) {
            this.setInputType((byte)1);
            this.setSourceLength(((StringBuffer)nhx_source).length());
            this.setNhxSource(nhx_source);
        } else if (nhx_source instanceof char[]) {
            this.setInputType((byte)2);
            this.setSourceLength(((char[])nhx_source).length);
            this.setNhxSource(nhx_source);
        } else if (nhx_source instanceof File) {
            this.setInputType((byte)3);
            this.setSourceLength(0);
            File f = (File)nhx_source;
            if (!f.exists()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" does not exist.");
            }
            if (!f.isFile()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" is not a file.");
            }
            if (!f.canRead()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" is not a readable.");
            }
            this.setNhxSource(new BufferedReader(new FileReader(f)));
        } else if (nhx_source instanceof InputStream) {
            this.setInputType((byte)3);
            this.setSourceLength(0);
            InputStreamReader isr = new InputStreamReader((InputStream)nhx_source);
            this.setNhxSource(new BufferedReader(isr));
        } else {
            throw new IllegalArgumentException(this.getClass() + " can only parse objects of type String," + " StringBuffer, char[], File," + " or InputStream " + " [attempt to parse object of " + nhx_source.getClass() + "].");
        }
    }

    public Phylogeny[] parse() throws IOException {
        if (DEBUG) {
            System.out.println("\n[DEBUG] " + this.getClass() + ": START.");
        }
        long start_time = 0L;
        if (TIME) {
            start_time = new Date().getTime();
        }
        this.setPhylogenies(new ArrayList());
        this.setCladeLevel(0);
        this.newCurrentAnotation();
        int i = 0;
        while (true) {
            char c = '\b';
            if (this.getInputType() == 3) {
                int ci = ((BufferedReader)this.getNhxSource()).read();
                if (ci < 0) break;
                c = (char)ci;
            } else {
                if (i >= this.getSourceLength()) break;
                switch (this.getInputType()) {
                    case 0: {
                        c = ((String)this.getNhxSource()).charAt(i);
                        break;
                    }
                    case 1: {
                        c = ((StringBuffer)this.getNhxSource()).charAt(i);
                        break;
                    }
                    case 2: {
                        c = ((char[])this.getNhxSource())[i];
                    }
                }
            }
            if (c == '(') {
                this.processOpenParen();
            } else if (c == ')') {
                this.processCloseParen();
            } else if (c == ',') {
                this.processComma();
            } else if (c != '\b' && c != '\t' && c != '\n' && c != '\f' && c != '\r' && c != ' ' && (this.getCladeLevel() != 0 || c != ';')) {
                this.getCurrentAnotation().append(c);
            }
            ++i;
        }
        if (this.getCladeLevel() != 0) {
            this.setPhylogenies(null);
            throw new PhylogenyParserException("Error in NH / NHX: Most likely cause: Number of open parens does not equal number of close parens.");
        }
        if (this.getCurrentPhylogeny() != null) {
            this.finishPhylogeny();
        } else if (this.getCurrentAnotation().length() > 0) {
            this.finishSingleNodePhylogeny();
        } else if (this.getPhylogenies().size() < 1) {
            this.getPhylogenies().add(new Phylogeny());
        }
        if (TIME) {
            System.out.println("[TIME] Parsing required " + (new Date().getTime() - start_time) + "ms.");
        }
        if (DEBUG) {
            System.out.println("[DEBUG] " + this.getClass() + ": END.");
        }
        return this.getPhylogeniesAsArray();
    }

    private void processOpenParen() throws PhylogenyParserException {
        PhylogenyNode new_node = new PhylogenyNode();
        if (this.getCladeLevel() == 0) {
            if (this.getCurrentPhylogeny() != null) {
                this.finishPhylogeny();
            }
            this.setCladeLevel(1);
            this.newCurrentAnotation();
            this.setCurrentPhylogeny(new Phylogeny());
            this.getCurrentPhylogeny().setRoot(new_node);
            if (DEBUG) {
                System.out.println("[DEBUG] Starting a new Phylogeny [(].");
            }
        } else {
            if (DEBUG) {
                System.out.println("[DEBUG] [level=" + this.getCladeLevel() + "] [(].");
            }
            this.increaseCladeLevel();
            this.getCurrentNode().addAsChild(new_node);
        }
        this.setCurrentNode(new_node);
        this.setSawClosingParen(false);
    }

    private void processCloseParen() throws PhylogenyParserException {
        this.decreaseCladeLevel();
        if (!this.isSawClosingParen()) {
            PhylogenyNode new_node = new PhylogenyNode();
            new_node.parseNHX(this.getCurrentAnotation().toString());
            if (DEBUG) {
                System.out.println("[DEBUG] New node created for: " + this.getCurrentAnotation() + " [level=" + this.getCladeLevel() + "] [)].");
            }
            this.newCurrentAnotation();
            this.getCurrentNode().addAsChild(new_node);
        } else {
            this.getCurrentNode().getLastChildNode().parseNHX(this.getCurrentAnotation().toString());
            if (DEBUG) {
                System.out.println("[DEBUG] Node annotated with: " + this.getCurrentAnotation() + " [level=" + this.getCladeLevel() + "] [)].");
            }
            this.newCurrentAnotation();
        }
        if (!this.getCurrentNode().isRoot()) {
            this.setCurrentNode(this.getCurrentNode().getParent());
        }
        this.setSawClosingParen(true);
    }

    private void processComma() throws PhylogenyParserException {
        if (!this.isSawClosingParen()) {
            PhylogenyNode new_node = new PhylogenyNode();
            new_node.parseNHX(this.getCurrentAnotation().toString());
            this.getCurrentNode().addAsChild(new_node);
            if (DEBUG) {
                System.out.println("[DEBUG] New node created for: " + this.getCurrentAnotation() + " [level=" + this.getCladeLevel() + "] [,].");
            }
        } else {
            this.getCurrentNode().getLastChildNode().parseNHX(this.getCurrentAnotation().toString());
            if (DEBUG) {
                System.out.println("[DEBUG] Node annotated with: " + this.getCurrentAnotation() + " [level=" + this.getCladeLevel() + "] [,].");
            }
        }
        this.newCurrentAnotation();
        this.setSawClosingParen(false);
    }

    private void newCurrentAnotation() {
        this.setCurrentAnotation(new StringBuffer());
    }

    private void finishPhylogeny() throws PhylogenyParserException {
        this.setCladeLevel(0);
        if (this.getCurrentPhylogeny() != null) {
            this.getCurrentPhylogeny().getRoot().parseNHX(this.getCurrentAnotation().toString());
            if (DEBUG) {
                System.out.println("[DEBUG] Node annotated with: " + this.getCurrentAnotation() + " [level=" + this.getCladeLevel() + "].");
                System.out.println("[DEBUG] Completed Phylogeny: " + this.getCurrentPhylogeny().toNewHampshireX());
            }
            this.getPhylogenies().add(this.getCurrentPhylogeny());
        }
    }

    private void finishSingleNodePhylogeny() throws PhylogenyParserException {
        this.setCladeLevel(0);
        PhylogenyNode new_node = new PhylogenyNode();
        new_node.parseNHX(this.getCurrentAnotation().toString());
        this.setCurrentPhylogeny(new Phylogeny());
        this.getCurrentPhylogeny().setRoot(new_node);
        if (DEBUG) {
            System.out.println("[DEBUG] Completed single node Phylogeny: " + this.getCurrentPhylogeny().toNewHampshireX());
        }
        this.getPhylogenies().add(this.getCurrentPhylogeny());
    }

    private Phylogeny[] getPhylogeniesAsArray() {
        Phylogeny[] p = new Phylogeny[this.getPhylogenies().size()];
        int i = 0;
        while (i < this.getPhylogenies().size()) {
            p[i] = (Phylogeny)this.getPhylogenies().get(i);
            ++i;
        }
        return p;
    }

    private void increaseCladeLevel() {
        ++this._clade_level;
    }

    private void decreaseCladeLevel() throws PhylogenyParserException {
        if (this.getCladeLevel() < 0) {
            throw new PhylogenyParserException("Error in NH / NHX: Most likely cause: Number of close parens is larger than number of open parens.");
        }
        --this._clade_level;
    }

    private StringBuffer getCurrentAnotation() {
        return this._current_anotation;
    }

    private void setCurrentAnotation(StringBuffer current_anotation) {
        this._current_anotation = current_anotation;
    }

    private Object getNhxSource() {
        return this._nhx_source;
    }

    private void setNhxSource(Object nhx_source) {
        this._nhx_source = nhx_source;
    }

    private boolean isSawClosingParen() {
        return this._saw_closing_paren;
    }

    private void setSawClosingParen(boolean saw_closing_paren) {
        this._saw_closing_paren = saw_closing_paren;
    }

    private int getSourceLength() {
        return this._source_length;
    }

    private void setSourceLength(int source_length) {
        this._source_length = source_length;
    }

    private ArrayList getPhylogenies() {
        return this._phylogenies;
    }

    private void setPhylogenies(ArrayList phylogenies) {
        this._phylogenies = phylogenies;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private void setCurrentPhylogeny(Phylogeny current_phylogeny) {
        this._current_phylogeny = current_phylogeny;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private void setCurrentNode(PhylogenyNode current_node) {
        this._current_node = current_node;
    }

    private byte getInputType() {
        return this._input_type;
    }

    private void setInputType(byte input_type) {
        this._input_type = input_type;
    }

    private int getCladeLevel() {
        return this._clade_level;
    }

    private void setCladeLevel(int clade_level) {
        if (clade_level < 0) {
            throw new IllegalArgumentException("Attempt to set clade level to a number smaller than zero.");
        }
        this._clade_level = clade_level;
    }
}

